/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayEqualityOpWithArraysEqualsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionText", "isApplicable", "", "kotlin.idea"})
public final class ReplaceArrayEqualityOpWithArraysEqualsInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public ReplaceArrayEqualityOpWithArraysEqualsInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtExpression ktExpression = element3.getRight();
        if (ktExpression == null) {
            return;
        }
        KtExpression right = ktExpression;
        KtExpression ktExpression2 = element3.getLeft();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression left = ktExpression2;
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        Object[] $this$applyTo_u24lambda_u240 = objectArray = new StringBuilder();
        boolean bl = false;
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)KtTokens.EXCLEQ)) {
            $this$applyTo_u24lambda_u240.append("!");
        }
        $this$applyTo_u24lambda_u240.append("$0.contentEquals($1)");
        String string = objectArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String template2 = string;
        objectArray = new Object[]{left, right};
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)template2, (Object[])objectArray, (boolean)false, (int)4, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        IElementType iElementType = element3.getOperationToken();
        if (!(Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ))) {
            return false;
        }
        KtExpression right = element3.getRight();
        KtExpression left = element3.getLeft();
        if (right == null) return false;
        if (left == null) {
            return false;
        }
        BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)element3, null, 1, null);
        ResolvedCall rightResolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)right), (BindingContext)context2);
        ResolvedCall leftResolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)left), (BindingContext)context2);
        ResolvedCall resolvedCall2 = rightResolvedCall;
        if (resolvedCall2 == null) return false;
        if (!UtilsKt.resolvedToArrayType((ResolvedCall<? extends CallableDescriptor>)resolvedCall2)) return false;
        boolean bl = true;
        if (!bl) return false;
        ResolvedCall resolvedCall3 = leftResolvedCall;
        if (resolvedCall3 == null) return false;
        if (!UtilsKt.resolvedToArrayType((ResolvedCall<? extends CallableDescriptor>)resolvedCall3)) return false;
        return true;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("dangerous.array.comparison", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.with.contentequals3", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        IElementType iElementType = element3.getOperationToken();
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? KotlinBundle.message("replace.with.contentequals2", new Object[0]) : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? KotlinBundle.message("replace.with.contentequals", new Object[0]) : "");
    }
}

