/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.KotlinInspectionsBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R!\u0010\b\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u00030\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceStringInDocumentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "oldString", "", "newString", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/String;)V", "elementRef", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "kotlin.inspections"})
public final class ReplaceStringInDocumentFix
implements LocalQuickFix {
    @NotNull
    private final String oldString;
    @NotNull
    private final String newString;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementRef;

    public ReplaceStringInDocumentFix(@NotNull PsiElement element3, @NotNull String oldString, @NotNull String newString) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)oldString, (String)"oldString");
        Intrinsics.checkNotNullParameter((Object)newString, (String)"newString");
        this.oldString = oldString;
        this.newString = newString;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element3.getProject()).createSmartPsiElementPointer(element3);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.elementRef = smartPsiElementPointer;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement2 = this.elementRef.getElement();
        if (psiElement2 == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        PsiFile psiFile2 = element3.getContainingFile();
        Object object = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        if (object == null) {
            return;
        }
        VirtualFile virtualFile2 = object;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        String text2 = element3.getText();
        Intrinsics.checkNotNull((Object)text2);
        int index = StringsKt.indexOf$default((CharSequence)text2, (String)this.oldString, (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            return;
        }
        int start2 = element3.getTextOffset() + index;
        int end = start2 + this.oldString.length();
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        if (end > documentText.length()) {
            return;
        }
        String string2 = documentText.substring(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        if (!Intrinsics.areEqual((Object)string2, (Object)this.oldString)) {
            return;
        }
        document2.replaceString(start2, end, (CharSequence)this.newString);
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.oldString, this.newString};
        return KotlinInspectionsBundle.message("replace.0.with.1", objectArray);
    }
}

