/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "configureChangeSignature", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "parameterIndex", "", "isApplicableTo", "", "caretOffset", "startInWriteAction", "overridesJavaMethod", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertParameterToReceiverIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertParameterToReceiverIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,64:1\n142#2:65\n*S KotlinDebug\n*F\n+ 1 ConvertParameterToReceiverIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention\n*L\n58#1:65\n*E\n"})
public final class ConvertParameterToReceiverIntention
extends SelfTargetingIntention<KtParameter> {
    public ConvertParameterToReceiverIntention() {
        super(KtParameter.class, KotlinBundle.lazyMessage("convert.parameter.to.receiver", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtParameter element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement identifier2 = psiElement2;
        if (!identifier2.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        if (element3.isVarArg()) {
            return false;
        }
        KtDeclarationWithBody ktDeclarationWithBody = element3.getOwnerFunction();
        KtNamedFunction ktNamedFunction = ktDeclarationWithBody instanceof KtNamedFunction ? (KtNamedFunction)ktDeclarationWithBody : null;
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction function2 = ktNamedFunction;
        if (function2.getReceiverTypeReference() != null) {
            return false;
        }
        return !this.overridesJavaMethod(function2);
    }

    private final boolean overridesJavaMethod(KtNamedFunction $this$overridesJavaMethod) {
        if (!$this$overridesJavaMethod.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default($this$overridesJavaMethod, null, 1, null);
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        Collection collection = functionDescriptor3.getOriginal().getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
        FunctionDescriptor functionDescriptor4 = (FunctionDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
        if (functionDescriptor4 == null) {
            return false;
        }
        FunctionDescriptor baseDescriptor = functionDescriptor4;
        return baseDescriptor instanceof JavaCallableMemberDescriptor;
    }

    private final KotlinChangeSignatureConfiguration configureChangeSignature(int parameterIndex2) {
        return new KotlinChangeSignatureConfiguration(parameterIndex2){
            final /* synthetic */ int $parameterIndex;
            {
                this.$parameterIndex = $parameterIndex;
            }

            @NotNull
            public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkNotNullParameter((Object)originalDescriptor, (String)"originalDescriptor");
                return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(originalDescriptor, this.$parameterIndex){
                    final /* synthetic */ KotlinMethodDescriptor $originalDescriptor;
                    final /* synthetic */ int $parameterIndex;
                    {
                        this.$originalDescriptor = $originalDescriptor;
                        this.$parameterIndex = $parameterIndex;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinMutableMethodDescriptor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.setReceiver((KotlinParameterInfo)this.$originalDescriptor.getParameters().get(this.$parameterIndex));
                    }
                }));
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkNotNullParameter(affectedFunctions, (String)"affectedFunctions");
                return true;
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtParameter element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction function2 = ktNamedFunction;
        int parameterIndex2 = function2.getValueParameters().indexOf(element3);
        DeclarationDescriptor declarationDescriptor = KotlinRefactoringUtilKt.resolveToExpectedDescriptorIfPossible((KtDeclaration)function2);
        FunctionDescriptor functionDescriptor2 = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinChangeSignatureKt.runChangeSignature(project2, editor2, (CallableDescriptor)descriptor2, this.configureChangeSignature(parameterIndex2), (PsiElement)element3, this.getText());
    }
}

