/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.processings;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.j2k.post.processing.InspectionLikeProcessingForElement;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/processings/RemoveExplicitPropertyTypeProcessing;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingForElement;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "apply", "", "element", "isApplicableTo", "", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "kotlin.j2k.post-processing"})
@SourceDebugExtension(value={"SMAP\ninspectionLikeProcessings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inspectionLikeProcessings.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/processings/RemoveExplicitPropertyTypeProcessing\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,420:1\n118#2:421\n*S KotlinDebug\n*F\n+ 1 inspectionLikeProcessings.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/processings/RemoveExplicitPropertyTypeProcessing\n*L\n72#1:421\n*E\n"})
public final class RemoveExplicitPropertyTypeProcessing
extends InspectionLikeProcessingForElement<KtProperty> {
    public RemoveExplicitPropertyTypeProcessing() {
        super(KtProperty.class);
    }

    @Override
    protected boolean isApplicableTo(@NotNull KtProperty element3, @Nullable ConverterSettings settings2) {
        CallableDescriptor callableDescriptor;
        boolean needLocalVariablesTypes;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3.isMember() && !KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)element3))) {
            return false;
        }
        KtTypeReference typeReference2 = element3.getTypeReference();
        if (typeReference2 == null || !((Collection)typeReference2.getAnnotationEntries()).isEmpty()) {
            return false;
        }
        ConverterSettings converterSettings = settings2;
        boolean bl = converterSettings != null ? converterSettings.getSpecifyLocalVariableTypeByDefault() : (needLocalVariablesTypes = false);
        if (needLocalVariablesTypes && element3.isLocal()) {
            return false;
        }
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) {
            return false;
        }
        KtExpression initializer2 = ktExpression;
        KotlinType kotlinType = ExtendedResolutionApiKt.analyzeInContext$default(initializer2, ScopeUtils.getResolutionScope((KtElement)initializer2), null, null, null, null, false, null, null, 254, null).getType(initializer2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType initializerType = kotlinType;
        if (element3.isMember() && FlexibleTypesKt.isFlexible((KotlinType)initializerType)) {
            return false;
        }
        VariableDescriptor $this$safeAs$iv = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
        boolean $i$f$safeAs = false;
        VariableDescriptor variableDescriptor = $this$safeAs$iv;
        if (!(variableDescriptor instanceof CallableDescriptor)) {
            variableDescriptor = null;
        }
        if ((callableDescriptor = (CallableDescriptor)variableDescriptor) == null || (callableDescriptor = callableDescriptor.getReturnType()) == null) {
            return false;
        }
        CallableDescriptor propertyType = callableDescriptor;
        return KotlinTypeChecker.DEFAULT.equalTypes(initializerType, (KotlinType)propertyType);
    }

    @Override
    protected void apply(@NotNull KtProperty element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtTypeReference ktTypeReference = element3.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        PsiElement psiElement2 = element3.getColon();
        if (psiElement2 != null) {
            PsiElement followingWhiteSpace;
            Object object;
            PsiElement psiElement3;
            PsiElement colon = psiElement2;
            boolean bl = false;
            PsiElement psiElement4 = psiElement3 = colon.getNextSibling();
            if (psiElement4 != null) {
                PsiElement psiElement5;
                Intrinsics.checkNotNull((Object)psiElement4);
                PsiElement following = psiElement5 = psiElement3;
                boolean bl2 = false;
                object = following instanceof PsiWhiteSpace && UtilsKt.isInSingleLine(following) ? psiElement5 : null;
            } else {
                object = null;
            }
            PsiElement psiElement6 = followingWhiteSpace = object;
            if (psiElement6 != null) {
                psiElement6.delete();
            }
            colon.delete();
        }
        typeReference2.delete();
    }
}

