/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \n2\u00020\u0001:\u0003\n\u000b\fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0001\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "getDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkg", "Lcom/intellij/psi/PsiPackage;", "getPkg", "()Lcom/intellij/psi/PsiPackage;", "Companion", "File", "SourceDirectory", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "kotlin.refactorings.move.k2"})
public interface K2MoveTargetDescriptor {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor$Companion.$$INSTANCE;

    @NotNull
    public PsiDirectory getDirectory();

    @NotNull
    public PsiPackage getPkg();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Companion;", "", "()V", "File", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "SourceDirectory", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "directory", "Lcom/intellij/psi/PsiDirectory;", "kotlin.refactorings.move.k2"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final SourceDirectory SourceDirectory(@NotNull PsiDirectory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (psiPackage == null) {
                throw new IllegalStateException("No package was found".toString());
            }
            PsiPackage pkg = psiPackage;
            return new SourceDirectory(pkg, directory);
        }

        @NotNull
        public final File File(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            PsiDirectory psiDirectory = file2.getContainingDirectory();
            if (psiDirectory == null) {
                throw new IllegalStateException("No containing directory was found".toString());
            }
            PsiDirectory directory = psiDirectory;
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            FqName pkgDirective = ktPackageDirective != null ? ktPackageDirective.getFqName() : null;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)file2.getProject());
            Object object = pkgDirective;
            if (object == null || (object = object.asString()) == null) {
                object = "";
            }
            PsiPackage psiPackage = javaPsiFacade.findPackage((String)object);
            if (psiPackage == null) {
                throw new IllegalStateException("No package was found".toString());
            }
            PsiPackage pkg = psiPackage;
            return new File(file2, pkg, directory);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "pkg", "Lcom/intellij/psi/PsiPackage;", "directory", "Lcom/intellij/psi/PsiDirectory;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/PsiDirectory;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.refactorings.move.k2"})
    public static final class File
    extends SourceDirectory {
        @NotNull
        private final KtFile file;

        public File(@NotNull KtFile file2, @NotNull PsiPackage pkg, @NotNull PsiDirectory directory) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            super(pkg, directory);
            this.file = file2;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "pkg", "Lcom/intellij/psi/PsiPackage;", "directory", "Lcom/intellij/psi/PsiDirectory;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/PsiDirectory;)V", "getDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getPkg", "()Lcom/intellij/psi/PsiPackage;", "kotlin.refactorings.move.k2"})
    public static class SourceDirectory
    implements K2MoveTargetDescriptor {
        @NotNull
        private final PsiPackage pkg;
        @NotNull
        private final PsiDirectory directory;

        public SourceDirectory(@NotNull PsiPackage pkg, @NotNull PsiDirectory directory) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.pkg = pkg;
            this.directory = directory;
        }

        @Override
        @NotNull
        public PsiPackage getPkg() {
            return this.pkg;
        }

        @Override
        @NotNull
        public PsiDirectory getDirectory() {
            return this.directory;
        }
    }
}

