/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.intentions.AddAnnotationUseSiteTargetIntentionKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationUseSiteTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "useSiteTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Ljava/util/List;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddAnnotationUseSiteTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<AnnotationUseSiteTarget> useSiteTargets;

    public AddAnnotationUseSiteTargetFix(@NotNull KtAnnotationEntry annotationEntry2, @NotNull List<? extends AnnotationUseSiteTarget> useSiteTargets) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        Intrinsics.checkNotNullParameter(useSiteTargets, (String)"useSiteTargets");
        super((PsiElement)annotationEntry2);
        this.useSiteTargets = useSiteTargets;
    }

    @NotNull
    public String getText() {
        String string;
        if (this.useSiteTargets.size() == 1) {
            Object[] objectArray = new Object[]{((AnnotationUseSiteTarget)CollectionsKt.first(this.useSiteTargets)).getRenderName()};
            string = KotlinBundle.message("text.add.use.site.target.0", objectArray);
        } else {
            string = KotlinBundle.message("add.use.site.target", new Object[0]);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
            if (ktAnnotationEntry == null) break block0;
            AddAnnotationUseSiteTargetIntentionKt.addUseSiteTarget(ktAnnotationEntry, this.useSiteTargets, editor2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationUseSiteTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement2 instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement2 : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            List<AnnotationUseSiteTarget> applicableUseSiteTargets2 = AddAnnotationUseSiteTargetIntentionKt.applicableUseSiteTargets(entry);
            if (applicableUseSiteTargets2.isEmpty()) {
                return null;
            }
            return new AddAnnotationUseSiteTargetFix(entry, applicableUseSiteTargets2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

