/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.quickfix.ConvertStringToCharLiteralFix;
import org.jetbrains.kotlin.idea.quickfix.EqualityNotApplicableFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.NumberConversionFix;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/EqualityNotApplicableFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isNumberType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.idea"})
public final class EqualityNotApplicableFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final EqualityNotApplicableFactory INSTANCE = new EqualityNotApplicableFactory();

    private EqualityNotApplicableFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KtStringTemplateExpression stringTemplate;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticWithParameters3 diagnosticWithParameters = (DiagnosticWithParameters3)Errors.EQUALITY_NOT_APPLICABLE.cast((UnboundDiagnostic)diagnostic);
        PsiElement psiElement2 = diagnostic.getPsiElement();
        KtBinaryExpression ktBinaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
        if (ktBinaryExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtBinaryExpression binaryExpr = ktBinaryExpression;
        KtExpression ktExpression = binaryExpr.getLeft();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = binaryExpr.getRight();
        if (ktExpression2 == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression right = ktExpression2;
        Object object = diagnosticWithParameters.getB();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-b>(...)");
        KotlinType leftType = (KotlinType)object;
        Object object2 = diagnosticWithParameters.getC();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-c>(...)");
        KotlinType rightType = (KotlinType)object2;
        if (this.isNumberType(leftType) && this.isNumberType(rightType)) {
            Object[] objectArray = new NumberConversionFix[]{new NumberConversionFix(left, leftType, rightType, null, true, doCreateActions.1.INSTANCE, 8, null), new NumberConversionFix(right, rightType, leftType, null, true, doCreateActions.2.INSTANCE, 8, null)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        boolean leftHandSideIsChar = TypeUtilsKt.isChar((KotlinType)leftType);
        boolean rightHandSideIsChar = TypeUtilsKt.isChar((KotlinType)rightType);
        if ((leftHandSideIsChar && right instanceof KtStringTemplateExpression || rightHandSideIsChar && left instanceof KtStringTemplateExpression) && ConvertStringToCharLiteralFix.Companion.isApplicable(stringTemplate = (KtStringTemplateExpression)(leftHandSideIsChar ? right : left))) {
            return CollectionsKt.listOf((Object)new ConvertStringToCharLiteralFix(stringTemplate));
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isNumberType(KotlinType $this$isNumberType) {
        return TypeUtilsKt.isSignedOrUnsignedNumberType((KotlinType)TypeUtilsKt.makeNotNullable((KotlinType)$this$isNumberType));
    }
}

