/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.importFix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.renderer.declarations.KtDeclarationRenderer;
import org.jetbrains.kotlin.analysis.api.renderer.declarations.impl.KtDeclarationRendererForSource;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtJavaFieldSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtNamedSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionInfo;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.KtSymbolFromIndexProvider;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinIconProvider;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.K2StatisticsInfoProvider;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinDiagnosticFixFactory;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinDiagnosticFixFactoryKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixActionBase;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.idea.quickfix.ImportPrioritizer;
import org.jetbrains.kotlin.idea.quickfix.importFix.AnnotationImportCandidatesProvider;
import org.jetbrains.kotlin.idea.quickfix.importFix.CallableImportCandidatesProvider;
import org.jetbrains.kotlin.idea.quickfix.importFix.ClassifierImportCandidatesProvider;
import org.jetbrains.kotlin.idea.quickfix.importFix.ExpressionImportWeigher;
import org.jetbrains.kotlin.idea.quickfix.importFix.ImportCandidatesProvider;
import org.jetbrains.kotlin.idea.quickfix.importFix.ImportQuickFix;
import org.jetbrains.kotlin.idea.quickfix.importFix.InfixCallableImportCandidatesProvider;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.positionContext.KDocLinkNamePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KDocParameterNamePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinAnnotationTypeNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinCallableReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinExpressionNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinImportDirectivePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinInfixCallPositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinPackageDirectivePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinPositionContextDetector;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinRawPositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinSuperReceiverNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinSuperTypeCallNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinTypeNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinWithSubjectEntryPositionContext;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0003 !\"B%\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J!\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001cH\u0096\u0002J\"\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/codeInspection/HintAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "text", "", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;Ljava/util/List;)V", "modificationCountOnCreate", "", "createAddImportAction", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fixSilently", "", "getFamilyName", "getText", "invoke", "", "Lcom/intellij/psi/PsiFile;", "isAvailableImpl", "isOutdated", "showHint", "Companion", "ImportQuestionAction", "SymbolBasedAutoImportVariant", "kotlin.fir"})
public final class ImportQuickFix
extends QuickFixActionBase<KtElement>
implements HintAction,
HighPriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final List<AutoImportVariant> importVariants;
    private final long modificationCountOnCreate;
    @NotNull
    private static final KotlinDiagnosticFixFactory<KtFirDiagnostic.InvisibleReference> invisibleReferenceFactory = KotlinDiagnosticFixFactoryKt.diagnosticFixFactory(Reflection.getOrCreateKotlinClass(KtFirDiagnostic.InvisibleReference.class), Companion.invisibleReferenceFactory.1.INSTANCE);
    @NotNull
    private static final KtDeclarationRenderer renderer = KtDeclarationRendererForSource.INSTANCE.getWITH_QUALIFIED_NAMES().with((Function1<? super KtDeclarationRenderer.Builder, Unit>)((Function1)Companion.renderer.1.INSTANCE));

    public ImportQuickFix(@NotNull KtElement element3, @IntentionName @NotNull String text2, @NotNull List<? extends AutoImportVariant> importVariants) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
        super((PsiElement)element3);
        this.text = text2;
        this.importVariants = importVariants;
        if (!(!((Collection)this.importVariants).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.modificationCountOnCreate = PsiModificationTracker.getInstance((Project)element3.getProject()).getModificationCount();
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.import", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile)) {
            return;
        }
        this.createAddImportAction(project2, editor2, (KtFile)file2).execute();
    }

    private final QuestionAction createAddImportAction(Project project2, Editor editor2, KtFile file2) {
        return new ImportQuestionAction(project2, editor2, file2, this.importVariants);
    }

    public boolean showHint(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element3 = ktElement;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        TextRange elementRange = element3.getTextRange();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)((AutoImportVariant)CollectionsKt.first(this.importVariants)).getFqName().asString(), (String)"asString(...)");
        String autoImportHintText = KotlinBundle.message("fix.import.question", objectArray);
        HintManager.getInstance().showQuestionHint(editor2, autoImportHintText, elementRange.getStartOffset(), elementRange.getEndOffset(), this.createAddImportAction(project3, editor2, file2));
        return true;
    }

    public boolean fixSilently(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element3 = ktElement;
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile;
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled((PsiFile)((PsiFile)file2))) {
            return false;
        }
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        QuestionAction addImportAction = this.createAddImportAction(project3, editor2, file2);
        if (this.importVariants.size() == 1) {
            addImportAction.execute();
            return true;
        }
        return false;
    }

    private final boolean isOutdated(Project project2) {
        return this.modificationCountOnCreate != PsiModificationTracker.getInstance((Project)project2).getModificationCount();
    }

    @Override
    protected boolean isAvailableImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return super.isAvailableImpl(project2, editor2, file2) && !this.isOutdated(project2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u00020\f\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00060\u0014R\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u00020\f\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u001c\u001a\u00020\u001dR\u00020\f\u00a2\u0006\u0002\u0010\u001eJ\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u00020\f\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020#*\u00020\u0011H\u0002R\u00020\f\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00010&*\u00020\u0011H\u0002R\u00020\f\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020 *\u00020\u0011H\u0002R\u00020\f\u00a2\u0006\u0002\u0010!R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix$Companion;", "", "()V", "invisibleReferenceFactory", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinDiagnosticFixFactory;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KtFirDiagnostic$InvisibleReference;", "getInvisibleReferenceFactory", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinDiagnosticFixFactory;", "renderer", "Lorg/jetbrains/kotlin/analysis/api/renderer/declarations/KtDeclarationRenderer;", "createImportFix", "Lorg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "position", "Lorg/jetbrains/kotlin/psi/KtElement;", "importCandidateSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)Lorg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix;", "createPriorityForImportableSymbol", "Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer$Priority;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer;", "prioritizer", "expressionImportWeigher", "Lorg/jetbrains/kotlin/idea/quickfix/importFix/ExpressionImportWeigher;", "symbol", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer;Lorg/jetbrains/kotlin/idea/quickfix/importFix/ExpressionImportWeigher;Lorg/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol;)Lorg/jetbrains/kotlin/idea/quickfix/ImportPrioritizer$Priority;", "getFixes", "diagnosticPsi", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "renderSymbol", "", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol;)Ljava/lang/String;", "getFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol;)Lorg/jetbrains/kotlin/name/FqName;", "getImportKind", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol;)Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "getImportName", "kotlin.fir"})
    @SourceDebugExtension(value={"SMAP\nImportQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportQuickFix.kt\norg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 PrettyPrinter.kt\norg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinterKt\n*L\n1#1,365:1\n1#2:366\n1#2:389\n1360#3:367\n1446#3,5:368\n1549#3:374\n1620#3,3:375\n1045#3:378\n1603#3,9:379\n1855#3:388\n1856#3:390\n1612#3:391\n1549#3:392\n1620#3,3:393\n1549#3:396\n1620#3,3:397\n206#4:373\n*S KotlinDebug\n*F\n+ 1 ImportQuickFix.kt\norg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix$Companion\n*L\n292#1:389\n237#1:367\n237#1:368,5\n289#1:374\n289#1:375,3\n290#1:378\n292#1:379,9\n292#1:388\n292#1:390\n292#1:391\n300#1:392\n300#1:393,3\n304#1:396\n304#1:397,3\n255#1:373\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinDiagnosticFixFactory<KtFirDiagnostic.InvisibleReference> getInvisibleReferenceFactory() {
            return invisibleReferenceFactory;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ImportQuickFix> getFixes(@NotNull KtAnalysisSession $context_receiver_0, @NotNull PsiElement diagnosticPsi) {
            void $this$flatMapTo$iv$iv;
            List list22;
            KotlinRawPositionContext positionContext;
            PsiElement position;
            Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
            Intrinsics.checkNotNullParameter((Object)diagnosticPsi, (String)"diagnosticPsi");
            PsiElement psiElement2 = position = diagnosticPsi.getContainingFile().findElementAt(UtilsKt.getStartOffset((PsiElement)diagnosticPsi));
            if (psiElement2 != null) {
                PsiElement it = psiElement2;
                boolean list22 = false;
                v1 = KotlinPositionContextDetector.INSTANCE.detect(it);
            } else {
                v1 = positionContext = null;
            }
            if (!(positionContext instanceof KotlinNameReferencePositionContext)) {
                return CollectionsKt.emptyList();
            }
            KtSymbolFromIndexProvider indexProvider = KtSymbolFromIndexProvider.Companion.createForElement(((KotlinNameReferencePositionContext)positionContext).getNameExpression());
            List $this$getFixes_u24lambda_u241 = list22 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Object object = (KotlinNameReferencePositionContext)positionContext;
            if (object instanceof KotlinSuperTypeCallNameReferencePositionContext ? true : object instanceof KotlinTypeNameReferencePositionContext) {
                $this$getFixes_u24lambda_u241.add(new ClassifierImportCandidatesProvider((KotlinNameReferencePositionContext)positionContext, indexProvider));
            } else if (object instanceof KotlinAnnotationTypeNameReferencePositionContext) {
                $this$getFixes_u24lambda_u241.add(new AnnotationImportCandidatesProvider((KotlinAnnotationTypeNameReferencePositionContext)positionContext, indexProvider));
            } else if (object instanceof KotlinWithSubjectEntryPositionContext ? true : object instanceof KotlinExpressionNameReferencePositionContext) {
                $this$getFixes_u24lambda_u241.add(new CallableImportCandidatesProvider((KotlinNameReferencePositionContext)positionContext, indexProvider));
                $this$getFixes_u24lambda_u241.add(new ClassifierImportCandidatesProvider((KotlinNameReferencePositionContext)positionContext, indexProvider));
            } else if (object instanceof KotlinInfixCallPositionContext) {
                $this$getFixes_u24lambda_u241.add(new InfixCallableImportCandidatesProvider((KotlinInfixCallPositionContext)positionContext, indexProvider));
            } else if (object instanceof KDocLinkNamePositionContext || object instanceof KotlinCallableReferencePositionContext || (((object instanceof KotlinImportDirectivePositionContext ? true : object instanceof KotlinPackageDirectivePositionContext) ? true : object instanceof KotlinSuperReceiverNameReferencePositionContext) ? true : object instanceof KDocParameterNamePositionContext)) {
                // empty if block
            }
            List candidateProviders = CollectionsKt.build((List)list22);
            Iterable $this$flatMap$iv = candidateProviders;
            boolean $i$f$flatMap = false;
            object = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ImportCandidatesProvider it = (ImportCandidatesProvider)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.collectCandidates($context_receiver_0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List candidates2 = (List)destination$iv$iv;
            ImportQuickFix quickFix2 = this.createImportFix($context_receiver_0, ((KotlinNameReferencePositionContext)positionContext).getNameExpression(), candidates2);
            return CollectionsKt.listOfNotNull((Object)quickFix2);
        }

        private final String renderSymbol(KtAnalysisSession $context_receiver_0, KtDeclarationSymbol symbol2) {
            PrettyPrinter prettyPrinter;
            block7: {
                PsiFile psiFile2;
                FqName fqName2;
                boolean $i$f$prettyPrint = false;
                PrettyPrinter $this$renderSymbol_u24lambda_u245 = prettyPrinter = new PrettyPrinter(0, 1, null);
                boolean bl = false;
                FqName fqName3 = Companion.getFqName($context_receiver_0, symbol2);
                if (symbol2 instanceof KtNamedClassOrObjectSymbol) {
                    $this$renderSymbol_u24lambda_u245.append("class " + fqName3);
                } else {
                    renderer.renderDeclaration($context_receiver_0, symbol2, $this$renderSymbol_u24lambda_u245);
                }
                KtDeclarationSymbol ktDeclarationSymbol = symbol2;
                if (ktDeclarationSymbol instanceof KtCallableSymbol) {
                    CallableId callableId = ((KtCallableSymbol)symbol2).getCallableIdIfNonLocal();
                    v1 = callableId != null ? callableId.getPackageName() : null;
                } else if (ktDeclarationSymbol instanceof KtClassLikeSymbol) {
                    ClassId classId = ((KtClassLikeSymbol)symbol2).getClassIdIfNonLocal();
                    v1 = classId != null ? classId.getPackageFqName() : null;
                } else {
                    v1 = fqName2 = null;
                }
                if (fqName2 == null) break block7;
                FqName packageName = fqName2;
                boolean bl2 = false;
                $this$renderSymbol_u24lambda_u245.append(" defined in " + packageName.asString());
                PsiElement psiElement2 = symbol2.getPsi();
                if (psiElement2 != null && (psiElement2 = (psiFile2 = psiElement2.getContainingFile())) != null) {
                    Intrinsics.checkNotNull((Object)psiElement2);
                    PsiFile it = psiFile2;
                    boolean bl3 = false;
                    $this$renderSymbol_u24lambda_u245.append(" in file " + it.getName());
                }
            }
            return prettyPrinter.toString();
        }

        /*
         * WARNING - void declaration
         */
        private final ImportQuickFix createImportFix(KtAnalysisSession $context_receiver_0, KtElement position, List<? extends KtDeclarationSymbol> importCandidateSymbols) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection<FqName> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$sortedBy$iv;
            Object object;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3;
            if (importCandidateSymbols.isEmpty()) {
                return null;
            }
            KtFile ktFile = position.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            TargetPlatform targetPlatform = TargetPlatformDetectorUtils.getPlatform((KtElement)ktFile);
            Project project2 = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            PlatformDependentAnalyzerServices analyzerServices = PlatformAnalyzerServicesUtils.findAnalyzerServices(targetPlatform, project2);
            List defaultImports = analyzerServices.getDefaultImports(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)position), true);
            List excludedImports = analyzerServices.getExcludedImports();
            Function1 isImported2 = (Function1)new Function1<FqName, Boolean>((List<ImportPath>)defaultImports, (List<FqName>)excludedImports){
                final /* synthetic */ List<ImportPath> $defaultImports;
                final /* synthetic */ List<FqName> $excludedImports;
                {
                    this.$defaultImports = $defaultImports;
                    this.$excludedImports = $excludedImports;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                    return FqNameUtilKt.isImported(new ImportPath(fqName2, false, null, 4, null), (Iterable<ImportPath>)this.$defaultImports, (Iterable<FqName>)this.$excludedImports);
                }
            };
            KtFile ktFile2 = position.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            ImportPrioritizer importPrioritizer = new ImportPrioritizer(ktFile2, isImported2, false, 4, null);
            ExpressionImportWeigher expressionImportWeigher = ExpressionImportWeigher.Companion.createWeigher($context_receiver_0, (PsiElement)position);
            Iterable iterable = importCandidateSymbols;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv3;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                KtDeclarationSymbol ktDeclarationSymbol = (KtDeclarationSymbol)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(TuplesKt.to((Object)it, (Object)Companion.createPriorityForImportableSymbol($context_receiver_0, importPrioritizer, expressionImportWeigher, (KtDeclarationSymbol)it)));
            }
            $this$map$iv3 = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List sortedImportCandidateSymbolsWithPriorities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    Pair pair = (Pair)a;
                    boolean bl = false;
                    ImportPrioritizer.Priority priority = (ImportPrioritizer.Priority)pair.component2();
                    pair = (Pair)b2;
                    Comparable comparable = priority;
                    bl = false;
                    priority = (ImportPrioritizer.Priority)pair.component2();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)priority);
                }
            });
            Iterable $this$mapNotNull$iv = sortedImportCandidateSymbolsWithPriorities;
            boolean $i$f$mapNotNull22 = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                ImportFixHelper.ImportInfo<Comparable> importInfo;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl3 = false;
                KtDeclarationSymbol candidateSymbol = (KtDeclarationSymbol)pair.component1();
                ImportPrioritizer.Priority priority = (ImportPrioritizer.Priority)pair.component2();
                if (Companion.getImportKind($context_receiver_0, candidateSymbol) == null) {
                    importInfo = null;
                } else {
                    ImportFixHelper.ImportKind kind2;
                    String name2 = Companion.getImportName($context_receiver_0, candidateSymbol);
                    importInfo = new ImportFixHelper.ImportInfo<Comparable>(kind2, name2, priority);
                }
                if (importInfo == null) continue;
                ImportFixHelper.ImportInfo<Comparable> it$iv$iv = importInfo;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List sortedImportInfos2 = (List)destination$iv$iv2;
            Iterable $i$f$mapNotNull22 = sortedImportCandidateSymbolsWithPriorities;
            Iterable iterable2 = sortedImportInfos2;
            object = ImportFixHelper.INSTANCE;
            boolean $i$f$map22 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                element$iv$iv$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                KtDeclarationSymbol symbol2 = (KtDeclarationSymbol)element$iv$iv$iv.component1();
                collection.add(Companion.getFqName($context_receiver_0, symbol2));
            }
            collection = (List)destination$iv$iv3;
            String text2 = ((ImportFixHelper)object).calculateTextForFix(iterable2, CollectionsKt.distinct((Iterable)collection));
            Iterable $i$f$map22 = sortedImportCandidateSymbolsWithPriorities;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl6 = false;
                KtDeclarationSymbol symbol3 = (KtDeclarationSymbol)pair.component1();
                ImportPrioritizer.Priority priority = (ImportPrioritizer.Priority)pair.component2();
                object.add(new SymbolBasedAutoImportVariant(Companion.getFqName($context_receiver_0, symbol3), symbol3.getPsi(), KotlinIconProvider.INSTANCE.getIconFor($context_receiver_0, symbol3), Companion.renderSymbol($context_receiver_0, symbol3), priority.getStatisticsInfo()));
            }
            List sortedImportVariants = (List)destination$iv$iv4;
            return new ImportQuickFix(position, text2, sortedImportVariants);
        }

        private final ImportFixHelper.ImportKind getImportKind(KtAnalysisSession $context_receiver_0, KtDeclarationSymbol $this$getImportKind) {
            return $this$getImportKind instanceof KtPropertySymbol && ((KtPropertySymbol)$this$getImportKind).isExtension() ? ImportFixHelper.ImportKind.EXTENSION_PROPERTY : ($this$getImportKind instanceof KtPropertySymbol ? ImportFixHelper.ImportKind.PROPERTY : ($this$getImportKind instanceof KtJavaFieldSymbol ? ImportFixHelper.ImportKind.PROPERTY : ($this$getImportKind instanceof KtFunctionSymbol && ((KtFunctionSymbol)$this$getImportKind).isOperator() ? ImportFixHelper.ImportKind.OPERATOR : ($this$getImportKind instanceof KtFunctionSymbol && ((KtFunctionSymbol)$this$getImportKind).isExtension() ? ImportFixHelper.ImportKind.EXTENSION_FUNCTION : ($this$getImportKind instanceof KtFunctionSymbol ? ImportFixHelper.ImportKind.FUNCTION : ($this$getImportKind instanceof KtNamedClassOrObjectSymbol && ((KtNamedClassOrObjectSymbol)$this$getImportKind).getClassKind().isObject() ? ImportFixHelper.ImportKind.OBJECT : ($this$getImportKind instanceof KtNamedClassOrObjectSymbol ? ImportFixHelper.ImportKind.CLASS : ($this$getImportKind instanceof KtTypeAliasSymbol ? ImportFixHelper.ImportKind.TYPE_ALIAS : null))))))));
        }

        private final String getImportName(KtAnalysisSession $context_receiver_0, KtDeclarationSymbol $this$getImportName) {
            StringBuilder stringBuilder;
            StringBuilder $this$getImportName_u24lambda_u2412 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (!($this$getImportName instanceof KtNamedSymbol)) {
                throw new IllegalStateException("Unexpected anonymous declaration".toString());
            }
            if ($this$getImportName instanceof KtCallableSymbol) {
                KtClassOrObjectSymbol classSymbol2;
                KtClassOrObjectSymbol ktClassOrObjectSymbol;
                KtClassOrObjectSymbol ktClassOrObjectSymbol2;
                if (KtCallableSymbolKt.getReceiverType((KtCallableSymbol)$this$getImportName) != null) {
                    KtType ktType = KtCallableSymbolKt.getReceiverType((KtCallableSymbol)$this$getImportName);
                    ktClassOrObjectSymbol2 = ktType != null ? $context_receiver_0.getExpandedClassSymbol(ktType) : null;
                } else {
                    ktClassOrObjectSymbol2 = $context_receiver_0.getOriginalContainingClassForOverride((KtCallableSymbol)$this$getImportName);
                }
                if ((ktClassOrObjectSymbol = (classSymbol2 = ktClassOrObjectSymbol2)) != null && (ktClassOrObjectSymbol = ktClassOrObjectSymbol.getName()) != null) {
                    KtClassOrObjectSymbol it = ktClassOrObjectSymbol;
                    boolean bl2 = false;
                    $this$getImportName_u24lambda_u2412.append(it.asString());
                }
            }
            if (((CharSequence)$this$getImportName_u24lambda_u2412).length() > 0) {
                $this$getImportName_u24lambda_u2412.append('.');
            }
            $this$getImportName_u24lambda_u2412.append(((KtNamedSymbol)((Object)$this$getImportName)).getName().asString());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final FqName getFqName(KtAnalysisSession $context_receiver_0, KtDeclarationSymbol $this$getFqName) {
            FqName fqName2 = AnalysisUtilsKt.getFqNameIfPackageOrNonLocal($context_receiver_0, $this$getFqName);
            if (fqName2 == null) {
                throw new IllegalStateException("Unexpected null for fully-qualified name of importable symbol".toString());
            }
            return fqName2;
        }

        private final ImportPrioritizer.Priority createPriorityForImportableSymbol(KtAnalysisSession $context_receiver_0, ImportPrioritizer prioritizer, ExpressionImportWeigher expressionImportWeigher, KtDeclarationSymbol symbol2) {
            return new ImportPrioritizer.Priority(prioritizer, symbol2.getPsi(), K2StatisticsInfoProvider.forDeclarationSymbol$default(K2StatisticsInfoProvider.INSTANCE, $context_receiver_0, symbol2, null, 4, null), $context_receiver_0.getDeprecationStatus(symbol2) != null, this.getFqName($context_receiver_0, symbol2), expressionImportWeigher.weigh($context_receiver_0, symbol2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix$ImportQuestionAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/List;)V", "addImport", "", "importVariant", "execute", "", "kotlin.fir"})
    private static final class ImportQuestionAction
    implements QuestionAction {
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFile file;
        @NotNull
        private final List<AutoImportVariant> importVariants;

        public ImportQuestionAction(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtFile file2, @NotNull List<? extends AutoImportVariant> importVariants) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
            this.project = project2;
            this.editor = editor2;
            this.file = file2;
            this.importVariants = importVariants;
            if (!(!((Collection)this.importVariants).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public boolean execute() {
            KotlinAddImportActionInfo.ExecuteListener executeListener = KotlinAddImportActionInfo.INSTANCE.getExecuteListener((PsiFile)this.file);
            if (executeListener != null) {
                executeListener.onExecute(this.importVariants);
            }
            switch (this.importVariants.size()) {
                case 1: {
                    this.addImport((AutoImportVariant)CollectionsKt.single(this.importVariants));
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.addImport((AutoImportVariant)CollectionsKt.first(this.importVariants));
                return true;
            }
            ImportFixHelper.INSTANCE.createListPopupWithImportVariants(this.project, this.importVariants, (Function1<? super AutoImportVariant, Unit>)((Function1)new Function1<AutoImportVariant, Unit>((Object)this){

                public final void invoke(@NotNull AutoImportVariant p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ImportQuestionAction.access$addImport((ImportQuestionAction)this.receiver, p0);
                }
            })).showInBestPositionFor(this.editor);
            return true;
        }

        private final void addImport(AutoImportVariant importVariant) {
            if (!(importVariant instanceof SymbolBasedAutoImportVariant)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            StatisticsManager.getInstance().incUseCount(((SymbolBasedAutoImportVariant)importVariant).getStatisticsInfo());
            String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ApplicationUtilsKt.executeWriteCommand(this.project, string, (Function0<Unit>)((Function0)new Function0<Unit>(this, importVariant){
                final /* synthetic */ ImportQuestionAction this$0;
                final /* synthetic */ AutoImportVariant $importVariant;
                {
                    this.this$0 = $receiver;
                    this.$importVariant = $importVariant;
                    super(0);
                }

                public final void invoke() {
                    ImportInsertionKt.addImport$default(ImportQuestionAction.access$getFile$p(this.this$0), this.$importVariant.getFqName(), false, null, null, 14, null);
                }
            }));
        }

        public static final /* synthetic */ void access$addImport(ImportQuestionAction $this, AutoImportVariant importVariant) {
            $this.addImport(importVariant);
        }

        public static final /* synthetic */ KtFile access$getFile$p(ImportQuestionAction $this) {
            return $this.file;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J?\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/importFix/ImportQuickFix$SymbolBasedAutoImportVariant;", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "declarationToImport", "Lcom/intellij/psi/PsiElement;", "icon", "Ljavax/swing/Icon;", "debugRepresentation", "", "statisticsInfo", "Lcom/intellij/psi/statistics/StatisticsInfo;", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiElement;Ljavax/swing/Icon;Ljava/lang/String;Lcom/intellij/psi/statistics/StatisticsInfo;)V", "getDebugRepresentation", "()Ljava/lang/String;", "getDeclarationToImport", "()Lcom/intellij/psi/PsiElement;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "hint", "getHint", "getIcon", "()Ljavax/swing/Icon;", "getStatisticsInfo", "()Lcom/intellij/psi/statistics/StatisticsInfo;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.fir"})
    private static final class SymbolBasedAutoImportVariant
    implements AutoImportVariant {
        @NotNull
        private final FqName fqName;
        @Nullable
        private final PsiElement declarationToImport;
        @Nullable
        private final Icon icon;
        @NotNull
        private final String debugRepresentation;
        @NotNull
        private final StatisticsInfo statisticsInfo;
        @NotNull
        private final String hint;

        public SymbolBasedAutoImportVariant(@NotNull FqName fqName2, @Nullable PsiElement declarationToImport, @Nullable Icon icon, @NotNull String debugRepresentation, @NotNull StatisticsInfo statisticsInfo) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)debugRepresentation, (String)"debugRepresentation");
            Intrinsics.checkNotNullParameter((Object)statisticsInfo, (String)"statisticsInfo");
            this.fqName = fqName2;
            this.declarationToImport = declarationToImport;
            this.icon = icon;
            this.debugRepresentation = debugRepresentation;
            this.statisticsInfo = statisticsInfo;
            String string = this.getFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            this.hint = string;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @Override
        @Nullable
        public PsiElement getDeclarationToImport() {
            return this.declarationToImport;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        @NotNull
        public String getDebugRepresentation() {
            return this.debugRepresentation;
        }

        @NotNull
        public final StatisticsInfo getStatisticsInfo() {
            return this.statisticsInfo;
        }

        @Override
        @NotNull
        public String getHint() {
            return this.hint;
        }

        @NotNull
        public final FqName component1() {
            return this.fqName;
        }

        @Nullable
        public final PsiElement component2() {
            return this.declarationToImport;
        }

        @Nullable
        public final Icon component3() {
            return this.icon;
        }

        @NotNull
        public final String component4() {
            return this.debugRepresentation;
        }

        @NotNull
        public final StatisticsInfo component5() {
            return this.statisticsInfo;
        }

        @NotNull
        public final SymbolBasedAutoImportVariant copy(@NotNull FqName fqName2, @Nullable PsiElement declarationToImport, @Nullable Icon icon, @NotNull String debugRepresentation, @NotNull StatisticsInfo statisticsInfo) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)debugRepresentation, (String)"debugRepresentation");
            Intrinsics.checkNotNullParameter((Object)statisticsInfo, (String)"statisticsInfo");
            return new SymbolBasedAutoImportVariant(fqName2, declarationToImport, icon, debugRepresentation, statisticsInfo);
        }

        public static /* synthetic */ SymbolBasedAutoImportVariant copy$default(SymbolBasedAutoImportVariant symbolBasedAutoImportVariant, FqName fqName2, PsiElement psiElement2, Icon icon, String string, StatisticsInfo statisticsInfo, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = symbolBasedAutoImportVariant.fqName;
            }
            if ((n & 2) != 0) {
                psiElement2 = symbolBasedAutoImportVariant.declarationToImport;
            }
            if ((n & 4) != 0) {
                icon = symbolBasedAutoImportVariant.icon;
            }
            if ((n & 8) != 0) {
                string = symbolBasedAutoImportVariant.debugRepresentation;
            }
            if ((n & 0x10) != 0) {
                statisticsInfo = symbolBasedAutoImportVariant.statisticsInfo;
            }
            return symbolBasedAutoImportVariant.copy(fqName2, psiElement2, icon, string, statisticsInfo);
        }

        @NotNull
        public String toString() {
            return "SymbolBasedAutoImportVariant(fqName=" + this.fqName + ", declarationToImport=" + this.declarationToImport + ", icon=" + this.icon + ", debugRepresentation=" + this.debugRepresentation + ", statisticsInfo=" + this.statisticsInfo + ")";
        }

        public int hashCode() {
            int result2 = this.fqName.hashCode();
            result2 = result2 * 31 + (this.declarationToImport == null ? 0 : this.declarationToImport.hashCode());
            result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
            result2 = result2 * 31 + this.debugRepresentation.hashCode();
            result2 = result2 * 31 + this.statisticsInfo.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof SymbolBasedAutoImportVariant)) {
                return false;
            }
            SymbolBasedAutoImportVariant symbolBasedAutoImportVariant = (SymbolBasedAutoImportVariant)other2;
            if (!Intrinsics.areEqual((Object)this.fqName, (Object)symbolBasedAutoImportVariant.fqName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.declarationToImport, (Object)symbolBasedAutoImportVariant.declarationToImport)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)symbolBasedAutoImportVariant.icon)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.debugRepresentation, (Object)symbolBasedAutoImportVariant.debugRepresentation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.statisticsInfo, (Object)symbolBasedAutoImportVariant.statisticsInfo);
        }
    }
}

