/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.helper;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinOptimizeImportsFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper;", "Lcom/intellij/refactoring/RefactoringHelper;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "()V", "performOperation", "", "project", "Lcom/intellij/openapi/project/Project;", "operationData", "prepareOperation", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Ljava/util/Set;", "primaryElement", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/usageView/UsageInfo;Lcom/intellij/psi/PsiElement;)Ljava/util/Set;", "CollectUnusedImportsTask", "OptimizeImportsTask", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinOptimizeImportsRefactoringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n11391#2:125\n13309#2:126\n13310#2:128\n11392#2:129\n1#3:127\n*S KotlinDebug\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper\n*L\n91#1:125\n91#1:126\n91#1:128\n91#1:129\n91#1:127\n*E\n"})
public final class KotlinOptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<? extends KtFile>> {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<KtFile> prepareOperation(@NotNull UsageInfo[] usages2) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        UsageInfo[] usageInfoArray = usages2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            KtFile it$iv;
            PsiFile psiFile2;
            void element$iv$iv;
            void element$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            void it = element$iv;
            boolean bl2 = false;
            if ((!it.isNonCodeUsage ? ((psiFile2 = it.getFile()) instanceof KtFile ? (KtFile)psiFile2 : null) : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    @NotNull
    public Set<KtFile> prepareOperation(@NotNull UsageInfo[] usages2, @NotNull PsiElement primaryElement) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        Intrinsics.checkNotNullParameter((Object)primaryElement, (String)"primaryElement");
        Set files2 = (Set)super.prepareOperation(usages2, primaryElement);
        PsiFile file2 = primaryElement.getContainingFile();
        if (file2 instanceof KtFile) {
            Intrinsics.checkNotNull((Object)files2, (String)"null cannot be cast to non-null type java.util.LinkedHashSet<org.jetbrains.kotlin.psi.KtFile>{ kotlin.collections.TypeAliasesKt.LinkedHashSet<org.jetbrains.kotlin.psi.KtFile> }");
            ((LinkedHashSet)files2).add(file2);
        }
        Intrinsics.checkNotNull((Object)files2);
        return files2;
    }

    public void performOperation(@NotNull Project project2, @NotNull Set<? extends KtFile> operationData) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(operationData, (String)"operationData");
        if (operationData.isEmpty()) {
            return;
        }
        CodeStyleManager.getInstance((Project)project2).performActionWithFormatterDisabled(() -> KotlinOptimizeImportsRefactoringHelper.performOperation$lambda$1(project2));
        Set unusedImports = new LinkedHashSet();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        CollectUnusedImportsTask collectTask2 = new CollectUnusedImportsTask(project2, unusedImports, operationData, progressManager2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<SmartPsiElementPointer<KtImportDirective>> $unusedImports;
            final /* synthetic */ ProgressManager $progressManager;
            {
                this.$project = $project;
                this.$unusedImports = $unusedImports;
                this.$progressManager = $progressManager;
                super($project, $unusedImports, $operationData);
            }

            public void onSuccess() {
                OptimizeImportsTask progressTask = new OptimizeImportsTask(this.$project, this.$unusedImports);
                this.$progressManager.run((Task)progressTask);
            }
        };
        progressManager2.run((Task)collectTask2);
    }

    private static final void performOperation$lambda$1(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$CollectUnusedImportsTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "unusedImports", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "operationData", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "kotlin.refactorings.common"})
    @SourceDebugExtension(value={"SMAP\nKotlinOptimizeImportsRefactoringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$CollectUnusedImportsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$CollectUnusedImportsTask\n*L\n48#1:125,3\n*E\n"})
    public static class CollectUnusedImportsTask
    extends Task.Modal {
        @NotNull
        private final Set<SmartPsiElementPointer<KtImportDirective>> unusedImports;
        @NotNull
        private final Set<KtFile> operationData;

        public CollectUnusedImportsTask(@NotNull Project project2, @NotNull Set<SmartPsiElementPointer<KtImportDirective>> unusedImports, @NotNull Set<? extends KtFile> operationData) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(unusedImports, (String)"unusedImports");
            Intrinsics.checkNotNullParameter(operationData, (String)"operationData");
            super(project2, KotlinBundle.message("optimize.imports.collect.unused.imports", new Object[0]), true);
            this.unusedImports = unusedImports;
            this.operationData = operationData;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            CollectUnusedImportsTask $this$run_u24lambda_u243 = this;
            boolean bl = false;
            indicator.setIndeterminate(false);
            int myTotalCount = $this$run_u24lambda_u243.operationData.size();
            Iterator<KtFile> iterator2 = $this$run_u24lambda_u243.operationData.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int counter = n++;
                KtFile file2 = iterator2.next();
                ReadAction.nonBlocking(() -> CollectUnusedImportsTask.run$lambda$3$lambda$1(file2, indicator, counter, myTotalCount, $this$run_u24lambda_u243)).inSmartMode($this$run_u24lambda_u243.getProject()).wrapProgress(indicator).expireWhen(() -> CollectUnusedImportsTask.run$lambda$3$lambda$2(file2, $this$run_u24lambda_u243)).executeSynchronously();
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit run$lambda$3$lambda$1(KtFile $file, ProgressIndicator $indicator, int $counter, int $myTotalCount, CollectUnusedImportsTask $this_run) {
            block2: {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
                Intrinsics.checkNotNullParameter((Object)((Object)$this_run), (String)"$this_run");
                VirtualFile virtualFile2 = $file.getVirtualFile();
                if (virtualFile2 == null) {
                    return Unit.INSTANCE;
                }
                VirtualFile virtualFile3 = virtualFile2;
                $indicator.setFraction((double)$counter / (double)$myTotalCount);
                $indicator.setText2(virtualFile3.getPresentableUrl());
                KotlinOptimizeImportsFacility.ImportData importData = KotlinOptimizeImportsFacility.Companion.getInstance().analyzeImports($file);
                Object object = importData;
                if (object == null || (object = object.getUnusedImports()) == null) break block2;
                Iterable iterable = (Iterable)object;
                Collection destination$iv = $this_run.unusedImports;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    KtImportDirective ktImportDirective = (KtImportDirective)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)it)));
                }
                Set cfr_ignored_0 = (Set)destination$iv;
            }
            return Unit.INSTANCE;
        }

        private static final boolean run$lambda$3$lambda$2(KtFile $file, CollectUnusedImportsTask $this_run) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)((Object)$this_run), (String)"$this_run");
            return !$file.isValid() || $this_run.getProject().isDisposed();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$OptimizeImportsTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "pointers", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "kotlin.refactorings.common"})
    public static final class OptimizeImportsTask
    extends Task.Modal {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<SmartPsiElementPointer<KtImportDirective>> pointers;
        @NotNull
        private static final Logger LOG;

        public OptimizeImportsTask(@NotNull Project project2, @NotNull Set<? extends SmartPsiElementPointer<KtImportDirective>> pointers2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(pointers2, (String)"pointers");
            super(project2, KotlinBundle.message("optimize.imports.task.removing.redundant.imports", new Object[0]), false);
            this.pointers = pointers2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(false);
            int myTotal = this.pointers.size();
            Iterator<SmartPsiElementPointer<KtImportDirective>> iterator2 = this.pointers.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String presentableUrl;
                VirtualFile virtualFile2;
                int counter = n++;
                SmartPsiElementPointer<KtImportDirective> pointer = iterator2.next();
                indicator.setFraction((double)counter / (double)myTotal);
                if ((VirtualFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>(pointer){
                    final /* synthetic */ SmartPsiElementPointer<KtImportDirective> $pointer;
                    {
                        this.$pointer = $pointer;
                        super(0);
                    }

                    @Nullable
                    public final VirtualFile invoke() {
                        return PsiUtilCore.getVirtualFile((PsiElement)this.$pointer.getElement());
                    }
                })) == null) continue;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2.getPresentableUrl(), (String)"getPresentableUrl(...)");
                indicator.setText2(presentableUrl);
                ApplicationManager.getApplication().invokeAndWait(() -> OptimizeImportsTask.run$lambda$1$lambda$0(this, presentableUrl, pointer));
            }
        }

        private static final void run$lambda$1$lambda$0(OptimizeImportsTask this$0, String $presentableUrl, SmartPsiElementPointer $pointer) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$presentableUrl, (String)"$presentableUrl");
            Intrinsics.checkNotNullParameter((Object)$pointer, (String)"$pointer");
            Project project2 = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Object[] objectArray = new Object[]{$presentableUrl};
            ApplicationUtilsKt.executeWriteCommand(project2, KotlinBundle.message("delete.0", objectArray), (Function0<Unit>)((Function0)new Function0<Unit>((SmartPsiElementPointer<KtImportDirective>)$pointer){
                final /* synthetic */ SmartPsiElementPointer<KtImportDirective> $pointer;
                {
                    this.$pointer = $pointer;
                    super(0);
                }

                public final void invoke() {
                    try {
                        KtImportDirective ktImportDirective = (KtImportDirective)this.$pointer.getElement();
                        if (ktImportDirective != null) {
                            ktImportDirective.delete();
                        }
                    }
                    catch (IncorrectOperationException e) {
                        OptimizeImportsTask.access$getLOG$cp().error((Throwable)e);
                    }
                }
            }));
        }

        public static final /* synthetic */ Logger access$getLOG$cp() {
            return LOG;
        }

        static {
            Logger logger = Logger.getInstance((String)("#" + OptimizeImportsTask.class.getName()));
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$OptimizeImportsTask$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.refactorings.common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

