/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0010H\u0014R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinDeclarationInlineProcessor;", "TElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "declaration", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "kind", "", "getKind", "()Ljava/lang/String;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "getCommandName", "kotlin.idea"})
public abstract class AbstractKotlinDeclarationInlineProcessor<TElement extends KtDeclaration>
extends BaseRefactoringProcessor {
    @NotNull
    private final TElement declaration;
    @Nullable
    private final Editor editor;
    @NotNull
    private final String kind;

    public AbstractKotlinDeclarationInlineProcessor(@NotNull TElement declaration2, @Nullable Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, SearchUtilKt.codeUsageScopeRestrictedToProject((PsiElement)declaration2), null);
        this.declaration = declaration2;
        this.editor = editor2;
        TElement TElement = this.declaration;
        this.kind = TElement instanceof KtNamedFunction ? (((KtNamedFunction)this.declaration).getName() != null ? KotlinBundle.message("text.function", new Object[0]) : KotlinBundle.message("text.anonymous.function", new Object[0])) : (TElement instanceof KtProperty ? (((KtProperty)this.declaration).isLocal() ? KotlinBundle.message("text.local.variable", new Object[0]) : KotlinBundle.message("text.local.property", new Object[0])) : (TElement instanceof KtTypeAlias ? KotlinBundle.message("text.type.alias", new Object[0]) : KotlinBundle.message("text.declaration", new Object[0])));
    }

    @NotNull
    protected final TElement getDeclaration() {
        return this.declaration;
    }

    @Nullable
    protected final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    protected final String getKind() {
        return this.kind;
    }

    @NotNull
    protected String getCommandName() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.kind;
        Intrinsics.checkNotNullExpressionValue((Object)DescriptiveNameUtil.getDescriptiveName((PsiElement)((PsiElement)this.declaration)), (String)"getDescriptiveName(...)");
        return KotlinBundle.message("text.inlining.0.1", objectArray);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        return new UsageViewDescriptor(this){
            final /* synthetic */ AbstractKotlinDeclarationInlineProcessor<TElement> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getCommentReferencesText(int usagesCount, int filesCount) {
                Object[] objectArray = new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)};
                String string = RefactoringBundle.message((String)"comments.elements.header", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                Object[] objectArray = new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)};
                String string = JavaRefactoringBundle.message((String)"invocations.to.be.inlined", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @NotNull
            public KtDeclaration[] getElements() {
                KtDeclaration[] ktDeclarationArray = new KtDeclaration[]{this.this$0.getDeclaration()};
                return ktDeclarationArray;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.this$0.getKind())};
                return KotlinBundle.message("text.0.to.inline", objectArray);
            }
        };
    }
}

