/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfoKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacadeKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0006H\u0002R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/ExtractableSubstringInfo;", "", "startEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "endEntry", "prefix", "", "suffix", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;)V", "content", "getContent", "()Ljava/lang/String;", "contentRange", "Lcom/intellij/openapi/util/TextRange;", "getContentRange", "()Lcom/intellij/openapi/util/TextRange;", "getEndEntry", "()Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "entries", "Lkotlin/sequences/Sequence;", "getEntries", "()Lkotlin/sequences/Sequence;", "getPrefix", "relativeContentRange", "getRelativeContentRange", "getStartEntry", "getSuffix", "template", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getTemplate", "()Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "copy", "newTemplate", "createExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "guessLiteralType", "literal", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nExtractableSubstringInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractableSubstringInfo.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/ExtractableSubstringInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class ExtractableSubstringInfo {
    @NotNull
    private final KtStringTemplateEntry startEntry;
    @NotNull
    private final KtStringTemplateEntry endEntry;
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;
    @NotNull
    private final KtStringTemplateExpression template;
    @NotNull
    private final String content;
    @NotNull
    private final KotlinType type;

    /*
     * WARNING - void declaration
     */
    public ExtractableSubstringInfo(@NotNull KtStringTemplateEntry startEntry, @NotNull KtStringTemplateEntry endEntry, @NotNull String prefix2, @NotNull String suffix2, @Nullable KotlinType type2) {
        void $this$content_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)startEntry, (String)"startEntry");
        Intrinsics.checkNotNullParameter((Object)endEntry, (String)"endEntry");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix2, (String)"suffix");
        this.startEntry = startEntry;
        this.endEntry = endEntry;
        this.prefix = prefix2;
        this.suffix = suffix2;
        PsiElement psiElement2 = this.startEntry.getParent();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        this.template = (KtStringTemplateExpression)psiElement2;
        String string = SequencesKt.joinToString$default((Sequence)SequencesKt.map(this.getEntries(), (Function1)content.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        ExtractableSubstringInfo extractableSubstringInfo = this;
        boolean bl = false;
        String string2 = $this$content_u24lambda_u240.substring(this.prefix.length(), $this$content_u24lambda_u240.length() - this.suffix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        extractableSubstringInfo.content = string2;
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            kotlinType = this.guessLiteralType(this.content);
        }
        this.type = kotlinType;
    }

    public /* synthetic */ ExtractableSubstringInfo(KtStringTemplateEntry ktStringTemplateEntry, KtStringTemplateEntry ktStringTemplateEntry2, String string, String string2, KotlinType kotlinType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            kotlinType = null;
        }
        this(ktStringTemplateEntry, ktStringTemplateEntry2, string, string2, kotlinType);
    }

    @NotNull
    public final KtStringTemplateEntry getStartEntry() {
        return this.startEntry;
    }

    @NotNull
    public final KtStringTemplateEntry getEndEntry() {
        return this.endEntry;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    private final KotlinType guessLiteralType(String literal) {
        ResolutionFacade facade = ResolutionUtils.getResolutionFacade((KtElement)this.template);
        ModuleDescriptor module2 = facade.getModuleDescriptor();
        SimpleType simpleType = module2.getBuiltIns().getStringType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getStringType(...)");
        SimpleType stringType = simpleType;
        if (!Intrinsics.areEqual((Object)this.startEntry, (Object)this.endEntry) || !(this.startEntry instanceof KtLiteralStringTemplateEntry)) {
            return (KotlinType)stringType;
        }
        KtExpression ktExpression = new KtPsiFactory(facade.getProject(), false, 2, null).createExpressionIfPossible(literal);
        if (ktExpression == null) {
            return (KotlinType)stringType;
        }
        KtExpression expr = ktExpression;
        BindingContext context2 = facade.analyze((KtElement)this.template, BodyResolveMode.PARTIAL);
        LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)this.template, context2, facade);
        BindingContext tempContext = ExtendedResolutionApiKt.analyzeInContext$default(expr, scope2, (KtExpression)this.template, null, null, null, false, null, null, 252, null);
        DelegatingBindingTrace trace = new DelegatingBindingTrace(tempContext, "Evaluate '" + literal + "'", false, null, false, null, 60, null);
        LanguageVersionSettings languageVersionSettings2 = ResolutionFacadeKt.getLanguageVersionSettings(facade);
        CompileTimeConstant value2 = ConstantExpressionEvaluator.evaluateExpression$default((ConstantExpressionEvaluator)new ConstantExpressionEvaluator(module2, languageVersionSettings2, facade.getProject(), null, 8, null), (KtExpression)expr, (BindingTrace)((BindingTrace)trace), null, (int)4, null);
        if (value2 == null || value2.isError()) {
            return (KotlinType)stringType;
        }
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
        return value2.toConstantValue((KotlinType)simpleType2).getType(module2);
    }

    @NotNull
    public final KtStringTemplateExpression getTemplate() {
        return this.template;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final TextRange getContentRange() {
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)this.startEntry)) + this.prefix.length(), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)this.endEntry)) - this.suffix.length());
    }

    @NotNull
    public final TextRange getRelativeContentRange() {
        TextRange textRange = this.getContentRange().shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)this.template)));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        return textRange;
    }

    @NotNull
    public final Sequence<KtStringTemplateEntry> getEntries() {
        return SequencesKt.generateSequence((Object)this.startEntry, (Function1)((Function1)new Function1<KtStringTemplateEntry, KtStringTemplateEntry>(this){
            final /* synthetic */ ExtractableSubstringInfo this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final KtStringTemplateEntry invoke(@NotNull KtStringTemplateEntry it) {
                KtStringTemplateEntry ktStringTemplateEntry;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)it, (Object)this.this$0.getEndEntry())) {
                    PsiElement $this$nextSiblingOfSameType$iv = (PsiElement)it;
                    boolean $i$f$nextSiblingOfSameType = false;
                    ktStringTemplateEntry = (KtStringTemplateEntry)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSiblingOfSameType$iv, KtStringTemplateEntry.class);
                } else {
                    ktStringTemplateEntry = null;
                }
                return ktStringTemplateEntry;
            }
        }));
    }

    @NotNull
    public final KtExpression createExpression() {
        KtExpression ktExpression;
        String quote = this.template.getFirstChild().getText();
        String literalValue = KotlinBuiltIns.isString((KotlinType)this.type) ? quote + this.content + quote : this.content;
        Project project2 = this.template.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtExpression $this$createExpression_u24lambda_u241 = ktExpression = new KtPsiFactory(project2, false, 2, null).createExpression(literalValue);
        boolean bl = false;
        ExtractableSubstringInfoKt.setExtractableSubstringInfo($this$createExpression_u24lambda_u241, this);
        return ktExpression;
    }

    @NotNull
    public final ExtractableSubstringInfo copy(@NotNull KtStringTemplateExpression newTemplate) {
        Intrinsics.checkNotNullParameter((Object)newTemplate, (String)"newTemplate");
        Object[] oldEntries = this.template.getEntries();
        KtStringTemplateEntry[] newEntries = newTemplate.getEntries();
        Intrinsics.checkNotNull((Object)oldEntries);
        int startIndex = ArraysKt.indexOf((Object[])oldEntries, (Object)this.startEntry);
        int endIndex = ArraysKt.indexOf((Object[])oldEntries, (Object)this.endEntry);
        if (startIndex < 0 || startIndex >= newEntries.length || endIndex < 0 || endIndex >= newEntries.length) {
            throw new KotlinExceptionWithAttachments("Old template(" + startIndex + ".." + endIndex + "): " + this.template + ", new template: " + newTemplate).withPsiAttachment("template", (PsiElement)this.template).withPsiAttachment("newTemplate", (PsiElement)newTemplate);
        }
        KtStringTemplateEntry ktStringTemplateEntry = newEntries[startIndex];
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntry, (String)"get(...)");
        KtStringTemplateEntry ktStringTemplateEntry2 = newEntries[endIndex];
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntry2, (String)"get(...)");
        return new ExtractableSubstringInfo(ktStringTemplateEntry, ktStringTemplateEntry2, this.prefix, this.suffix, this.type);
    }
}

