/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.reporter;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginReleaseDateProvider;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginKindProviderKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.reporter.ITNReporterCompat;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002JI\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J?\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter;", "Lorg/jetbrains/kotlin/idea/reporter/ITNReporterCompat;", "()V", "markEventForK2", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "event", "showDialog", "", "parent", "Ljava/awt/Component;", "message", "", "title", "options", "", "defaultOptionIndex", "icon", "Ljavax/swing/Icon;", "(Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ILjavax/swing/Icon;)I", "showErrorInRelease", "", "submitCompat", "events", "additionalInfo", "parentComponent", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "([Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/util/Consumer;)Z", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinReportSubmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,250:1\n85#2:251\n77#2:252\n163#3:253\n*S KotlinDebug\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter\n*L\n166#1:251\n171#1:252\n209#1:253\n*E\n"})
public final class KotlinReportSubmitter
extends ITNReporterCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY = "kotlin.fatal.error.notification";
    @NotNull
    private static final String IDEA_FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    @NotNull
    private static final String DISABLED_VALUE = "disabled";
    @NotNull
    private static final String ENABLED_VALUE = "enabled";
    @NotNull
    private static final String KOTLIN_PLUGIN_RELEASE_DATE = "kotlin.plugin.releaseDate";
    @NotNull
    private static final String KOTLIN_K2_MESSAGE = "This report is from the K2 Kotlin plugin.";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static volatile ThreeState isFatalErrorReportingDisabledInRelease;
    @NotNull
    private static final Lazy<Boolean> isIdeaAndKotlinRelease$delegate;
    private static final int NUMBER_OF_REPORTING_DAYS_FROM_RELEASE = 7;
    @NotNull
    private static final Lazy<DateTimeFormatter> RELEASE_DATE_FORMATTER$delegate;

    public boolean showErrorInRelease(@NotNull IdeaLoggingEvent event) {
        boolean kotlinNotificationEnabled;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal()) {
            return true;
        }
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean bl = kotlinNotificationEnabled = !Intrinsics.areEqual((Object)DISABLED_VALUE, (Object)System.getProperty(KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE));
        if (!kotlinNotificationEnabled) {
            return false;
        }
        if (!KotlinReportSubmitter.Companion.isIdeaAndKotlinRelease()) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[isFatalErrorReportingDisabledInRelease.ordinal()]) {
            case 1 -> false;
            case 2 -> {
                if (!KotlinReportSubmitter.Companion.isFatalErrorReportingDisabledWithUpdate()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (!KotlinReportSubmitter.Companion.isFatalErrorReportingDisabledWithUpdate()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean submitCompat(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @Nullable Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> consumer) {
        IdeaLoggingEvent[] ideaLoggingEventArray;
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (KotlinPluginKindProviderKt.isK2Plugin()) {
            IdeaLoggingEvent[] $this$map2Array$iv = events;
            boolean $i$f$map2Array = false;
            int n = 0;
            int n2 = $this$map2Array$iv.length;
            IdeaLoggingEvent[] ideaLoggingEventArray2 = new IdeaLoggingEvent[n2];
            while (n < n2) {
                void p0;
                IdeaLoggingEvent ideaLoggingEvent;
                int n3 = n++;
                IdeaLoggingEvent ideaLoggingEvent2 = $this$map2Array$iv[n3];
                int n4 = n3;
                IdeaLoggingEvent[] ideaLoggingEventArray3 = ideaLoggingEventArray2;
                boolean bl = false;
                ideaLoggingEventArray3[n4] = ideaLoggingEvent = this.markEventForK2((IdeaLoggingEvent)p0);
            }
            ideaLoggingEventArray = ideaLoggingEventArray2;
        } else {
            ideaLoggingEventArray = events;
        }
        IdeaLoggingEvent[] effectiveEvents = ideaLoggingEventArray;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        if (KotlinIdePlugin.INSTANCE.getHasPatchedVersion()) {
            ReportMessages.GROUP.createNotification(KotlinBundle.message("reporter.text.can.t.report.exception.from.patched.plugin", new Object[0]), NotificationType.INFORMATION).setImportant(false).notify(project2);
            return true;
        }
        return super.submitCompat(effectiveEvents, additionalInfo, parentComponent, consumer);
    }

    private final IdeaLoggingEvent markEventForK2(IdeaLoggingEvent event) {
        if (event instanceof IdeaReportingEvent) {
            AbstractMessage abstractMessage = ((IdeaReportingEvent)event).getData();
            String string = ((IdeaReportingEvent)event).getMessage();
            if (string == null) {
                string = "";
            }
            return (IdeaLoggingEvent)new IdeaReportingEvent(abstractMessage, KotlinReportSubmitter.markEventForK2$patchMessage(string), ((IdeaReportingEvent)event).getThrowableText(), ((IdeaReportingEvent)event).getPlugin());
        }
        if (Intrinsics.areEqual(event.getClass(), IdeaLoggingEvent.class)) {
            String string = event.getMessage();
            if (string == null) {
                string = "";
            }
            return new IdeaLoggingEvent(KotlinReportSubmitter.markEventForK2$patchMessage(string), event.getThrowable(), event.getData());
        }
        return event;
    }

    public final int showDialog(@Nullable Component parent2, @Nls @NotNull String message2, @Nls @NotNull String title, @NotNull String[] options2, int defaultOptionIndex, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return parent2 != null ? Messages.showDialog((Component)parent2, (String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon) : Messages.showDialog((String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon);
    }

    private static final String markEventForK2$patchMessage(String message2) {
        return StringsKt.isBlank((CharSequence)message2) ? KOTLIN_K2_MESSAGE : message2 + "\nThis report is from the K2 Kotlin plugin.";
    }

    static {
        Logger logger = Logger.getInstance(KotlinReportSubmitter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        isFatalErrorReportingDisabledInRelease = ThreeState.UNSURE;
        isIdeaAndKotlinRelease$delegate = LazyKt.lazy((Function0)Companion.isIdeaAndKotlinRelease.2.INSTANCE);
        RELEASE_DATE_FORMATTER$delegate = LazyKt.lazy((Function0)Companion.RELEASE_DATE_FORMATTER.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0012\u0010\u001f\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u001dH\u0002J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion;", "", "()V", "DISABLED_VALUE", "", "ENABLED_VALUE", "IDEA_FATAL_ERROR_NOTIFICATION_PROPERTY", "KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY", "KOTLIN_K2_MESSAGE", "KOTLIN_PLUGIN_RELEASE_DATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NUMBER_OF_REPORTING_DAYS_FROM_RELEASE", "", "RELEASE_DATE_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getRELEASE_DATE_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "RELEASE_DATE_FORMATTER$delegate", "Lkotlin/Lazy;", "isFatalErrorReportingDisabledInRelease", "Lcom/intellij/util/ThreeState;", "isIdeaAndKotlinRelease", "", "()Z", "isIdeaAndKotlinRelease$delegate", "isFatalErrorReportingDisabled", "releaseDate", "Ljava/time/LocalDate;", "isFatalErrorReportingDisabledWithUpdate", "isFatalErrorReportingWithDefault", "readStoredPluginReleaseDate", "setupReportingFromRelease", "", "writePluginReleaseValue", "date", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinReportSubmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,250:1\n77#2:251\n*S KotlinDebug\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion\n*L\n64#1:251\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isIdeaAndKotlinRelease() {
            Lazy lazy = isIdeaAndKotlinRelease$delegate;
            return (Boolean)lazy.getValue();
        }

        public final void setupReportingFromRelease() {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (!this.isIdeaAndKotlinRelease()) {
                return;
            }
            LocalDate currentPluginReleaseDate = this.readStoredPluginReleaseDate();
            if (currentPluginReleaseDate != null) {
                isFatalErrorReportingDisabledInRelease = this.isFatalErrorReportingDisabled(currentPluginReleaseDate) ? ThreeState.YES : ThreeState.NO;
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(Companion::setupReportingFromRelease$lambda$0);
        }

        private final ThreeState isFatalErrorReportingWithDefault(LocalDate releaseDate) {
            return releaseDate != null ? (this.isFatalErrorReportingDisabled(releaseDate) ? ThreeState.YES : ThreeState.NO) : ThreeState.YES;
        }

        private final boolean isFatalErrorReportingDisabledWithUpdate() {
            LocalDate currentPluginReleaseDate = this.readStoredPluginReleaseDate();
            isFatalErrorReportingDisabledInRelease = this.isFatalErrorReportingWithDefault(currentPluginReleaseDate);
            return isFatalErrorReportingDisabledInRelease == ThreeState.YES;
        }

        private final boolean isFatalErrorReportingDisabled(LocalDate releaseDate) {
            return ChronoUnit.DAYS.between(releaseDate, LocalDate.now()) > 7L;
        }

        private final DateTimeFormatter getRELEASE_DATE_FORMATTER() {
            Lazy lazy = RELEASE_DATE_FORMATTER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (DateTimeFormatter)object;
        }

        private final LocalDate readStoredPluginReleaseDate() {
            LocalDate localDate;
            String string = PropertiesComponent.getInstance().getValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE);
            if (string == null) {
                return null;
            }
            String pluginVersionToReleaseDate = string;
            String[] stringArray = new String[]{":"};
            List parts2 = StringsKt.split$default((CharSequence)pluginVersionToReleaseDate, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts2.size() != 2) {
                localDate = null;
            } else {
                String pluginVersion = (String)parts2.get(0);
                if (!Intrinsics.areEqual((Object)pluginVersion, (Object)KotlinIdePlugin.INSTANCE.getVersion())) {
                    localDate = null;
                } else {
                    LocalDate localDate2;
                    try {
                        String dateString = (String)parts2.get(1);
                        localDate2 = LocalDate.parse(dateString, Companion.getRELEASE_DATE_FORMATTER());
                    }
                    catch (DateTimeParseException e) {
                        localDate2 = null;
                    }
                    localDate = localDate2;
                }
            }
            LocalDate parsedDate = localDate;
            if (parsedDate == null) {
                PropertiesComponent.getInstance().setValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE, null);
            }
            return parsedDate;
        }

        private final void writePluginReleaseValue(LocalDate date) {
            String currentKotlinVersion = KotlinIdePlugin.INSTANCE.getVersion();
            String dateStr = this.getRELEASE_DATE_FORMATTER().format(date);
            PropertiesComponent.getInstance().setValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE, currentKotlinVersion + ":" + dateStr);
        }

        private static final void setupReportingFromRelease$lambda$0() {
            LocalDate localDate;
            try {
                localDate = KotlinPluginReleaseDateProvider.INSTANCE.fetchPluginReleaseDate(KotlinIdePlugin.INSTANCE.getId(), KotlinIdePlugin.INSTANCE.getVersion(), null);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                localDate = null;
            }
            catch (KotlinPluginReleaseDateProvider.ResponseParseException e) {
                LOG.error((Throwable)e);
                return;
            }
            LocalDate releaseDate = localDate;
            if (releaseDate != null) {
                Companion.writePluginReleaseValue(releaseDate);
            }
            isFatalErrorReportingDisabledInRelease = Companion.isFatalErrorReportingWithDefault(releaseDate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

