/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.run.KotlinFE10MainFunctionDetector;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinFE10MainFunctionDetector;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "()V", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMain", "configuration", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector$Configuration;", "isParameterNumberSuitsForMain", "parametersCount", "isTopLevel", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nKotlinFE10MainFunctionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFE10MainFunctionDetector.kt\norg/jetbrains/kotlin/idea/run/KotlinFE10MainFunctionDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1747#2,3:59\n*S KotlinDebug\n*F\n+ 1 KotlinFE10MainFunctionDetector.kt\norg/jetbrains/kotlin/idea/run/KotlinFE10MainFunctionDetector\n*L\n57#1:59,3\n*E\n"})
public final class KotlinFE10MainFunctionDetector
implements KotlinMainFunctionDetector {
    @Override
    public boolean isMain(@NotNull KtNamedFunction function2, @NotNull KotlinMainFunctionDetector.Configuration configuration2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        if (function2.isLocal()) {
            return false;
        }
        int parametersCount = function2.getValueParameters().size();
        if (function2.getReceiverTypeReference() != null) {
            ++parametersCount;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function2.isTopLevel())) {
            return false;
        }
        if (!function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)"main", (Object)function2.getName()) && !this.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (configuration2.getCheckJvmStaticAnnotation() && !function2.isTopLevel() && !this.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings2 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function2);
        MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector(languageVersionSettings2, (Function1)isMain.mainFunctionDetector.1.INSTANCE);
        return mainFunctionDetector2.isMain(function2, configuration2.getCheckJvmStaticAnnotation(), configuration2.getAllowParameterless());
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel2) {
        return switch (parametersCount) {
            case 1 -> true;
            case 0 -> isTopLevel2;
            default -> false;
        };
    }

    private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number) {
        boolean bl;
        block3: {
            List list2 = function2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!(it.getValueArguments().size() == number)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

