/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUsage;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import com.intellij.util.Processor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.slicer.InflowSlicer;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsageSuffix;
import org.jetbrains.kotlin.idea.slicer.OutflowSlicer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001(B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0014\u001a\u00020\bH\u0016J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0000H\u0014J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\bH\u0016J \u0010$\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010&H\u0016J \u0010'\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010&H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage;", "Lcom/intellij/slicer/SliceUsage;", "element", "Lcom/intellij/psi/PsiElement;", "parent", "mode", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "forcedExpressionMode", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/slicer/SliceUsage;Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;Z)V", "params", "Lcom/intellij/slicer/SliceAnalysisParams;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/slicer/SliceAnalysisParams;)V", "getForcedExpressionMode", "()Z", "isDereference", "getMode", "()Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "usageInfo", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage$AdaptedUsageInfo;", "canBeLeaf", "computeText", "", "Lcom/intellij/usages/TextChunk;", "()[Lcom/intellij/usages/TextChunk;", "copy", "getMergedInfos", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "getUsageInfo", "highlightInEditor", "", "initializeUsageInfo", "openTextEditor", "Lcom/intellij/openapi/editor/Editor;", "focus", "processUsagesFlownDownTo", "uniqueProcessor", "Lcom/intellij/util/Processor;", "processUsagesFlownFromThe", "AdaptedUsageInfo", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinSliceUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSliceUsage.kt\norg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,212:1\n1#2:213\n37#3,2:214\n*S KotlinDebug\n*F\n+ 1 KotlinSliceUsage.kt\norg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage\n*L\n99#1:214,2\n*E\n"})
public class KotlinSliceUsage
extends SliceUsage {
    @NotNull
    private final KotlinSliceAnalysisMode mode;
    private final boolean forcedExpressionMode;
    @Nullable
    private AdaptedUsageInfo usageInfo;

    @NotNull
    public final KotlinSliceAnalysisMode getMode() {
        return this.mode;
    }

    public final boolean getForcedExpressionMode() {
        return this.forcedExpressionMode;
    }

    public KotlinSliceUsage(@NotNull PsiElement element3, @NotNull SliceUsage parent2, @NotNull KotlinSliceAnalysisMode mode, boolean forcedExpressionMode) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        super(element3, parent2);
        this.mode = mode;
        this.forcedExpressionMode = forcedExpressionMode;
        this.initializeUsageInfo();
    }

    public KotlinSliceUsage(@NotNull PsiElement element3, @NotNull SliceAnalysisParams params2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        super(element3, params2);
        this.mode = KotlinSliceAnalysisMode.Companion.getDefault();
        this.forcedExpressionMode = false;
        this.initializeUsageInfo();
    }

    private final void initializeUsageInfo() {
        AdaptedUsageInfo adaptedUsageInfo;
        KotlinSliceUsage kotlinSliceUsage = this;
        PsiElement psiElement2 = this.getUsageInfo().getElement();
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            KotlinSliceUsage kotlinSliceUsage2 = kotlinSliceUsage;
            boolean bl = false;
            adaptedUsageInfo = new AdaptedUsageInfo(it, this.mode);
            kotlinSliceUsage = kotlinSliceUsage2;
        } else {
            adaptedUsageInfo = null;
        }
        kotlinSliceUsage.usageInfo = adaptedUsageInfo;
        this.resetCachedPresentation();
    }

    @NotNull
    public UsageInfo getUsageInfo() {
        UsageInfo usageInfo;
        AdaptedUsageInfo adaptedUsageInfo = this.usageInfo;
        if (adaptedUsageInfo != null) {
            usageInfo = adaptedUsageInfo;
        } else {
            UsageInfo usageInfo2 = super.getUsageInfo();
            usageInfo = usageInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)usageInfo2, (String)"getUsageInfo(...)");
        }
        return usageInfo;
    }

    @NotNull
    public UsageInfo[] getMergedInfos() {
        UsageInfo[] usageInfoArray = new UsageInfo[]{this.getUsageInfo()};
        return usageInfoArray;
    }

    protected boolean isDereference() {
        return false;
    }

    @NotNull
    protected TextChunk[] computeText() {
        TextChunk[] textChunkArray = super.computeText();
        Intrinsics.checkNotNullExpressionValue((Object)textChunkArray, (String)"computeText(...)");
        TextChunk[] text2 = textChunkArray;
        List result2 = new ArrayList();
        int n = text2.length;
        for (int j = 0; j < n; ++j) {
            SimpleTextAttributes attributes2;
            int i2 = j;
            TextChunk textChunk = text2[j];
            Intrinsics.checkNotNullExpressionValue((Object)textChunk.getSimpleAttributesIgnoreBackground(), (String)"getSimpleAttributesIgnoreBackground(...)");
            if (this.isDereference()) {
                SimpleTextAttributes simpleTextAttributes = attributes2.derive(attributes2.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes2.getBgColor(), attributes2.getWaveColor());
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"derive(...)");
                attributes2 = simpleTextAttributes;
            }
            if (attributes2.getFontStyle() == 1) {
                SimpleTextAttributes simpleTextAttributes = attributes2.derive(attributes2.getStyle() | 0x10, null, null, null);
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"derive(...)");
                attributes2 = simpleTextAttributes;
            }
            result2.add(new TextChunk(attributes2.toTextAttributes(), textChunk.getText()));
            if (i2 != 0) continue;
            result2.add(new TextChunk(new TextAttributes(), FontUtil.spaceAndThinSpace()));
        }
        for (KotlinSliceAnalysisMode.Behaviour behaviour : CollectionsKt.reversed((Iterable)this.mode.getBehaviourStack())) {
            result2.add(new TextChunk(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.toTextAttributes(), behaviour.getSlicePresentationPrefix()));
        }
        String containerSuffix = KotlinSliceUsageSuffix.INSTANCE.containerSuffix(this);
        if (containerSuffix != null) {
            result2.add(new TextChunk(new TextAttributes(), " "));
            result2.add(new TextChunk(SimpleTextAttributes.GRAY_ATTRIBUTES.toTextAttributes(), containerSuffix));
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TextChunk[0]);
    }

    @Nullable
    public Editor openTextEditor(boolean focus) {
        Project project2 = this.getUsageInfo().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project3, this.getFile(), this.getUsageInfo().getNavigationOffset());
        return FileEditorManager.getInstance((Project)project3).openTextEditor(descriptor2, focus);
    }

    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        UsageInfo usageInfo = this.getUsageInfo();
        Segment segment = usageInfo.getNavigationRange();
        if (segment == null) {
            return;
        }
        Segment range2 = segment;
        SelectInEditorManager.getInstance((Project)this.getUsageInfo().getProject()).selectInEditor(this.getFile(), range2.getStartOffset(), range2.getEndOffset(), false, false);
        if (usageInfo.getNavigationOffset() != range2.getStartOffset()) {
            this.openTextEditor(false);
        }
    }

    @NotNull
    protected KotlinSliceUsage copy() {
        KotlinSliceUsage kotlinSliceUsage;
        PsiElement psiElement2 = this.getUsageInfo().getElement();
        if (psiElement2 == null) {
            throw new IllegalStateException("No more valid usageInfo.element".toString());
        }
        PsiElement element3 = psiElement2;
        if (this.getParent() == null) {
            SliceAnalysisParams sliceAnalysisParams = this.params;
            Intrinsics.checkNotNullExpressionValue((Object)sliceAnalysisParams, (String)"params");
            kotlinSliceUsage = new KotlinSliceUsage(element3, sliceAnalysisParams);
        } else {
            SliceUsage sliceUsage = this.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)sliceUsage, (String)"getParent(...)");
            kotlinSliceUsage = new KotlinSliceUsage(element3, sliceUsage, this.mode, this.forcedExpressionMode);
        }
        return kotlinSliceUsage;
    }

    public boolean canBeLeaf() {
        return this.getElement() != null && Intrinsics.areEqual((Object)this.mode, (Object)KotlinSliceAnalysisMode.Companion.getDefault());
    }

    public void processUsagesFlownDownTo(@NotNull PsiElement element3, @NotNull Processor<? super SliceUsage> uniqueProcessor) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(uniqueProcessor, (String)"uniqueProcessor");
        KtElement ktElement = element3 instanceof KtElement ? (KtElement)element3 : null;
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        KotlinSliceAnalysisMode.Behaviour behaviour = this.mode.getCurrentBehaviour();
        if (behaviour != null) {
            behaviour.processUsages(ktElement2, this, uniqueProcessor);
        } else {
            new InflowSlicer(ktElement2, uniqueProcessor, this).processChildren(this.forcedExpressionMode);
        }
    }

    public void processUsagesFlownFromThe(@NotNull PsiElement element3, @NotNull Processor<? super SliceUsage> uniqueProcessor) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(uniqueProcessor, (String)"uniqueProcessor");
        KtElement ktElement = element3 instanceof KtElement ? (KtElement)element3 : null;
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        KotlinSliceAnalysisMode.Behaviour behaviour = this.mode.getCurrentBehaviour();
        if (behaviour != null) {
            behaviour.processUsages(ktElement2, this, uniqueProcessor);
        } else {
            new OutflowSlicer(ktElement2, uniqueProcessor, this).processChildren(this.forcedExpressionMode);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage$AdaptedUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "mode", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;)V", "equals", "", "other", "", "getNavigationOffset", "", "getNavigationRange", "Lcom/intellij/openapi/util/Segment;", "getRangeInElement", "Lcom/intellij/openapi/util/ProperTextRange;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinSliceUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSliceUsage.kt\norg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage$AdaptedUsageInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
    private static final class AdaptedUsageInfo
    extends UsageInfo {
        @NotNull
        private final KotlinSliceAnalysisMode mode;

        public AdaptedUsageInfo(@NotNull PsiElement element3, @NotNull KotlinSliceAnalysisMode mode) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            super(element3);
            this.mode = mode;
        }

        public boolean equals(@Nullable Object other2) {
            return other2 instanceof AdaptedUsageInfo && super.equals(other2) && Intrinsics.areEqual((Object)this.mode, (Object)((AdaptedUsageInfo)((Object)other2)).mode);
        }

        @Nullable
        public Segment getNavigationRange() {
            TextRange textRange;
            PsiElement psiElement2 = this.getElement();
            if (psiElement2 == null) {
                return null;
            }
            PsiElement element3 = psiElement2;
            PsiElement psiElement3 = element3;
            if (psiElement3 instanceof KtParameter) {
                PsiElement psiElement4 = ((KtParameter)element3).getNameIdentifier();
                Object object = psiElement4 != null ? psiElement4.getTextRange() : null;
                if (object == null) {
                    return super.getNavigationRange();
                }
                TextRange nameRange = object;
                PsiElement psiElement5 = ((KtParameter)element3).getValOrVarKeyword();
                int start2 = psiElement5 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement5) : nameRange.getStartOffset();
                KtTypeReference ktTypeReference = ((KtParameter)element3).getTypeReference();
                int end = ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : nameRange.getEndOffset();
                textRange = new TextRange(start2, end);
            } else if (psiElement3 instanceof KtVariableDeclaration) {
                PsiElement psiElement6 = ((KtVariableDeclaration)element3).getNameIdentifier();
                Object object = psiElement6 != null ? psiElement6.getTextRange() : null;
                if (object == null) {
                    return super.getNavigationRange();
                }
                TextRange nameRange = object;
                PsiElement psiElement7 = ((KtVariableDeclaration)element3).getValOrVarKeyword();
                int start3 = psiElement7 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement7) : nameRange.getStartOffset();
                KtTypeReference ktTypeReference = ((KtVariableDeclaration)element3).getTypeReference();
                int end = ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : nameRange.getEndOffset();
                textRange = new TextRange(start3, end);
            } else if (psiElement3 instanceof KtNamedFunction) {
                PsiElement funKeyword = ((KtNamedFunction)element3).getFunKeyword();
                KtParameterList parameterList2 = ((KtNamedFunction)element3).getValueParameterList();
                KtTypeReference typeReference2 = ((KtNamedFunction)element3).getTypeReference();
                if (funKeyword != null && parameterList2 != null) {
                    KtTypeReference ktTypeReference = typeReference2;
                    textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)funKeyword), ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)parameterList2)));
                } else {
                    textRange = null;
                }
            } else if (psiElement3 instanceof KtPrimaryConstructor) {
                PsiElement psiElement8;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element3));
                if (ktClassOrObject != null && (psiElement8 = ktClassOrObject.getNameIdentifier()) != null) {
                    PsiElement it = psiElement8;
                    boolean bl = false;
                    textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)it), PsiUtilsKt.getEndOffset((PsiElement)element3));
                } else {
                    textRange = null;
                }
            } else {
                textRange = null;
            }
            return textRange != null ? (Segment)textRange : (Segment)new TextRange(element3.getTextOffset(), PsiUtilsKt.getEndOffset((PsiElement)element3));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public ProperTextRange getRangeInElement() {
            ProperTextRange properTextRange;
            PsiElement psiElement2 = this.getElement();
            if (psiElement2 == null) return null;
            TextRange textRange = psiElement2.getTextRange();
            if (textRange == null) {
                return null;
            }
            TextRange elementRange = textRange;
            Segment segment = this.getNavigationRange();
            if (segment != null) {
                Segment segment2;
                Segment segment3;
                Segment it = segment3 = segment;
                boolean bl = false;
                Object object = segment2 = elementRange.contains(it) ? segment3 : null;
                if (segment2 != null) {
                    Segment it2 = segment2;
                    boolean bl2 = false;
                    segment3 = new ProperTextRange(it2.getStartOffset(), it2.getEndOffset()).shiftRight(-elementRange.getStartOffset());
                    if (segment3 != null) {
                        properTextRange = segment3;
                        return properTextRange;
                    }
                }
            }
            properTextRange = super.getRangeInElement();
            return properTextRange;
        }

        public int getNavigationOffset() {
            PsiElement psiElement2 = this.getElement();
            return psiElement2 != null ? psiElement2.getTextOffset() : -1;
        }
    }
}

