/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.CodeBuilderKt;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.CatchStatement;
import org.jetbrains.kotlin.j2k.ast.Statement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/TryStatement;", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "block", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "catches", "", "Lorg/jetbrains/kotlin/j2k/ast/CatchStatement;", "finallyBlock", "(Lorg/jetbrains/kotlin/j2k/ast/Block;Ljava/util/List;Lorg/jetbrains/kotlin/j2k/ast/Block;)V", "getBlock", "()Lorg/jetbrains/kotlin/j2k/ast/Block;", "getFinallyBlock", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.old"})
public final class TryStatement
extends Statement {
    @NotNull
    private final Block block;
    @NotNull
    private final List<CatchStatement> catches;
    @NotNull
    private final Block finallyBlock;

    public TryStatement(@NotNull Block block2, @NotNull List<CatchStatement> catches, @NotNull Block finallyBlock) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        Intrinsics.checkNotNullParameter(catches, (String)"catches");
        Intrinsics.checkNotNullParameter((Object)finallyBlock, (String)"finallyBlock");
        this.block = block2;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public final Block getFinallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        CodeBuilderKt.appendElements$default(builder2.append("try\n").append(this.block).append("\n"), this.catches, "\n", null, null, 12, null).append("\n");
        if (!this.finallyBlock.isEmpty()) {
            builder2.append("finally\n").append(this.finallyBlock);
        }
    }
}

