/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversion;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversionKt;
import org.jetbrains.kotlin.nj2k.symbols.JKMethodSymbol;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentImpl;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpressionImpl;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\tH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\nH\u0002J\f\u0010\u0010\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u0011\u001a\u00020\t*\u00020\tH\u0002J\u0014\u0010\u0012\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\t*\u00020\nH\u0002J\u0014\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\nH\u0002J\u0014\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u001a\u001a\u00020\u0014*\u00020\tH\u0002J\f\u0010\u001b\u001a\u00020\t*\u00020\tH\u0002J\u0014\u0010\u001c\u001a\u00020\t*\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\f\u0010\u001e\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001f\u001a\u00020\t*\u00020\nH\u0002J\f\u0010 \u001a\u00020\t*\u00020\nH\u0002J\f\u0010!\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\"\u001a\u00020\t*\u00020\nH\u0002J\f\u0010#\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/LiteralConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "cannotConvertLiteralMessage", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKLiteralExpression;", "createTodoCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKCallExpressionImpl;", "message", "addTrimIndentCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKQualifiedExpression;", "cleanFloatAndDoubleLiterals", "cleanIntAndLongLiterals", "convertBinaryLiteral", "isLongLiteral", "", "convertCharLiteral", "convertHexLiteral", "convertLiteral", "", "convertOctalLiteral", "isHexLiteral", "replaceFormFeed", "replaceOctalEscapes", "format", "toDoubleLiteral", "toFloatLiteral", "toIntLiteral", "toLongLiteral", "toRawStringLiteral", "toStringLiteral", "kotlin.j2k.new"})
@SourceDebugExtension(value={"SMAP\nLiteralConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteralConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/LiteralConversion\n+ 2 treeUtils.kt\norg/jetbrains/kotlin/nj2k/tree/TreeUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,216:1\n98#2:217\n95#2,6:218\n215#3,2:224\n215#3,2:226\n*S KotlinDebug\n*F\n+ 1 LiteralConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/LiteralConversion\n*L\n27#1:217\n27#1:218,6\n156#1:224,2\n158#1:226,2\n*E\n"})
public final class LiteralConversion
extends RecursiveApplicableConversionBase {
    public LiteralConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        JKTreeElement jKTreeElement;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof JKLiteralExpression)) {
            return this.recurse(element3);
        }
        try {
            JKLiteralExpression $this$applyToElement_u24lambda_u240 = (JKLiteralExpression)element3;
            boolean bl = false;
            this.convertLiteral($this$applyToElement_u24lambda_u240);
            jKTreeElement = $this$applyToElement_u24lambda_u240.getType() == JKLiteralExpression.LiteralType.TEXT_BLOCK ? (JKExpression)this.addTrimIndentCall($this$applyToElement_u24lambda_u240) : (JKExpression)$this$applyToElement_u24lambda_u240;
        }
        catch (NumberFormatException numberFormatException) {
            jKTreeElement = this.createTodoCall(this.cannotConvertLiteralMessage((JKLiteralExpression)element3));
        }
        return jKTreeElement;
    }

    private final JKQualifiedExpression addTrimIndentCall(JKLiteralExpression $this$addTrimIndentCall) {
        JKTreeElement jKTreeElement;
        JKTreeElement $this$copyTreeAndDetach$iv = $this$addTrimIndentCall;
        boolean $i$f$copyTreeAndDetach = false;
        JKTreeElement $this$copyTree$iv$iv = $this$copyTreeAndDetach$iv;
        boolean $i$f$copyTree = false;
        JKFormattingOwner jKFormattingOwner = FormattingKt.withFormattingFrom((JKFormattingOwner)$this$copyTree$iv$iv.copy(), (JKFormattingOwner)$this$copyTree$iv$iv);
        if (jKFormattingOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression");
        }
        JKTreeElement it$iv = jKTreeElement = (JKTreeElement)((JKLiteralExpression)jKFormattingOwner);
        boolean bl = false;
        if (it$iv.getParent() != null) {
            JKElement jKElement = it$iv.getParent();
            Intrinsics.checkNotNull((Object)jKElement);
            it$iv.detach(jKElement);
        }
        return (JKQualifiedExpression)FormattingKt.withFormattingFrom((JKFormattingOwner)new JKQualifiedExpression((JKExpression)jKTreeElement, new JKCallExpressionImpl(this.getSymbolProvider().provideMethodSymbol("kotlin.text.trimIndent"), null, null, this.getTypeFactory().getTypes().getString(), 6, null), null, 4, null), (JKFormattingOwner)$this$addTrimIndentCall);
    }

    private final JKCallExpressionImpl createTodoCall(@NonNls String message2) {
        JKMethodSymbol todoMethodSymbol = this.getSymbolProvider().provideMethodSymbol("kotlin.TODO");
        JKArgumentImpl todoMessageArgument = new JKArgumentImpl(new JKLiteralExpression("\"" + message2 + "\"", JKLiteralExpression.LiteralType.STRING, null, 4, null));
        JKArgument[] jKArgumentArray = new JKArgument[]{todoMessageArgument};
        return new JKCallExpressionImpl(todoMethodSymbol, new JKArgumentList(jKArgumentArray), null, null, 12, null);
    }

    private final String cannotConvertLiteralMessage(JKLiteralExpression element3) {
        String string = element3.getType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String literalType = string2;
        String literalValue = element3.getLiteral();
        return "Could not convert " + literalType + " literal '" + literalValue + "' to Kotlin";
    }

    private final void convertLiteral(JKLiteralExpression $this$convertLiteral) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$convertLiteral.getType().ordinal()]) {
            case 1: {
                string = this.toDoubleLiteral($this$convertLiteral);
                break;
            }
            case 2: {
                string = this.toFloatLiteral($this$convertLiteral);
                break;
            }
            case 3: {
                string = this.toLongLiteral($this$convertLiteral);
                break;
            }
            case 4: {
                string = this.toIntLiteral($this$convertLiteral);
                break;
            }
            case 5: {
                string = this.convertCharLiteral($this$convertLiteral);
                break;
            }
            case 6: {
                string = this.toStringLiteral($this$convertLiteral);
                break;
            }
            case 7: {
                string = this.toRawStringLiteral($this$convertLiteral);
                break;
            }
            default: {
                return;
            }
        }
        $this$convertLiteral.setLiteral(string);
    }

    private final String toDoubleLiteral(JKLiteralExpression $this$toDoubleLiteral) {
        Object text2 = this.cleanFloatAndDoubleLiterals($this$toDoubleLiteral.getLiteral());
        if (this.isHexLiteral((String)text2)) {
            text2 = String.valueOf(Double.parseDouble((String)text2));
        }
        if (!StringsKt.contains$default((CharSequence)((CharSequence)text2), (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)((CharSequence)text2), (CharSequence)"e", (boolean)true)) {
            text2 = (String)text2 + ".";
        }
        if (StringsKt.endsWith$default((String)text2, (String)".", (boolean)false, (int)2, null)) {
            text2 = (String)text2 + "0";
        }
        return text2;
    }

    private final boolean isHexLiteral(String $this$isHexLiteral) {
        return StringsKt.startsWith((String)$this$isHexLiteral, (String)"0x", (boolean)true);
    }

    private final String toFloatLiteral(JKLiteralExpression $this$toFloatLiteral) {
        Object text2 = this.cleanFloatAndDoubleLiterals($this$toFloatLiteral.getLiteral());
        if (this.isHexLiteral((String)text2)) {
            text2 = String.valueOf(Float.parseFloat((String)text2));
        }
        if (!StringsKt.endsWith$default((String)text2, (String)"f", (boolean)false, (int)2, null)) {
            text2 = (String)text2 + "f";
        }
        return text2;
    }

    private final String toLongLiteral(JKLiteralExpression $this$toLongLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toLongLiteral.getLiteral()), true), true), true) + "L";
    }

    private final String toIntLiteral(JKLiteralExpression $this$toIntLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toIntLiteral.getLiteral()), false), false), false);
    }

    private final String convertHexLiteral(String $this$convertHexLiteral, boolean isLongLiteral) {
        Object object;
        if (!this.isHexLiteral($this$convertHexLiteral)) {
            return $this$convertHexLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertHexLiteral, (int)2), 16);
        if (isLongLiteral && value2.bitLength() > 63) {
            String string = Long.toString(value2.longValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            object = "-0x" + string2;
        } else if (!isLongLiteral && value2.bitLength() > 31) {
            String string = Integer.toString(value2.intValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string3 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            object = "-0x" + string3;
        } else {
            object = $this$convertHexLiteral;
        }
        return object;
    }

    private final String convertBinaryLiteral(String $this$convertBinaryLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith((String)$this$convertBinaryLiteral, (String)"0b", (boolean)true)) {
            return $this$convertBinaryLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertBinaryLiteral, (int)2), 2);
        if (isLongLiteral) {
            String string2 = Long.toString(value2.longValue(), CharsKt.checkRadix((int)10));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        } else {
            string = String.valueOf(value2.intValue());
        }
        return string;
    }

    private final String convertOctalLiteral(String $this$convertOctalLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith$default((String)$this$convertOctalLiteral, (String)"0", (boolean)false, (int)2, null) || $this$convertOctalLiteral.length() == 1 || Character.toLowerCase($this$convertOctalLiteral.charAt(1)) == 'x') {
            return $this$convertOctalLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertOctalLiteral, (int)1), 8);
        if (isLongLiteral) {
            String string2 = Long.toString(value2.longValue(), CharsKt.checkRadix((int)10));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        } else {
            String string3 = Integer.toString(value2.intValue(), CharsKt.checkRadix((int)10));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        }
        return string;
    }

    private final String cleanFloatAndDoubleLiterals(String $this$cleanFloatAndDoubleLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)$this$cleanFloatAndDoubleLiterals, (String)"L", (String)"", (boolean)true), (String)"d", (String)"", (boolean)true), (String)".e", (String)"e", (boolean)true), (String)".f", (String)"", (boolean)true), (String)"f", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String cleanIntAndLongLiterals(String $this$cleanIntAndLongLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)$this$cleanIntAndLongLiterals, (String)"l", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String convertCharLiteral(JKLiteralExpression $this$convertCharLiteral) {
        CharSequence charSequence = $this$convertCharLiteral.getLiteral();
        Regex regex = LiteralConversionKt.access$getCharOctalEscapeRegex$p();
        Function1 function1 = convertCharLiteral.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    private final String toStringLiteral(JKLiteralExpression $this$toStringLiteral) {
        CharSequence charSequence = this.replaceOctalEscapes($this$toStringLiteral.getLiteral(), "%s\\u%04x");
        Regex regex = LiteralConversionKt.access$getDollarRegex$p();
        String string = "\\\\$0";
        return this.replaceFormFeed(regex.replace(charSequence, string));
    }

    private final String toRawStringLiteral(JKLiteralExpression $this$toRawStringLiteral) {
        Map.Entry entry;
        Map.Entry element$iv;
        CharSequence charSequence = $this$toRawStringLiteral.getLiteral();
        Regex regex = LiteralConversionKt.access$getImplicitNewlineRegex$p();
        Object object = "$1";
        $this$toRawStringLiteral.setLiteral(regex.replace(charSequence, (String)object));
        while (StringsKt.contains$default((CharSequence)$this$toRawStringLiteral.getLiteral(), (CharSequence)"\\n", (boolean)false, (int)2, null)) {
            charSequence = $this$toRawStringLiteral.getLiteral();
            regex = LiteralConversionKt.access$getEscapedNewlineRegex$p();
            object = "\n$1$2\n$1";
            $this$toRawStringLiteral.setLiteral(regex.replace(charSequence, (String)object));
        }
        Map $this$forEach$iv = LiteralConversionKt.access$getRawStringSpecialCharSimpleReplacements$p();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String old = (String)entry.getKey();
            String string = (String)entry.getValue();
            $this$toRawStringLiteral.setLiteral(StringsKt.replace$default((String)$this$toRawStringLiteral.getLiteral(), (String)old, (String)string, (boolean)false, (int)4, null));
        }
        $this$forEach$iv = LiteralConversionKt.access$getRawStringSpecialCharRegexReplacements$p();
        $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            entry = element$iv = object.next();
            boolean bl = false;
            Regex pattern2 = (Regex)entry.getKey();
            String replacement2 = (String)entry.getValue();
            CharSequence charSequence2 = $this$toRawStringLiteral.getLiteral();
            Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(replacement2){
                final /* synthetic */ String $replacement;
                {
                    this.$replacement = $replacement;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult matchResult2) {
                    Intrinsics.checkNotNullParameter((Object)matchResult2, (String)"matchResult");
                    String leadingBackslashes = (String)matchResult2.getGroupValues().get(1);
                    return leadingBackslashes.length() % 2 == 0 ? (CharSequence)(leadingBackslashes + this.$replacement) : (CharSequence)matchResult2.getValue();
                }
            };
            $this$toRawStringLiteral.setLiteral(pattern2.replace(charSequence2, function1));
        }
        charSequence = StringsKt.replace$default((String)this.replaceOctalEscapes($this$toRawStringLiteral.getLiteral(), "%s${'\\u%04x'}"), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
        Regex regex2 = LiteralConversionKt.access$getClosingTripleQuoteRegex$p();
        object = "\n$1$2\n$1\"\"\"";
        return regex2.replace(charSequence, (String)object);
    }

    private final String replaceOctalEscapes(String $this$replaceOctalEscapes, String format) {
        CharSequence charSequence = $this$replaceOctalEscapes;
        Regex regex = LiteralConversionKt.access$getStringOctalEscapeRegex$p();
        Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(format){
            final /* synthetic */ String $format;
            {
                this.$format = $format;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult2) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)matchResult2, (String)"matchResult");
                String leadingBackslashes = (String)matchResult2.getGroupValues().get(1);
                if (leadingBackslashes.length() % 2 == 0) {
                    String string = this.$format;
                    Object[] objectArray = new Object[]{leadingBackslashes, Integer.parseInt((String)matchResult2.getGroupValues().get(2), 8)};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    charSequence = string2;
                } else {
                    charSequence = matchResult2.getValue();
                }
                return charSequence;
            }
        };
        return regex.replace(charSequence, function1);
    }

    private final String replaceFormFeed(String $this$replaceFormFeed) {
        CharSequence charSequence = $this$replaceFormFeed;
        Regex regex = LiteralConversionKt.access$getFormFeedRegex$p();
        Function1 function1 = replaceFormFeed.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JKLiteralExpression.LiteralType.values().length];
            try {
                nArray[JKLiteralExpression.LiteralType.DOUBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.CHAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.TEXT_BLOCK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

