/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.printing.JKPrinter;
import org.jetbrains.kotlin.nj2k.printing.JKPrinterBase;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKComment;
import org.jetbrains.kotlin.nj2k.tree.JKDeclaration;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00070\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0007H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000eH\u0002J\u0016\u0010\u0014\u001a\u00020\u0013*\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKCommentPrinter;", "", "printer", "Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;", "(Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;)V", "printedTokens", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKComment;", "printCommentsAndLineBreaksAfter", "", "element", "Lorg/jetbrains/kotlin/nj2k/tree/JKFormattingOwner;", "printCommentsAndLineBreaksBefore", "createText", "", "", "parent", "escapedText", "hasNoLineBreakAfterSingleLineComment", "", "shouldBeDropped", "kotlin.j2k.new"})
@SourceDebugExtension(value={"SMAP\nJKCommentPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JKCommentPrinter.kt\norg/jetbrains/kotlin/nj2k/printing/JKCommentPrinter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class JKCommentPrinter {
    @NotNull
    private final JKPrinter printer;
    @NotNull
    private final Set<JKComment> printedTokens;

    public JKCommentPrinter(@NotNull JKPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.printer = printer;
        this.printedTokens = new LinkedHashSet();
    }

    public final void printCommentsAndLineBreaksBefore(@NotNull JKFormattingOwner element3) {
        boolean shouldAddLineBreakAfterComment;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String text2 = JKCommentPrinter.createText$default(this, element3.getCommentsBefore(), null, 1, null);
        this.printer.print(text2);
        if (this.printer.getLastSymbolIsLineBreak()) {
            return;
        }
        boolean bl = element3 instanceof JKDeclaration && !((Collection)element3.getCommentsBefore()).isEmpty() || this.hasNoLineBreakAfterSingleLineComment(text2) ? true : (shouldAddLineBreakAfterComment = false);
        if (FormattingKt.getHasLineBreakBefore(element3) || shouldAddLineBreakAfterComment) {
            JKPrinterBase.println$default(this.printer, 0, 1, null);
        }
    }

    public final void printCommentsAndLineBreaksAfter(@NotNull JKFormattingOwner element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        JKTreeElement jKTreeElement = element3 instanceof JKTreeElement ? (JKTreeElement)element3 : null;
        JKElement jKElement = jKTreeElement != null ? jKTreeElement.getParent() : null;
        JKFormattingOwner parent2 = jKElement instanceof JKFormattingOwner ? (JKFormattingOwner)((Object)jKElement) : null;
        String text2 = this.createText(element3.getCommentsAfter(), parent2);
        this.printer.print(text2);
        if (FormattingKt.getHasLineBreakAfter(element3)) {
            this.printer.println(element3.getLineBreaksAfter());
        } else if (this.hasNoLineBreakAfterSingleLineComment(text2)) {
            JKPrinterBase.println$default(this.printer, 0, 1, null);
        }
    }

    private final String createText(List<JKComment> $this$createText, JKFormattingOwner parent2) {
        StringBuilder stringBuilder;
        StringBuilder $this$createText_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean needNewLine = false;
        for (JKComment comment2 : $this$createText) {
            Object object;
            if (this.shouldBeDropped(comment2, parent2)) continue;
            ((Collection)this.printedTokens).add(comment2);
            String text2 = this.escapedText(comment2);
            if (needNewLine) {
                boolean bl2;
                if (comment2.getIndent() != null) {
                    String it;
                    boolean bl3 = false;
                    bl2 = StringUtil.containsLineBreak((CharSequence)it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    Intrinsics.checkNotNullExpressionValue((Object)$this$createText_u24lambda_u241.append('\n'), (String)"append('\\n')");
                }
            }
            if ((object = comment2.getIndent()) == null) {
                object = Character.valueOf(' ');
            }
            $this$createText_u24lambda_u241.append(object);
            $this$createText_u24lambda_u241.append(text2);
            needNewLine = StringsKt.startsWith$default((String)text2, (String)"//", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text2, (char)'\n', (boolean)false, (int)2, null);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static /* synthetic */ String createText$default(JKCommentPrinter jKCommentPrinter, List list2, JKFormattingOwner jKFormattingOwner, int n, Object object) {
        if ((n & 1) != 0) {
            jKFormattingOwner = null;
        }
        return jKCommentPrinter.createText(list2, jKFormattingOwner);
    }

    private final boolean shouldBeDropped(JKComment $this$shouldBeDropped, JKFormattingOwner parent2) {
        if (this.printedTokens.contains($this$shouldBeDropped)) {
            return true;
        }
        if (StringsKt.startsWith$default((String)$this$shouldBeDropped.getText(), (String)"//noinspection", (boolean)false, (int)2, null)) {
            return true;
        }
        Object object = parent2;
        return object != null && (object = object.getCommentsAfter()) != null ? object.contains($this$shouldBeDropped) : false;
    }

    private final String escapedText(JKComment $this$escapedText) {
        return $this$escapedText.isSingleLine() ? $this$escapedText.getText() : (StringsKt.indexOf$default((CharSequence)$this$escapedText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)$this$escapedText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) ? $this$escapedText.getText() : StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)$this$escapedText.getText(), (String)"/*", (String)"/ *", (boolean)false, (int)4, null), (String)"/ *", (String)"/*", (boolean)false, (int)4, null));
    }

    private final boolean hasNoLineBreakAfterSingleLineComment(String $this$hasNoLineBreakAfterSingleLineComment) {
        return StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (char)'\n', (int)0, (boolean)false, (int)6, null) < StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (String)"//", (int)0, (boolean)false, (int)6, null);
    }
}

