/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsFunAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "jsFunFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmJsFunAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmJsFunAnnotationChecker INSTANCE = new WasmJsFunAnnotationChecker();
    @NotNull
    private static final FqName jsFunFqName = new FqName("kotlin.JsFun");

    private WasmJsFunAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(jsFunFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor jsFun = annotationDescriptor;
        if (!DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) || !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)jsFun.getSource());
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            PsiElement jsFunPsi = psiElement;
            context.getTrace().report(ErrorsWasm.WRONG_JS_FUN_TARGET.on(jsFunPsi));
        }
    }
}

