/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lgit4idea/actions/branch/GitUpdateSelectedBranchAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "()V", "disabledForRemote", "", "getDisabledForRemote", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "updateIfEnabledAndVisible", "intellij.vcs.git"})
public final class GitUpdateSelectedBranchAction
extends GitSingleBranchAction {
    private final boolean disabledForRemote;

    public GitUpdateSelectedBranchAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.update", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
        this.disabledForRemote = true;
    }

    @Override
    public boolean getDisabledForRemote() {
        return this.disabledForRemote;
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        if (!GitBranchActionsUtilKt.hasRemotes(project)) {
            $this$updateIfEnabledAndVisible_u24lambda_u240.setEnabledAndVisible(false);
            return;
        }
        String string = branch.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String branchName = string;
        Object[] objectArray = GitVcsSettings.getInstance(project).getUpdateMethod().getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getMethodName(...)");
        Object[] objectArray2 = objectArray;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = objectArray2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String updateMethod = string2;
        objectArray2 = new Object[]{CollectionsKt.listOf((Object)branchName), updateMethod};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message("action.Git.Update.Selected.description", objectArray2));
        boolean fetchRunning = GitFetchSupport.fetchSupport(project).isFetchRunning();
        $this$updateIfEnabledAndVisible_u24lambda_u240.setEnabled(!fetchRunning);
        if (fetchRunning) {
            $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message("branches.update.is.already.running", new Object[0]));
            return;
        }
        boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(CollectionsKt.listOf((Object)branchName), repositories2);
        $this$updateIfEnabledAndVisible_u24lambda_u240.setEnabled(trackingInfosExist);
        if (!trackingInfosExist) {
            Object[] objectArray3 = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(branchName)};
            $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message("branches.tracking.branch.doesn.t.configured.for.s", objectArray3));
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        GitBranchActionsUtilKt.updateBranches(project, repositories2, CollectionsKt.listOf((Object)branch.getName()));
    }
}

