/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.push.GitPushListener;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushResultNotification;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitVcsPushOptionValue;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.HashRange;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPusher
extends Pusher<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final GitPushSupport myPushSupport;

    GitPusher(@NotNull Project project, @NotNull GitVcsSettings settings, @NotNull GitPushSupport pushSupport) {
        if (project == null) {
            GitPusher.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GitPusher.$$$reportNull$$$0(1);
        }
        if (pushSupport == null) {
            GitPusher.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySettings = settings;
        this.myPushSupport = pushSupport;
    }

    public void push(@NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable VcsPushOptionValue optionValue, boolean force) {
        boolean skipHook;
        GitPushTagMode pushTagMode;
        if (pushSpecs == null) {
            GitPusher.$$$reportNull$$$0(3);
        }
        this.expireExistingErrorsAndWarnings();
        if (optionValue instanceof GitVcsPushOptionValue) {
            pushTagMode = ((GitVcsPushOptionValue)optionValue).getPushTagMode();
            skipHook = ((GitVcsPushOptionValue)optionValue).isSkipHook();
        } else {
            pushTagMode = null;
            skipHook = false;
        }
        this.mySettings.setPushTagMode(pushTagMode);
        GitPushOperation pushOperation = new GitPushOperation(this.myProject, this.myPushSupport, pushSpecs, pushTagMode, force, skipHook);
        GitPusher.pushAndNotify(this.myProject, pushOperation);
    }

    public static void pushAndNotify(@NotNull Project project, @NotNull GitPushOperation pushOperation) {
        if (project == null) {
            GitPusher.$$$reportNull$$$0(4);
        }
        if (pushOperation == null) {
            GitPusher.$$$reportNull$$$0(5);
        }
        GitPushResult pushResult = pushOperation.execute();
        GitPushListener pushListener = (GitPushListener)project.getMessageBus().syncPublisher(GitPushListener.getTOPIC());
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : pushResult.getResults().entrySet()) {
            pushListener.onCompleted(entry.getKey(), entry.getValue());
        }
        Map<GitRepository, HashRange> updatedRanges = pushResult.getUpdatedRanges();
        GitUpdateInfoAsLog.NotificationData notificationData = !updatedRanges.isEmpty() ? new GitUpdateInfoAsLog(project, updatedRanges).calculateDataAndCreateLogTab() : null;
        ApplicationManager.getApplication().invokeLater(() -> {
            boolean multiRepoProject = GitUtil.getRepositoryManager(project).moreThanOneRoot();
            GitPushResultNotification.create(project, pushResult, pushOperation, multiRepoProject, notificationData).notify(project);
        });
    }

    protected void expireExistingErrorsAndWarnings() {
        GitPushResultNotification[] existingNotifications;
        for (GitPushResultNotification notification2 : existingNotifications = (GitPushResultNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(GitPushResultNotification.class, this.myProject)) {
            if (notification2.getType() == NotificationType.INFORMATION) continue;
            notification2.expire();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSupport";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpecs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushOperation";
                break;
            }
        }
        objectArray2[1] = "git4idea/push/GitPusher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "push";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "pushAndNotify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

