/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitCommitTemplate;
import git4idea.repo.GitCommitTemplateListener;
import git4idea.repo.GitCommitTemplateTracker;
import git4idea.repo.GitCommitTemplateTrackerKt;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\b\b\u0001\u0018\u0000 32\u00020\u00012\u00020\u00022\u00020\u0003:\u000234B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u0014\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0007J\u0016\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0007J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0016\u0010'\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\b\u0010*\u001a\u00020\u000bH\u0007J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0003J\u001a\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\b\u00100\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u00101\u001a\u0004\u0018\u00010\u001d*\u00020\u000e2\u0006\u00102\u001a\u00020\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lgit4idea/repo/GitCommitTemplateTracker;", "Lgit4idea/repo/GitConfigListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "TEMPLATES_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_initPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "commitTemplates", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/repo/GitCommitTemplate;", "initPromise", "Lorg/jetbrains/concurrency/Promise;", "getInitPromise", "()Lorg/jetbrains/concurrency/Promise;", "dispose", "exists", "", "repository", "filesChanged", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "getPathRelativeToUserHome", "", "fileNameOrPath", "getTemplateContent", "isEventToReloadTemplateContent", "event", "watchedTemplatePath", "isEventToStopTracking", "loadTemplateContent", "commitTemplateFilePath", "notifyConfigChanged", "processEvents", "reloadCommitTemplateContent", "resolveCommitTemplatePath", "start", "stopTrackCommitTemplate", "templatesCount", "", "trackCommitTemplate", "updateTemplatePath", "newTemplatePath", "findPathRelativeToRootDirs", "relativeFilePath", "Companion", "GitCommitTemplateTrackerStartupActivity", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitTemplateTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1#2:310\n1747#3,3:311\n1855#3,2:314\n1549#3:316\n1620#3,3:317\n*S KotlinDebug\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker\n*L\n62#1:311,3\n94#1:314,2\n259#1:316\n259#1:317,3\n*E\n"})
public final class GitCommitTemplateTracker
implements GitConfigListener,
AsyncVfsEventsListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GitRepository, GitCommitTemplate> commitTemplates;
    @NotNull
    private final ReentrantReadWriteLock TEMPLATES_LOCK;
    @NotNull
    private final AsyncPromise<Unit> _initPromise;

    public GitCommitTemplateTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.commitTemplates = new LinkedHashMap();
        this.TEMPLATES_LOCK = new ReentrantReadWriteLock();
        this._initPromise = new AsyncPromise();
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitConfigListener.TOPIC, (Object)this);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)this);
    }

    @NotNull
    public final Promise<Unit> getInitPromise() {
        return (Promise)this._initPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int templatesCount() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.commitTemplates.values().size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean exists(@Nullable GitRepository repository) {
        boolean bl;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl2;
            block8: {
                boolean bl3 = false;
                if (repository != null) {
                    Object object = this.commitTemplates.get(repository);
                    bl2 = object != null && (object = ((GitCommitTemplate)object).getContent()) != null ? !StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
                } else {
                    Iterable $this$any$iv = this.commitTemplates.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            GitCommitTemplate it = (GitCommitTemplate)element$iv;
                            boolean bl4 = false;
                            boolean bl5 = !StringsKt.isBlank((CharSequence)it.getContent());
                            if (!bl5) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
            }
            bl = bl2;
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    public static /* synthetic */ boolean exists$default(GitCommitTemplateTracker gitCommitTemplateTracker, GitRepository gitRepository, int n, Object object) {
        if ((n & 1) != 0) {
            gitRepository = null;
        }
        return gitCommitTemplateTracker.exists(gitRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @Nullable
    public final String getTemplateContent(@Nullable GitRepository repository) {
        String string;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            String string2;
            boolean bl = false;
            if (repository != null) {
                Object object = this.commitTemplates.get(repository);
                if (object != null && (object = ((GitCommitTemplate)object).getContent()) != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = (CharSequence)object;
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl2 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string2 = (String)charSequence;
                } else {
                    string2 = null;
                }
            } else {
                Object object = (GitCommitTemplate)CollectionsKt.firstOrNull((Iterable)this.commitTemplates.values());
                if (object != null && (object = ((GitCommitTemplate)object).getContent()) != null) {
                    CharSequence charSequence;
                    CharSequence charSequence3 = (CharSequence)object;
                    if (StringsKt.isBlank((CharSequence)charSequence3)) {
                        boolean bl3 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence3;
                    }
                    string2 = (String)charSequence;
                } else {
                    string2 = null;
                }
            }
            string = string2;
        }
        finally {
            readLock.unlock();
        }
        return string;
    }

    public static /* synthetic */ String getTemplateContent$default(GitCommitTemplateTracker gitCommitTemplateTracker, GitRepository gitRepository, int n, Object object) {
        if ((n & 1) != 0) {
            gitRepository = null;
        }
        return gitCommitTemplateTracker.getTemplateContent(gitRepository);
    }

    @Override
    public void notifyConfigChanged(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.trackCommitTemplate(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        boolean bl;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.commitTemplates.isEmpty();
        }
        finally {
            readLock.unlock();
        }
        if (bl) {
            return;
        }
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> GitCommitTemplateTracker.filesChanged$lambda$7(this, events));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @RequiresBackgroundThread
    public final void start() {
        try {
            ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).loadingStarted();
            Collection<GitRepository> collection = GitUtil.getRepositories(this.project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GitRepository p0 = (GitRepository)element$iv;
                boolean bl = false;
                this.trackCommitTemplate(p0);
            }
            ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).loadingFinished();
        }
        finally {
            this._initPromise.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processEvents(List<? extends VFileEvent> events) {
        Map map2;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            map2 = MapsKt.toMap(this.commitTemplates);
        }
        finally {
            readLock.unlock();
        }
        Map allTemplates = map2;
        if (allTemplates.isEmpty()) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            ProgressManager.checkCanceled();
            for (Map.Entry entry : allTemplates.entrySet()) {
                String watchedTemplatePath;
                GitRepository repository = (GitRepository)entry.getKey();
                GitCommitTemplate template = (GitCommitTemplate)entry.getValue();
                ProgressManager.checkCanceled();
                Intrinsics.checkNotNullExpressionValue((Object)template.getWatchedRoot().getRootPath(), (String)"getRootPath(...)");
                boolean templateChanged = false;
                if (this.isEventToStopTracking(vFileEvent, watchedTemplatePath)) {
                    var11_15 = this;
                    synchronized (var11_15) {
                        boolean $i$a$-synchronized-GitCommitTemplateTracker$processEvents$332 = false;
                        this.stopTrackCommitTemplate(repository);
                        Unit $i$a$-synchronized-GitCommitTemplateTracker$processEvents$332 = Unit.INSTANCE;
                    }
                    templateChanged = true;
                } else if (this.isEventToReloadTemplateContent(vFileEvent, watchedTemplatePath)) {
                    var11_15 = this;
                    synchronized (var11_15) {
                        boolean bl = false;
                        this.reloadCommitTemplateContent(repository);
                        Unit unit = Unit.INSTANCE;
                    }
                    templateChanged = true;
                }
                if (!templateChanged) continue;
                ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).notifyCommitTemplateChanged(repository);
            }
        }
    }

    private final boolean isEventToStopTracking(VFileEvent event, String watchedTemplatePath) {
        return event instanceof VFileDeleteEvent ? Intrinsics.areEqual((Object)((VFileDeleteEvent)event).getPath(), (Object)watchedTemplatePath) : (event instanceof VFileMoveEvent ? Intrinsics.areEqual((Object)((VFileMoveEvent)event).getOldPath(), (Object)watchedTemplatePath) : (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename() ? Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getOldPath(), (Object)watchedTemplatePath) : false));
    }

    private final boolean isEventToReloadTemplateContent(VFileEvent event, String watchedTemplatePath) {
        return event instanceof VFileContentChangeEvent && Intrinsics.areEqual((Object)((VFileContentChangeEvent)event).getPath(), (Object)watchedTemplatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopTrackCommitTemplate(GitRepository repository) {
        GitCommitTemplate gitCommitTemplate;
        ReentrantReadWriteLock reentrantReadWriteLock = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            GitCommitTemplate gitCommitTemplate2 = this.commitTemplates.remove(repository);
            gitCommitTemplate = gitCommitTemplate2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (gitCommitTemplate == null) {
            return;
        }
        GitCommitTemplate commitTemplate = gitCommitTemplate;
        LocalFileSystem.getInstance().removeWatchedRoot(commitTemplate.getWatchedRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reloadCommitTemplateContent(GitRepository repository) {
        GitCommitTemplate gitCommitTemplate;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            GitCommitTemplate gitCommitTemplate2 = this.commitTemplates.get(repository);
            gitCommitTemplate = gitCommitTemplate2;
        }
        finally {
            readLock.unlock();
        }
        Object object = gitCommitTemplate;
        if (gitCommitTemplate == null || (object = ((GitCommitTemplate)object).getWatchedRoot()) == null || (object = object.getRootPath()) == null) {
            return;
        }
        Object commitTemplateRootPath = object;
        String string = this.loadTemplateContent(repository, (String)commitTemplateRootPath);
        if (string == null) {
            return;
        }
        String loadedContent = string;
        ReentrantReadWriteLock reentrantReadWriteLock = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock2.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Unit unit;
            boolean bl = false;
            GitCommitTemplate gitCommitTemplate3 = this.commitTemplates.get(repository);
            if (gitCommitTemplate3 != null) {
                GitCommitTemplate commitTemplate = gitCommitTemplate3;
                boolean bl2 = false;
                commitTemplate.setContent(loadedContent);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock2.lock();
            }
            writeLock.unlock();
        }
    }

    private final String loadTemplateContent(GitRepository repository, String commitTemplateFilePath) {
        try {
            String string = FileUtil.loadFile((File)new File(commitTemplateFilePath), (String)GitConfigUtil.getCommitEncoding(this.project, repository.getRoot()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
            String fileContent = string;
            if (StringsKt.isBlank((CharSequence)fileContent)) {
                GitCommitTemplateTrackerKt.access$getLOG$p().warn("Empty or blank commit template detected for repository " + repository + " by path " + commitTemplateFilePath);
            }
            return fileContent;
        }
        catch (IOException e) {
            GitCommitTemplateTrackerKt.access$getLOG$p().warn("Cannot load commit template for repository " + repository + " by path " + commitTemplateFilePath, (Throwable)e);
            return null;
        }
    }

    private final String resolveCommitTemplatePath(GitRepository repository) {
        String[] stringArray = new String[]{"commit.template"};
        String string = Git.getInstance().config(repository, stringArray).getOutputAsJoinedString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputAsJoinedString(...)");
        String gitCommitTemplatePath = string;
        if (StringsKt.isBlank((CharSequence)gitCommitTemplatePath)) {
            return null;
        }
        return FileUtil.exists((String)gitCommitTemplatePath) ? gitCommitTemplatePath : (String)ObjectUtils.chooseNotNull((Object)this.getPathRelativeToUserHome(gitCommitTemplatePath), (Object)this.findPathRelativeToRootDirs(repository, gitCommitTemplatePath));
    }

    private final String getPathRelativeToUserHome(String fileNameOrPath) {
        if (StringsKt.startsWith$default((CharSequence)fileNameOrPath, (char)'~', (boolean)false, (int)2, null)) {
            String string = SystemProperties.getUserHome();
            String string2 = fileNameOrPath.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            File fileAtUserHome = new File(string, string2);
            if (fileAtUserHome.exists()) {
                return fileAtUserHome.getPath();
            }
        }
        return null;
    }

    private final String findPathRelativeToRootDirs(GitRepository $this$findPathRelativeToRootDirs, String relativeFilePath) {
        if (StringsKt.startsWith$default((CharSequence)relativeFilePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)relativeFilePath, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        for (VirtualFile rootDir : $this$findPathRelativeToRootDirs.getRepositoryFiles().getRootDirs()) {
            Object rootDirParent;
            File templateFile;
            Object object = rootDir.getParent();
            if (object == null) continue;
            if ((object = object.getPath()) == null || !(templateFile = new File((String)(rootDirParent = object), relativeFilePath)).exists()) continue;
            return templateFile.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void trackCommitTemplate(GitRepository repository) {
        boolean bl;
        String newTemplatePath = this.resolveCommitTemplatePath(repository);
        GitCommitTemplateTracker gitCommitTemplateTracker = this;
        synchronized (gitCommitTemplateTracker) {
            boolean bl2 = false;
            bl = this.updateTemplatePath(repository, newTemplatePath);
        }
        boolean templateChanged = bl;
        if (templateChanged) {
            ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).notifyCommitTemplateChanged(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateTemplatePath(GitRepository repository, String newTemplatePath) {
        LocalFileSystem.WatchRequest newWatchRoot;
        String oldTemplatePath;
        LocalFileSystem.WatchRequest oldWatchRoot;
        LocalFileSystem.WatchRequest $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22 = false;
            GitCommitTemplate gitCommitTemplate = this.commitTemplates.get(repository);
            $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22 = gitCommitTemplate != null ? gitCommitTemplate.getWatchedRoot() : null;
        }
        finally {
            readLock.unlock();
        }
        LocalFileSystem.WatchRequest watchRequest = oldWatchRoot = $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22;
        String string = oldTemplatePath = watchRequest != null ? watchRequest.getRootPath() : null;
        if (Intrinsics.areEqual((Object)oldTemplatePath, (Object)newTemplatePath)) {
            return false;
        }
        if (newTemplatePath == null) {
            this.stopTrackCommitTemplate(repository);
            return true;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        lfs.refreshAndFindFileByPath(newTemplatePath);
        String templateContent = this.loadTemplateContent(repository, newTemplatePath);
        if (templateContent == null) {
            this.stopTrackCommitTemplate(repository);
            return true;
        }
        LocalFileSystem.WatchRequest watchRequest2 = oldWatchRoot;
        LocalFileSystem.WatchRequest watchRequest3 = newWatchRoot = watchRequest2 != null ? lfs.replaceWatchedRoot(watchRequest2, newTemplatePath, false) : lfs.addRootToWatch(newTemplatePath, false);
        if (newWatchRoot == null) {
            GitCommitTemplateTrackerKt.access$getLOG$p().error("Cannot add root to watch " + newTemplatePath);
            if (oldWatchRoot != null) {
                this.stopTrackCommitTemplate(repository);
                return true;
            }
            return false;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock2.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.commitTemplates.put(repository, new GitCommitTemplate(newWatchRoot, templateContent));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock2.lock();
            }
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void dispose() {
        List $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22;
        Object object = this.TEMPLATES_LOCK.readLock();
        ((ReentrantReadWriteLock.ReadLock)object).lock();
        try {
            void $this$mapTo$iv$iv;
            boolean $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22 = false;
            Iterable $this$map$iv = this.commitTemplates.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                GitCommitTemplate gitCommitTemplate = (GitCommitTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getWatchedRoot());
            }
            $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22 = (List)destination$iv$iv;
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        List watchRootsToDispose = $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22;
        if (watchRootsToDispose.isEmpty()) {
            return;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        for (LocalFileSystem.WatchRequest watchedRoot : watchRootsToDispose) {
            lfs.removeWatchedRoot(watchedRoot);
        }
        object = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.commitTemplates.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @JvmOverloads
    public final boolean exists() {
        return GitCommitTemplateTracker.exists$default(this, null, 1, null);
    }

    @JvmOverloads
    @Nullable
    public final String getTemplateContent() {
        return GitCommitTemplateTracker.getTemplateContent$default(this, null, 1, null);
    }

    private static final void filesChanged$lambda$7(GitCommitTemplateTracker this$0, List $events) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$events, (String)"$events");
        this$0.processEvents($events);
    }

    @JvmStatic
    @NotNull
    public static final GitCommitTemplateTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lgit4idea/repo/GitCommitTemplateTracker$Companion;", "", "()V", "getInstance", "Lgit4idea/repo/GitCommitTemplateTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitCommitTemplateTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,309:1\n30#2,3:310\n*S KotlinDebug\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker$Companion\n*L\n282#1:310,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitCommitTemplateTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitCommitTemplateTracker> serviceClass$iv = GitCommitTemplateTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (GitCommitTemplateTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\b"}, d2={"Lgit4idea/repo/GitCommitTemplateTracker$GitCommitTemplateTrackerStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.git"})
    public static final class GitCommitTemplateTrackerStartupActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    ProjectLevelVcsManager.getInstance((Project)this.$project).runAfterInitialization(() -> execute.2.invoke$lambda$0(this.$project));
                }

                private static final void invoke$lambda$0(Project $project) {
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    GitCommitTemplateTracker.Companion.getInstance($project).start();
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

