/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.internal.performance.LatencyRecord;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.utils.DaemonCodeAnalyzerListener;
import com.jetbrains.performancePlugin.utils.DaemonCodeAnalyzerResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DelayTypeCommand
extends KeyCodeTypeCommand {
    public static final String PREFIX = "%delayType";
    public static final char END_CHAR = '#';
    public static final String SPAN_NAME = "typing";
    public static final String CODE_ANALYSIS_SPAN_NAME = "typingCodeAnalyzing";
    private final ScheduledExecutorService myExecutor;

    public DelayTypeCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            DelayTypeCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
        this.myExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Performance plugin delayed type");
    }

    @NotNull
    public Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            DelayTypeCommand.$$$reportNull$$$0(1);
        }
        AsyncPromise result = new AsyncPromise();
        String input = this.extractCommandArgument(PREFIX);
        String[] delayText = input.split("\\|");
        long delay = Integer.parseInt(delayText[0]);
        String text2 = delayText[1] + "#";
        boolean calculateAnalyzesTime = delayText.length > 2 && Boolean.parseBoolean(delayText[2]);
        Ref spanRef = new Ref();
        SimpleMessageBusConnection projectConnection = context.getProject().getMessageBus().simpleConnect();
        MessageBusConnection applicationConnection = ApplicationManager.getApplication().getMessageBus().connect();
        final LatencyRecord latencyRecorder = new LatencyRecord();
        applicationConnection.subscribe(LatencyListener.TOPIC, (Object)new LatencyListener(){

            public void recordTypingLatency(@NotNull Editor editor, String action, long latencyMs) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                latencyRecorder.update((int)latencyMs);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/performancePlugin/commands/DelayTypeCommand$1", "recordTypingLatency"));
            }
        });
        Ref job = new Ref();
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> {
            TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)SPAN_NAME, span -> {
                span.addEvent("Finding typing target");
                try {
                    Waiter.checkCondition(() -> DelayTypeCommand.findTarget((PlaybackContext)context) != null).await(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    span.recordException((Throwable)e);
                    result.setError((Throwable)e);
                    return;
                }
                CountDownLatch allScheduled = new CountDownLatch(1);
                for (int i = 0; i < text2.length(); ++i) {
                    char currentChar = text2.charAt(i);
                    boolean nextCharIsTheLast = i + 1 < text2.length() && text2.charAt(i + 1) == '#';
                    this.myExecutor.schedule(() -> ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                        if (nextCharIsTheLast && calculateAnalyzesTime) {
                            job.set((Object)DaemonCodeAnalyzerListener.INSTANCE.listen(projectConnection, (Ref<Span>)spanRef, 0L, null));
                            SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(CODE_ANALYSIS_SPAN_NAME).setParent(Context.current().with((ImplicitContextKeyed)span));
                            spanRef.set((Object)spanBuilder.startSpan());
                        }
                        if (currentChar == '#') {
                            allScheduled.countDown();
                            this.myExecutor.shutdown();
                        } else {
                            span.addEvent("Calling find target second time in DelayTypeCommand");
                            TypingTarget typingTarget = DelayTypeCommand.findTarget((PlaybackContext)context);
                            if (typingTarget != null) {
                                span.addEvent("Typing " + currentChar);
                                typingTarget.type(String.valueOf(currentChar));
                            }
                        }
                    })), (long)i * delay, TimeUnit.MILLISECONDS);
                }
                try {
                    allScheduled.await();
                    this.myExecutor.awaitTermination(1L, TimeUnit.MINUTES);
                    if (!latencyRecorder.getSamples().isEmpty()) {
                        span.setAttribute("latency#max", (long)latencyRecorder.getMaxLatency());
                        span.setAttribute("latency#p90", (long)latencyRecorder.percentile(90));
                        span.setAttribute("latency#mean_value", latencyRecorder.getAverageLatency());
                    }
                }
                catch (InterruptedException e) {
                    result.setError((Throwable)e);
                }
            });
            if (calculateAnalyzesTime) {
                ((DaemonCodeAnalyzerResult)job.get()).blockingWaitForComplete();
            }
            applicationConnection.disconnect();
            result.setResult(null);
        }));
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            DelayTypeCommand.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/DelayTypeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/DelayTypeCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

