/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationContainer;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public class DefaultProjectLocalComponentProvider
implements LocalComponentProvider {
    private final LocalConfigurationMetadataBuilder metadataBuilder;
    private final LocalComponentGraphResolveStateFactory resolveStateFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public DefaultProjectLocalComponentProvider(LocalConfigurationMetadataBuilder metadataBuilder, LocalComponentGraphResolveStateFactory resolveStateFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.metadataBuilder = metadataBuilder;
        this.resolveStateFactory = resolveStateFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    @Nullable
    public LocalComponentGraphResolveState getComponent(ProjectState projectState) {
        projectState.ensureConfigured();
        LocalComponentMetadata metadata = projectState.fromMutableState(p -> this.getLocalComponentMetadata(projectState, (ProjectInternal)p));
        return this.resolveStateFactory.stateFor(metadata);
    }

    private LocalComponentMetadata getLocalComponentMetadata(ProjectState projectState, ProjectInternal project) {
        Module module = project.getDependencyMetaDataProvider().getModule();
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectComponentIdentifier componentIdentifier = projectState.getComponentIdentifier();
        AttributesSchemaInternal schema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
        DefaultLocalComponentMetadata.ConfigurationsProviderMetadataFactory configurationMetadataFactory = new DefaultLocalComponentMetadata.ConfigurationsProviderMetadataFactory((DefaultConfigurationContainer)project.getConfigurations(), this.metadataBuilder, projectState, this.calculatedValueContainerFactory);
        project.getConfigurations().forEach(conf -> ((ConfigurationInternal)conf).preventFromFurtherMutation());
        return new DefaultLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus(), schema, configurationMetadataFactory, null);
    }
}

