/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.type;

import java.io.File;
import java.util.HashSet;
import java.util.function.Consumer;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.artifacts.type.DefaultArtifactTypeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.reflect.Instantiator;

public class DefaultArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final Instantiator instantiator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CollectionCallbackActionDecorator callbackActionDecorator;
    private final VariantTransformRegistry transformRegistry;
    private ArtifactTypeContainer artifactTypeDefinitions;

    public DefaultArtifactTypeRegistry(Instantiator instantiator2, ImmutableAttributesFactory attributesFactory, CollectionCallbackActionDecorator callbackActionDecorator, VariantTransformRegistry transformRegistry) {
        this.instantiator = instantiator2;
        this.attributesFactory = attributesFactory;
        this.callbackActionDecorator = callbackActionDecorator;
        this.transformRegistry = transformRegistry;
    }

    @Override
    public void visitArtifactTypes(Consumer<? super ImmutableAttributes> action) {
        HashSet<String> seen = new HashSet<String>();
        if (this.artifactTypeDefinitions != null) {
            for (ArtifactTypeDefinition artifactTypeDefinition : this.artifactTypeDefinitions) {
                if (!seen.add(artifactTypeDefinition.getName())) continue;
                ImmutableAttributes attributes = ((AttributeContainerInternal)artifactTypeDefinition.getAttributes()).asImmutable();
                attributes = this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, artifactTypeDefinition.getName()), attributes);
                action.accept(attributes);
            }
        }
        for (TransformRegistration registration : this.transformRegistry.getRegistrations()) {
            ImmutableAttributes sourceAttributes = registration.getFrom();
            String format = sourceAttributes.getAttribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
            if (format == null || !seen.add(format)) continue;
            ImmutableAttributes attributes = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, format);
            action.accept(attributes);
        }
        if (seen.add("directory")) {
            ImmutableAttributes directory = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, "directory");
            action.accept(directory);
        }
    }

    @Override
    public ArtifactTypeContainer create() {
        if (this.artifactTypeDefinitions == null) {
            this.artifactTypeDefinitions = this.instantiator.newInstance(DefaultArtifactTypeContainer.class, this.instantiator, this.attributesFactory, this.callbackActionDecorator);
        }
        return this.artifactTypeDefinitions;
    }

    @Override
    public ImmutableAttributes mapAttributesFor(File file) {
        if (file.isDirectory()) {
            return this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, "directory");
        }
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        String extension = Files.getFileExtension((String)file.getName());
        if (this.artifactTypeDefinitions != null) {
            attributes = this.applyForExtension(attributes, extension);
        }
        return this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, extension), attributes);
    }

    @Override
    public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts2) {
        if (this.artifactTypeDefinitions != null) {
            String extension = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts2) {
                String candidateExtension = componentArtifactMetadata.getName().getExtension();
                if (extension == null) {
                    extension = candidateExtension;
                    continue;
                }
                if (extension.equals(candidateExtension)) continue;
                extension = null;
                break;
            }
            if (extension != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
        }
        if (!attributes.contains(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE)) {
            String format = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts2) {
                String candidateFormat = componentArtifactMetadata.getName().getType();
                if (format == null) {
                    format = candidateFormat;
                    continue;
                }
                if (format.equals(candidateFormat)) continue;
                format = null;
                break;
            }
            if (format != null) {
                attributes = this.attributesFactory.concat(attributes.asImmutable(), ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, format);
            }
        }
        return attributes;
    }

    private ImmutableAttributes applyForExtension(ImmutableAttributes attributes, String extension) {
        ArtifactTypeDefinition definition = (ArtifactTypeDefinition)this.artifactTypeDefinitions.findByName(extension);
        if (definition != null) {
            attributes = this.attributesFactory.concat(((AttributeContainerInternal)definition.getAttributes()).asImmutable(), attributes);
        }
        return attributes;
    }
}

