/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.InputStream;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.file.Stat;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.util.internal.GFileUtils;

public class DefaultFileTreeElement
extends AbstractFileTreeElement {
    private final File file;
    private final RelativePath relativePath;
    private final Stat stat;

    public DefaultFileTreeElement(File file, RelativePath relativePath, Chmod chmod, Stat stat) {
        super(chmod);
        this.file = file;
        this.relativePath = relativePath;
        this.stat = stat;
    }

    public static DefaultFileTreeElement of(File file, FileSystem fileSystem) {
        RelativePath path = RelativePath.parse(!file.isDirectory(), file.getAbsolutePath());
        return new DefaultFileTreeElement(file, path, fileSystem, fileSystem);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getDisplayName() {
        return "file '" + this.file + "'";
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return !this.relativePath.isFile();
    }

    @Override
    public InputStream open() {
        return GFileUtils.openInputStream(this.file);
    }

    @Override
    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    @Override
    public FilePermissions getPermissions() {
        int unixNumeric = this.stat.getUnixMode(this.file);
        return new DefaultFilePermissions(unixNumeric);
    }
}

