/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.options.BooleanOptionElement;
import org.gradle.api.internal.tasks.options.BuiltInOptionElement;
import org.gradle.api.internal.tasks.options.InstanceOptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.api.specs.Specs;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskOptionsGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskOptionsGenerator.class);
    @VisibleForTesting
    static final List<BuiltInOptionElement> BUILT_IN_OPTIONS = Collections.singletonList(new BuiltInOptionElement("Causes the task to be re-run even if up-to-date.", "rerun", task -> task.getOutputs().upToDateWhen(Specs.satisfyNone())));

    private static List<OptionDescriptor> generateBuiltInOptions(Object target, Collection<String> reserved) {
        ArrayList<OptionDescriptor> validBuiltInOptions = new ArrayList<OptionDescriptor>();
        for (BuiltInOptionElement builtInOption : BUILT_IN_OPTIONS) {
            InstanceOptionDescriptor optionDescriptor = new InstanceOptionDescriptor(target, builtInOption, null, reserved.contains(builtInOption.getOptionName()));
            if (optionDescriptor.isClashing()) {
                LOGGER.warn("Built-in option '{}' in task {} was disabled for clashing with another option of same name", (Object)optionDescriptor.getName(), target);
                continue;
            }
            validBuiltInOptions.add(optionDescriptor);
        }
        return validBuiltInOptions;
    }

    private static Map<String, OptionDescriptor> generateOppositeOptions(Object target, Map<String, OptionDescriptor> options, TaskOptions taskOptions) {
        HashMap<String, OptionDescriptor> oppositeOptions = new HashMap<String, OptionDescriptor>();
        LinkedList<Pair<OptionDescriptor, InstanceOptionDescriptor>> mutuallyExclusiveOptions = new LinkedList<Pair<OptionDescriptor, InstanceOptionDescriptor>>();
        for (OptionDescriptor option : options.values()) {
            OptionElement optionElement;
            if (!(option instanceof InstanceOptionDescriptor) || !((optionElement = ((InstanceOptionDescriptor)option).getOptionElement()) instanceof BooleanOptionElement)) continue;
            BooleanOptionElement oppositeOptionElement = BooleanOptionElement.oppositeOf((BooleanOptionElement)optionElement);
            String oppositeOptionName = oppositeOptionElement.getOptionName();
            if (options.containsKey(oppositeOptionName)) {
                LOGGER.warn("Opposite option '{}' in task {} was disabled for clashing with another option of same name", (Object)oppositeOptionName, target);
                continue;
            }
            InstanceOptionDescriptor oppositeOption = new InstanceOptionDescriptor(target, oppositeOptionElement, null);
            oppositeOptions.put(oppositeOptionName, oppositeOption);
            mutuallyExclusiveOptions.add(Pair.of(option, oppositeOption));
        }
        taskOptions.mutuallyExclusiveOptions = Collections.unmodifiableList(mutuallyExclusiveOptions);
        return oppositeOptions;
    }

    public static TaskOptions generate(Object task, OptionReader optionReader) {
        TaskOptions taskOptions = new TaskOptions();
        Map<String, OptionDescriptor> options = optionReader.getOptions(task);
        options.putAll(TaskOptionsGenerator.generateOppositeOptions(task, options, taskOptions));
        List<OptionDescriptor> sortedOptions = CollectionUtils.sort(options.values(), BooleanOptionElement.groupOppositeOptions());
        sortedOptions.addAll(TaskOptionsGenerator.generateBuiltInOptions(task, options.keySet()));
        taskOptions.allTaskOptions = Collections.unmodifiableList(sortedOptions);
        return taskOptions;
    }

    public static class TaskOptions {
        private List<OptionDescriptor> allTaskOptions;
        private List<Pair<OptionDescriptor, OptionDescriptor>> mutuallyExclusiveOptions;

        private TaskOptions() {
        }

        public List<OptionDescriptor> getAll() {
            return this.allTaskOptions;
        }

        public void addMutualExclusions(CommandLineParser parser) {
            this.mutuallyExclusiveOptions.forEach(pair -> parser.allowOneOf(((OptionDescriptor)pair.getLeft()).getName(), ((OptionDescriptor)pair.getRight()).getName()));
        }
    }
}

