/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.internal.tasks.options.PropertySetter;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.exceptions.ValueCollectingDiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeConversionException;

public class SingleValueOptionElement
extends AbstractOptionElement {
    private final PropertySetter setter;
    private final NotationParser<CharSequence, ?> notationParser;

    public SingleValueOptionElement(String optionName, Option option, Class<?> optionType, PropertySetter setter, OptionValueNotationParserFactory notationParserFactory) {
        super(optionName, option, String.class, setter.getDeclaringClass());
        this.setter = setter;
        this.notationParser = SingleValueOptionElement.createNotationParserOrFail(notationParserFactory, optionName, optionType, setter.getDeclaringClass());
    }

    @Override
    public Set<String> getAvailableValues() {
        ValueCollectingDiagnosticsVisitor visitor = new ValueCollectingDiagnosticsVisitor();
        this.notationParser.describe(visitor);
        return visitor.getValues();
    }

    @Override
    public void apply(Object object, List<String> parameterValues) throws TypeConversionException {
        Object arg = this.notationParser.parseNotation(parameterValues.get(0));
        this.setter.setValue(object, arg);
    }
}

