/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.specs.Spec;

public class ClassMethodNameStackTraceSpec
implements Spec<StackTraceElement> {
    private static final Pattern ANONYMOUS_CLASS_NAME_SUFFIX = Pattern.compile("\\$[\\d$]+");
    private final String className;
    private final String methodName;

    ClassMethodNameStackTraceSpec(String className, @Nullable String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    public boolean isSatisfiedBy(StackTraceElement element) {
        return this.classNameMatch(element.getClassName()) && this.methodNameMatch(element.getMethodName());
    }

    private boolean methodNameMatch(String methodName) {
        return this.methodName == null || this.methodName.equals(methodName);
    }

    private boolean classNameMatch(String targetClassName) {
        if (this.className == null || !targetClassName.startsWith(this.className)) {
            return false;
        }
        String suffix = targetClassName.substring(this.className.length());
        return suffix.isEmpty() || ANONYMOUS_CLASS_NAME_SUFFIX.matcher(suffix).matches();
    }
}

