/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.antlr.AntlrSourceDirectorySet;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.DefaultAntlrSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;

public abstract class AntlrPlugin
implements Plugin<Project> {
    public static final String ANTLR_CONFIGURATION_NAME = "antlr";
    private final ObjectFactory objectFactory;

    @Inject
    public AntlrPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(final Project project) {
        project.getPluginManager().apply(JavaLibraryPlugin.class);
        Configuration antlrConfiguration = ((ProjectInternal)project).getConfigurations().resolvableDependencyScopeUnlocked(ANTLR_CONFIGURATION_NAME).setVisible(false);
        antlrConfiguration.defaultDependencies(dependencies -> dependencies.add(project.getDependencies().create("antlr:antlr:2.7.7@jar")));
        Configuration apiConfiguration = project.getConfigurations().getByName("api");
        apiConfiguration.extendsFrom(antlrConfiguration);
        project.getTasks().withType(AntlrTask.class).configureEach(antlrTask -> antlrTask.getConventionMapping().map("antlrClasspath", () -> project.getConfigurations().getByName(ANTLR_CONFIGURATION_NAME)));
        project.getExtensions().getByType(JavaPluginExtension.class).getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(final SourceSet sourceSet) {
                final AntlrSourceDirectorySet antlrSourceSet = AntlrPlugin.createAntlrSourceDirectorySet(((DefaultSourceSet)sourceSet).getDisplayName(), AntlrPlugin.this.objectFactory);
                sourceSet.getExtensions().add(AntlrSourceDirectorySet.class, AntlrPlugin.ANTLR_CONFIGURATION_NAME, antlrSourceSet);
                String srcDir = "src/" + sourceSet.getName() + "/antlr";
                antlrSourceSet.srcDir(srcDir);
                sourceSet.getAllSource().source(antlrSourceSet);
                final String taskName = sourceSet.getTaskName("generate", "GrammarSource");
                String outputDirectoryName = project.getBuildDir() + "/generated-src/antlr/" + sourceSet.getName();
                final File outputDirectory = new File(outputDirectoryName);
                sourceSet.getJava().srcDir(outputDirectory);
                project.getTasks().register(taskName, AntlrTask.class, new Action<AntlrTask>(){

                    @Override
                    public void execute(AntlrTask antlrTask) {
                        antlrTask.setDescription("Processes the " + sourceSet.getName() + " Antlr grammars.");
                        antlrTask.setSource(antlrSourceSet);
                        antlrTask.setOutputDirectory(outputDirectory);
                    }
                });
                project.getTasks().named(sourceSet.getCompileJavaTaskName(), new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        task.dependsOn(taskName);
                    }
                });
            }
        });
    }

    private static AntlrSourceDirectorySet createAntlrSourceDirectorySet(String parentDisplayName, ObjectFactory objectFactory) {
        String name = parentDisplayName + ".antlr";
        String displayName = parentDisplayName + " Antlr source";
        AntlrSourceDirectorySet antlrSourceSet = objectFactory.newInstance(DefaultAntlrSourceDirectorySet.class, objectFactory.sourceDirectorySet(name, displayName));
        antlrSourceSet.getFilter().include("**/*.g");
        antlrSourceSet.getFilter().include("**/*.g4");
        return antlrSourceSet;
    }
}

