/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.authentication.Authentication;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class PublishToMavenRepository
extends AbstractPublishToMaven {
    private final Transient.Var<DefaultMavenArtifactRepository> repository = Transient.varOf();
    private final Cached<PublishSpec> spec = Cached.of(this::computeSpec);
    private final Property<Credentials> credentials = this.getProject().getObjects().property(Credentials.class);

    @Internal
    public MavenArtifactRepository getRepository() {
        return (MavenArtifactRepository)this.repository.get();
    }

    @Nested
    @Optional
    Property<Credentials> getCredentials() {
        return this.credentials;
    }

    @Inject
    protected ListenerManager getListenerManager() {
        throw new UnsupportedOperationException();
    }

    public void setRepository(MavenArtifactRepository repository) {
        this.repository.set((DefaultMavenArtifactRepository)repository);
        this.credentials.set(((DefaultMavenArtifactRepository)repository).getConfiguredCredentials());
    }

    @TaskAction
    public void publish() {
        PublishSpec spec = this.spec.get();
        MavenNormalizedPublication publication = spec.publication;
        MavenArtifactRepository repository = spec.repository.get(this.getServices());
        this.getDuplicatePublicationTracker().checkCanPublish(publication, repository.getUrl(), repository.getName());
        this.doPublish(publication, repository);
    }

    private PublishSpec computeSpec() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        DefaultMavenArtifactRepository repository = (DefaultMavenArtifactRepository)this.repository.get();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        MavenNormalizedPublication normalizedPublication = publicationInternal.asNormalisedPublication();
        return new PublishSpec(RepositorySpec.of(repository), normalizedPublication);
    }

    private void doPublish(final MavenNormalizedPublication normalizedPublication, final MavenArtifactRepository repository) {
        new PublishOperation(normalizedPublication.getName(), repository.getName()){

            @Override
            protected void publish() {
                PublishToMavenRepository.this.validatingMavenPublisher().publish(normalizedPublication, repository);
            }
        }.run();
    }

    private MavenPublisher validatingMavenPublisher() {
        return new ValidatingMavenPublisher(this.getMavenPublishers().getRemotePublisher(this.getTemporaryDirFactory()));
    }

    static abstract class RepositorySpec {
        RepositorySpec() {
        }

        static RepositorySpec of(DefaultMavenArtifactRepository repository) {
            return new Configured(repository);
        }

        abstract MavenArtifactRepository get(ServiceRegistry var1);

        static class CredentialsSpec {
            private final String identity;
            private final Class<? extends Credentials> type;

            private CredentialsSpec(String identity, Class<? extends Credentials> type) {
                this.identity = identity;
                this.type = type;
            }

            public static CredentialsSpec of(String identity, Credentials credentials) {
                return new CredentialsSpec(identity, GeneratedSubclasses.unpackType(credentials));
            }

            public Class<? extends Credentials> getType() {
                return this.type;
            }

            public String getIdentity() {
                return this.identity;
            }
        }

        static class DefaultRepositorySpec
        extends RepositorySpec {
            private final URI repositoryUrl;
            private final CredentialsSpec credentials;
            private final boolean allowInsecureProtocol;
            private final String name;
            private final Collection<Authentication> authentications;

            public DefaultRepositorySpec(String name, URI repositoryUrl, boolean allowInsecureProtocol, CredentialsSpec credentials, Collection<Authentication> authentications) {
                this.name = name;
                this.repositoryUrl = repositoryUrl;
                this.allowInsecureProtocol = allowInsecureProtocol;
                this.credentials = credentials;
                this.authentications = authentications;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                DefaultMavenArtifactRepository repository = (DefaultMavenArtifactRepository)services.get(BaseRepositoryFactory.class).createMavenRepository();
                repository.setName(this.name);
                repository.setUrl(this.repositoryUrl);
                repository.setAllowInsecureProtocol(this.allowInsecureProtocol);
                if (this.credentials != null) {
                    Provider<? extends Credentials> provider = services.get(ProviderFactory.class).credentials(this.credentials.getType(), this.name);
                    repository.setConfiguredCredentials(provider.get());
                }
                repository.authentication(container -> container.addAll(this.authentications));
                return repository;
            }
        }

        static class Configured
        extends RepositorySpec
        implements Serializable {
            final DefaultMavenArtifactRepository repository;

            public Configured(DefaultMavenArtifactRepository repository) {
                this.repository = repository;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                return this.repository;
            }

            private Object writeReplace() {
                CredentialsSpec credentialsSpec = this.repository.getConfiguredCredentials().map(it -> CredentialsSpec.of(this.repository.getName(), it)).getOrNull();
                return new DefaultRepositorySpec(this.repository.getName(), this.repository.getUrl(), this.repository.isAllowInsecureProtocol(), credentialsSpec, this.repository.getConfiguredAuthentication());
            }
        }
    }

    static class PublishSpec {
        private final RepositorySpec repository;
        private final MavenNormalizedPublication publication;

        public PublishSpec(RepositorySpec repository, MavenNormalizedPublication publication) {
            this.repository = repository;
            this.publication = publication;
        }
    }
}

