/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.api.tasks.wrapper.GradleVersionResolver;
import org.gradle.api.tasks.wrapper.WrapperVersionsResources;
import org.gradle.api.tasks.wrapper.internal.DefaultWrapperVersionsResources;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.DistributionLocator;
import org.gradle.util.internal.GUtil;
import org.gradle.util.internal.WrapUtil;
import org.gradle.util.internal.WrapperDistributionUrlConverter;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.GradleWrapperMain;
import org.gradle.wrapper.Logger;

@DisableCachingByDefault(because="Updating the wrapper is not worth caching")
public abstract class Wrapper
extends DefaultTask {
    public static final String DEFAULT_DISTRIBUTION_PARENT_NAME = "wrapper/dists";
    private Object scriptFile = "gradlew";
    private Object jarFile = "gradle/wrapper/gradle-wrapper.jar";
    private String distributionPath = "wrapper/dists";
    private PathBase distributionBase = PathBase.GRADLE_USER_HOME;
    private String distributionUrl;
    private String distributionSha256Sum;
    private final GradleVersionResolver gradleVersionResolver = new GradleVersionResolver();
    private DistributionType distributionType = DistributionType.BIN;
    private String archivePath = "wrapper/dists";
    private PathBase archiveBase = PathBase.GRADLE_USER_HOME;
    private final Property<Integer> networkTimeout = this.getProject().getObjects().property(Integer.class);
    private final DistributionLocator locator = new DistributionLocator();
    private final boolean isOffline = this.getProject().getGradle().getStartParameter().isOffline();
    private boolean distributionUrlConfigured = false;
    private static final String DISTRIBUTION_URL_EXCEPTION_MESSAGE = "Test of distribution url %s failed. Please check the values set with --gradle-distribution-url and --gradle-version.";

    public Wrapper() {
        this.getValidateDistributionUrl().convention(true);
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void generate() {
        File jarFileDestination = this.getJarFile();
        File unixScript = this.getScriptFile();
        File propertiesFile = this.getPropertiesFile();
        FileResolver resolver = this.getFileLookup().getFileResolver(unixScript.getParentFile());
        String jarFileRelativePath = resolver.resolveAsRelativePath(jarFileDestination);
        Properties existingProperties = propertiesFile.exists() ? GUtil.loadProperties(propertiesFile) : null;
        this.checkProperties(existingProperties);
        this.validateDistributionUrl(propertiesFile.getParentFile());
        this.writeProperties(propertiesFile, existingProperties);
        this.writeWrapperTo(jarFileDestination);
        StartScriptGenerator generator = new StartScriptGenerator();
        generator.setApplicationName("Gradle");
        generator.setMainClassName(GradleWrapperMain.class.getName());
        generator.setClasspath(WrapUtil.toList(jarFileRelativePath));
        generator.setOptsEnvironmentVar("GRADLE_OPTS");
        generator.setExitEnvironmentVar("GRADLE_EXIT_CONSOLE");
        generator.setAppNameSystemProperty("org.gradle.appname");
        generator.setScriptRelPath(unixScript.getName());
        generator.setDefaultJvmOpts((Iterable<String>)ImmutableList.of((Object)"-Xmx64m", (Object)"-Xms64m"));
        generator.generateUnixScript(unixScript);
        generator.generateWindowsScript(this.getBatchScript());
    }

    private void checkProperties(Properties existingProperties) {
        String checksumProperty;
        String string2 = checksumProperty = existingProperties != null ? existingProperties.getProperty("distributionSha256Sum", null) : null;
        if (!this.isCurrentVersion() && this.distributionSha256Sum == null && checksumProperty != null) {
            throw new GradleException("gradle-wrapper.properties contains distributionSha256Sum property, but the wrapper configuration does not have one. Specify one in the wrapped task configuration or with the --gradle-distribution-sha256-sum task option");
        }
    }

    private void validateDistributionUrl(File uriRoot) {
        if (this.distributionUrlConfigured && ((Boolean)this.getValidateDistributionUrl().get()).booleanValue()) {
            String url = this.getDistributionUrl();
            URI uri = Wrapper.getDistributionUri(uriRoot, url);
            if (uri.getScheme().equals("file")) {
                if (!Files.exists(Paths.get(uri).toAbsolutePath(), new LinkOption[0])) {
                    throw new UncheckedIOException(String.format(DISTRIBUTION_URL_EXCEPTION_MESSAGE, url));
                }
            } else if (uri.getScheme().startsWith("http") && !this.isOffline) {
                try {
                    new Download(new Logger(true), "gradlew", "0").sendHeadRequest(uri);
                }
                catch (Exception e) {
                    throw new UncheckedIOException(String.format(DISTRIBUTION_URL_EXCEPTION_MESSAGE, url), e);
                }
            }
        }
    }

    private static URI getDistributionUri(File uriRoot, String url) {
        try {
            return WrapperDistributionUrlConverter.convertDistributionUrl(url, uriRoot);
        }
        catch (URISyntaxException e) {
            throw new GradleException("Distribution URL String cannot be parsed: " + url, e);
        }
    }

    private void writeWrapperTo(File destination) {
        URL jarFileSource = Wrapper.class.getResource("/gradle-wrapper.jar");
        if (jarFileSource == null) {
            throw new GradleException("Cannot locate wrapper JAR resource.");
        }
        try (InputStream in = jarFileSource.openStream();
             FileOutputStream out = new FileOutputStream(destination);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write wrapper JAR to " + destination, e);
        }
    }

    private void writeProperties(File propertiesFileDestination, Properties existingProperties) {
        Properties wrapperProperties = new Properties();
        wrapperProperties.put("distributionUrl", this.getDistributionUrl());
        String distributionSha256Sum = this.getDistributionSha256Sum(existingProperties);
        if (distributionSha256Sum != null) {
            wrapperProperties.put("distributionSha256Sum", distributionSha256Sum);
        }
        wrapperProperties.put("distributionBase", this.distributionBase.toString());
        wrapperProperties.put("distributionPath", this.distributionPath);
        wrapperProperties.put("zipStoreBase", this.archiveBase.toString());
        wrapperProperties.put("zipStorePath", this.archivePath);
        if (this.networkTimeout.isPresent()) {
            wrapperProperties.put("networkTimeout", String.valueOf(this.networkTimeout.get()));
        }
        wrapperProperties.put("validateDistributionUrl", String.valueOf(this.getValidateDistributionUrl().get()));
        try {
            PropertiesUtils.store(wrapperProperties, propertiesFileDestination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getDistributionSha256Sum(Properties existingProperties) {
        if (this.distributionSha256Sum != null) {
            return this.distributionSha256Sum;
        }
        if (this.isCurrentVersion() && existingProperties != null) {
            return existingProperties.getProperty("distributionSha256Sum", null);
        }
        return null;
    }

    private boolean isCurrentVersion() {
        return GradleVersion.current().equals(this.gradleVersionResolver.getGradleVersion());
    }

    @OutputFile
    public File getScriptFile() {
        return this.getServices().get(FileOperations.class).file(this.scriptFile);
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setScriptFile(Object scriptFile) {
        this.scriptFile = scriptFile;
    }

    @OutputFile
    public File getBatchScript() {
        File scriptFile = this.getScriptFile();
        return new File(scriptFile.getParentFile(), scriptFile.getName().replaceFirst("(\\.[^\\.]+)?$", ".bat"));
    }

    @OutputFile
    public File getJarFile() {
        return this.getServices().get(FileOperations.class).file(this.jarFile);
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setJarFile(Object jarFile) {
        this.jarFile = jarFile;
    }

    @OutputFile
    public File getPropertiesFile() {
        File jarFileDestination = this.getJarFile();
        return new File(jarFileDestination.getParentFile(), jarFileDestination.getName().replaceAll("\\.jar$", ".properties"));
    }

    @Input
    public String getDistributionPath() {
        return this.distributionPath;
    }

    public void setDistributionPath(String distributionPath) {
        this.distributionPath = distributionPath;
    }

    @Incubating
    public void setWrapperVersionsResources(WrapperVersionsResources wrapperVersionsResources) {
        DefaultWrapperVersionsResources defaultWrapperVersionsResources = (DefaultWrapperVersionsResources)wrapperVersionsResources;
        this.gradleVersionResolver.setTextResources(defaultWrapperVersionsResources.getLatest(), defaultWrapperVersionsResources.getReleaseCandidate(), defaultWrapperVersionsResources.getNightly(), defaultWrapperVersionsResources.getReleaseNightly());
    }

    @Input
    public String getGradleVersion() {
        return this.gradleVersionResolver.getGradleVersion().getVersion();
    }

    @Option(option="gradle-version", description="The version of the Gradle distribution required by the wrapper. The following labels are allowed: latest, release-candidate, nightly, and release-nightly.")
    public void setGradleVersion(String gradleVersion) {
        this.distributionUrlConfigured = true;
        this.gradleVersionResolver.setGradleVersionString(gradleVersion);
    }

    @Input
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @Option(option="distribution-type", description="The type of the Gradle distribution to be used by the wrapper.")
    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    @OptionValues(value={"distribution-type"})
    public List<DistributionType> getAvailableDistributionTypes() {
        return Arrays.asList(DistributionType.values());
    }

    @Input
    public String getDistributionUrl() {
        if (this.distributionUrl != null) {
            return this.distributionUrl;
        }
        if (this.gradleVersionResolver.getGradleVersion() != null) {
            return this.locator.getDistributionFor(this.gradleVersionResolver.getGradleVersion(), this.distributionType.name().toLowerCase(Locale.ENGLISH)).toASCIIString();
        }
        return null;
    }

    @Option(option="gradle-distribution-url", description="The URL to download the Gradle distribution from.")
    public void setDistributionUrl(String url) {
        this.distributionUrlConfigured = true;
        this.distributionUrl = url;
    }

    @Nullable
    @Optional
    @Input
    public String getDistributionSha256Sum() {
        return this.distributionSha256Sum;
    }

    @Option(option="gradle-distribution-sha256-sum", description="The SHA-256 hash sum of the gradle distribution.")
    public void setDistributionSha256Sum(@Nullable String distributionSha256Sum) {
        this.distributionSha256Sum = distributionSha256Sum;
    }

    @Input
    public PathBase getDistributionBase() {
        return this.distributionBase;
    }

    public void setDistributionBase(PathBase distributionBase) {
        this.distributionBase = distributionBase;
    }

    @Input
    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    @Input
    public PathBase getArchiveBase() {
        return this.archiveBase;
    }

    public void setArchiveBase(PathBase archiveBase) {
        this.archiveBase = archiveBase;
    }

    @Input
    @Incubating
    @Optional
    @Option(option="network-timeout", description="Timeout in ms to use when the wrapper is performing network operations.")
    public Property<Integer> getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Incubating
    @Input
    @Option(option="validate-url", description="Sets task to validate the configured distribution url.")
    public abstract Property<Boolean> getValidateDistributionUrl();

    public static enum PathBase {
        PROJECT,
        GRADLE_USER_HOME;

    }

    public static enum DistributionType {
        BIN,
        ALL;

    }
}

