/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.external.javadoc.internal;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.gradle.internal.SystemProperties;

public class JavadocOptionFileWriterContext {
    private final Writer writer;

    public JavadocOptionFileWriterContext(Writer writer2) {
        this.writer = writer2;
    }

    public JavadocOptionFileWriterContext write(String string2) throws IOException {
        this.writer.write(string2);
        return this;
    }

    public JavadocOptionFileWriterContext newLine() throws IOException {
        this.writer.write(SystemProperties.getInstance().getLineSeparator());
        return this;
    }

    public JavadocOptionFileWriterContext writeOptionHeader(String option) throws IOException {
        this.write("-");
        this.write(option);
        this.write(" ");
        return this;
    }

    public JavadocOptionFileWriterContext writeOption(String option) throws IOException {
        this.writeOptionHeader(option);
        this.newLine();
        return this;
    }

    public JavadocOptionFileWriterContext writeValueOption(String option, String value) throws IOException {
        this.writeOptionHeader(option);
        this.writeValue(value);
        this.newLine();
        return this;
    }

    public JavadocOptionFileWriterContext writeValue(String value) throws IOException {
        this.write("'");
        this.write(value.replaceAll("\\\\", "\\\\\\\\").replaceAll(SystemProperties.getInstance().getLineSeparator(), "\\\\" + SystemProperties.getInstance().getLineSeparator()).replace("'", "\\'"));
        this.write("'");
        return this;
    }

    public JavadocOptionFileWriterContext writeValuesOption(String option, Collection<String> values, String joinValuesBy) throws IOException {
        StringBuilder builder = new StringBuilder();
        Iterator<String> valuesIt = values.iterator();
        while (valuesIt.hasNext()) {
            builder.append(valuesIt.next());
            if (!valuesIt.hasNext()) continue;
            builder.append(joinValuesBy);
        }
        this.writeValueOption(option, builder.toString());
        return this;
    }

    public JavadocOptionFileWriterContext writeMultilineValuesOption(String option, Collection<String> values) throws IOException {
        for (String value : values) {
            this.writeValueOption(option, value);
        }
        return this;
    }

    public JavadocOptionFileWriterContext writePathOption(String option, Collection<File> files, String joinValuesBy) throws IOException {
        StringBuilder builder = new StringBuilder();
        Iterator<File> filesIt = files.iterator();
        while (filesIt.hasNext()) {
            builder.append(filesIt.next().getAbsolutePath());
            if (!filesIt.hasNext()) continue;
            builder.append(joinValuesBy);
        }
        this.writeValueOption(option, builder.toString());
        return this;
    }
}

