/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks.internal;

import groovy.util.Node;
import groovy.util.NodeList;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class XcodeSchemeFile
extends XmlPersistableConfigurationObject {
    private static final String YES = "YES";
    private static final String NO = "NO";

    public XcodeSchemeFile(XmlTransformer xmlTransformer) {
        super(xmlTransformer);
    }

    public BuildAction getBuildAction() {
        return new BuildAction(XcodeSchemeFile.getOrAppendNode(this.getXml(), "BuildAction"));
    }

    public TestAction getTestAction() {
        return new TestAction(XcodeSchemeFile.getOrAppendNode(this.getXml(), "TestAction"));
    }

    public LaunchAction getLaunchAction() {
        return new LaunchAction(XcodeSchemeFile.getOrAppendNode(this.getXml(), "LaunchAction"));
    }

    public ProfileAction getProfileAction() {
        return new ProfileAction(XcodeSchemeFile.getOrAppendNode(this.getXml(), "ProfileAction"));
    }

    public ArchiveAction getArchiveAction() {
        return new ArchiveAction(XcodeSchemeFile.getOrAppendNode(this.getXml(), "ArchiveAction"));
    }

    public AnalyzeAction getAnalyzeAction() {
        return new AnalyzeAction(XcodeSchemeFile.getOrAppendNode(this.getXml(), "AnalyzeAction"));
    }

    private static Node getOrAppendNode(Node xml, String name) {
        NodeList nodes = (NodeList)xml.get(name);
        if (nodes.isEmpty()) {
            return xml.appendNode((Object)name);
        }
        return (Node)nodes.get(0);
    }

    @Override
    protected String getDefaultResourceName() {
        return "default.xcscheme";
    }

    private static String toYesNo(boolean value) {
        if (value) {
            return YES;
        }
        return NO;
    }

    public static class BuildableReference {
        private String containerRelativePath;
        private String buildableIdentifier;
        private String blueprintIdentifier;
        private String buildableName;
        private String blueprintName;

        public String getContainerRelativePath() {
            return this.containerRelativePath;
        }

        public void setContainerRelativePath(String containerRelativePath) {
            this.containerRelativePath = containerRelativePath;
        }

        public String getBuildableIdentifier() {
            return this.buildableIdentifier;
        }

        public void setBuildableIdentifier(String buildableIdentifier) {
            this.buildableIdentifier = buildableIdentifier;
        }

        public String getBlueprintIdentifier() {
            return this.blueprintIdentifier;
        }

        public void setBlueprintIdentifier(String blueprintIdentifier) {
            this.blueprintIdentifier = blueprintIdentifier;
        }

        public String getBuildableName() {
            return this.buildableName;
        }

        public void setBuildableName(String buildableName) {
            this.buildableName = buildableName;
        }

        public String getBlueprintName() {
            return this.blueprintName;
        }

        public void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        public Node toXml() {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("BuildableIdentifier", this.getBuildableIdentifier());
            attributes.put("BlueprintIdentifier", this.getBlueprintIdentifier());
            attributes.put("BuildableName", this.getBuildableName());
            attributes.put("BlueprintName", this.getBlueprintName());
            attributes.put("ReferencedContainer", "container:" + this.getContainerRelativePath());
            return new Node(null, (Object)"BuildableReference", attributes);
        }
    }

    public static class ArchiveAction {
        private final Node xml;

        ArchiveAction(Node xml) {
            this.xml = xml;
        }

        public void setBuildConfiguration(String buildConfiguration) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildConfiguration", buildConfiguration);
        }
    }

    public static class AnalyzeAction {
        private final Node xml;

        AnalyzeAction(Node xml) {
            this.xml = xml;
        }

        public void setBuildConfiguration(String buildConfiguration) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildConfiguration", buildConfiguration);
        }
    }

    public static class ProfileAction {
        private final Node xml;

        ProfileAction(Node xml) {
            this.xml = xml;
        }

        public void setBuildConfiguration(String buildConfiguration) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildConfiguration", buildConfiguration);
        }
    }

    public static class LaunchAction {
        private final Node xml;

        LaunchAction(Node xml) {
            this.xml = xml;
        }

        public void setBuildConfiguration(String buildConfiguration) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildConfiguration", buildConfiguration);
        }

        public void setBuildableProductRunnable(BuildableReference buildableReference) {
            this.xml.appendNode((Object)"BuildableProductRunnable").append(buildableReference.toXml());
        }

        public void setBuildableReference(BuildableReference buildableReference) {
            this.xml.append(buildableReference.toXml());
        }
    }

    public static class TestableEntry {
        private final Node xml;

        TestableEntry(Node xml) {
            this.xml = xml;
        }

        public void setSkipped(boolean skipped) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("skipped", XcodeSchemeFile.toYesNo(skipped));
        }

        public void setBuildableReference(BuildableReference buildableReference) {
            this.xml.append(buildableReference.toXml());
        }
    }

    public static class TestAction {
        private final Node xml;

        TestAction(Node xml) {
            this.xml = xml;
        }

        public void setBuildConfiguration(String buildConfiguration) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildConfiguration", buildConfiguration);
        }

        public void entry(Action<TestableEntry> action) {
            action.execute(new TestableEntry(XcodeSchemeFile.getOrAppendNode(this.xml, "Testables").appendNode((Object)"TestableReference")));
        }
    }

    public static class BuildActionEntry {
        private final Node xml;

        BuildActionEntry(Node xml) {
            this.xml = xml;
        }

        public void setBuildForRunning(boolean buildForRunning) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildForRunning", XcodeSchemeFile.toYesNo(buildForRunning));
        }

        public void setBuildForTesting(boolean buildForTesting) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildForTesting", XcodeSchemeFile.toYesNo(buildForTesting));
        }

        public void setBuildForProfiling(boolean buildForProfiling) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildForProfiling", XcodeSchemeFile.toYesNo(buildForProfiling));
        }

        public void setBuildForArchiving(boolean buildForArchiving) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildForArchiving", XcodeSchemeFile.toYesNo(buildForArchiving));
        }

        public void setBuildForAnalysing(boolean buildForAnalysing) {
            Map attributes = (Map)Cast.uncheckedNonnullCast(this.xml.attributes());
            attributes.put("buildForAnalyzing", XcodeSchemeFile.toYesNo(buildForAnalysing));
        }

        public void setBuildableReference(BuildableReference buildableReference) {
            this.xml.append(buildableReference.toXml());
        }
    }

    public static class BuildAction {
        private final Node xml;

        BuildAction(Node xml) {
            this.xml = xml;
        }

        public void entry(Action<BuildActionEntry> action) {
            action.execute(new BuildActionEntry(XcodeSchemeFile.getOrAppendNode(this.xml, "BuildActionEntries").appendNode((Object)"BuildActionEntry")));
        }
    }
}

