/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class MultipleCandidateMatcher<T extends HasAttributes> {
    private final AttributeSelectionSchema schema;
    private final ImmutableAttributes requested;
    private final List<? extends T> candidates;
    private final ImmutableAttributes[] candidateAttributeSets;
    private final AttributeMatchingExplanationBuilder explanationBuilder;
    private final List<Attribute<?>> requestedAttributes;
    private final BitSet compatible;
    private final Object[] requestedAttributeValues;
    private final Object[] candidateValues;
    private int candidateWithLongestMatch;
    private int lengthOfLongestMatch;
    private BitSet remaining;

    <E extends T> MultipleCandidateMatcher(AttributeSelectionSchema schema, List<E> candidates, ImmutableAttributes requested, AttributeMatchingExplanationBuilder explanationBuilder) {
        this.schema = schema;
        this.candidates = candidates;
        this.requested = requested;
        this.explanationBuilder = explanationBuilder;
        this.requestedAttributes = requested.keySet().asList();
        this.requestedAttributeValues = MultipleCandidateMatcher.getRequestedValues(this.requestedAttributes, requested);
        this.candidateAttributeSets = MultipleCandidateMatcher.getCandidateAttributeSets(this.candidates);
        this.candidateValues = new Object[candidates.size() * this.requestedAttributes.size()];
        this.compatible = new BitSet(candidates.size());
        this.compatible.set(0, candidates.size());
    }

    public int[] getMatches() {
        this.findCompatibleCandidates();
        if (this.compatible.cardinality() <= 1) {
            return this.getCandidates(this.compatible);
        }
        if (this.longestMatchIsSuperSetOfAllOthers()) {
            HasAttributes o = (HasAttributes)this.candidates.get(this.candidateWithLongestMatch);
            this.explanationBuilder.candidateIsSuperSetOfAllOthers(o);
            return new int[]{this.candidateWithLongestMatch};
        }
        return this.disambiguateCompatibleCandidates();
    }

    private static Object[] getRequestedValues(List<Attribute<?>> requestedAttributes, ImmutableAttributes requested) {
        Object[] requestedAttributeValues = new Object[requestedAttributes.size()];
        for (int a = 0; a < requestedAttributes.size(); ++a) {
            Attribute<?> attribute = requestedAttributes.get(a);
            AttributeValue<?> attributeValue = requested.findEntry(attribute);
            requestedAttributeValues[a] = attributeValue.isPresent() ? attributeValue.get() : null;
        }
        return requestedAttributeValues;
    }

    private static ImmutableAttributes[] getCandidateAttributeSets(List<? extends HasAttributes> candidates) {
        ImmutableAttributes[] candidateAttributeSets = new ImmutableAttributes[candidates.size()];
        for (int i = 0; i < candidates.size(); ++i) {
            candidateAttributeSets[i] = ((AttributeContainerInternal)candidates.get(i).getAttributes()).asImmutable();
        }
        return candidateAttributeSets;
    }

    private void findCompatibleCandidates() {
        if (this.requested.isEmpty()) {
            return;
        }
        for (int c = 0; c < this.candidates.size(); ++c) {
            this.matchCandidate(c);
        }
    }

    private void matchCandidate(int c) {
        int matchLength = 0;
        for (int a = 0; a < this.requestedAttributes.size(); ++a) {
            MatchResult result2 = this.recordAndMatchCandidateValue(c, a);
            if (result2 == MatchResult.NO_MATCH) {
                this.compatible.clear(c);
                return;
            }
            if (result2 != MatchResult.MATCH) continue;
            ++matchLength;
        }
        if (matchLength > this.lengthOfLongestMatch) {
            this.lengthOfLongestMatch = matchLength;
            this.candidateWithLongestMatch = c;
        }
    }

    private MatchResult recordAndMatchCandidateValue(int c, int a) {
        Object requestedValue = this.requestedAttributeValues[a];
        Attribute<?> attribute = this.requestedAttributes.get(a);
        AttributeValue<?> candidateValue = this.candidateAttributeSets[c].findEntry(attribute.getName());
        if (!candidateValue.isPresent()) {
            this.setCandidateValue(c, a, null);
            this.explanationBuilder.candidateAttributeMissing((HasAttributes)this.candidates.get(c), attribute, requestedValue);
            return MatchResult.MISSING;
        }
        Object coercedValue = candidateValue.coerce(attribute);
        this.setCandidateValue(c, a, coercedValue);
        if (this.schema.matchValue(attribute, requestedValue, coercedValue)) {
            return MatchResult.MATCH;
        }
        this.explanationBuilder.candidateAttributeDoesNotMatch((HasAttributes)this.candidates.get(c), attribute, requestedValue, candidateValue);
        return MatchResult.NO_MATCH;
    }

    private boolean longestMatchIsSuperSetOfAllOthers() {
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            if (c != this.candidateWithLongestMatch) {
                int lengthOfOtherMatch = 0;
                for (int a = 0; a < this.requestedAttributes.size(); ++a) {
                    if (this.getCandidateValue(c, a) == null) continue;
                    ++lengthOfOtherMatch;
                    if (this.getCandidateValue(this.candidateWithLongestMatch, a) != null) continue;
                    return false;
                }
                if (lengthOfOtherMatch == this.lengthOfLongestMatch) {
                    return false;
                }
            }
            c = this.compatible.nextSetBit(c + 1);
        }
        return true;
    }

    private int[] disambiguateCompatibleCandidates() {
        this.remaining = new BitSet(this.candidates.size());
        this.remaining.or(this.compatible);
        this.disambiguateWithRequestedAttributeValues();
        if (this.remaining.cardinality() == 0) {
            return this.getCandidates(this.compatible);
        }
        if (this.remaining.cardinality() == 1) {
            return this.getCandidates(this.remaining);
        }
        Attribute<?>[] extraAttributes = this.schema.collectExtraAttributes(this.candidateAttributeSets, this.requested);
        if (this.remaining.cardinality() > 1) {
            this.disambiguateWithExtraAttributes(extraAttributes);
        }
        if (this.remaining.cardinality() > 1) {
            this.disambiguateWithRequestedAttributeKeys(extraAttributes);
        }
        return this.remaining.cardinality() == 0 ? this.getCandidates(this.compatible) : this.getCandidates(this.remaining);
    }

    private void disambiguateWithRequestedAttributeKeys(Attribute<?>[] extraAttributes) {
        if (this.requestedAttributes.isEmpty()) {
            return;
        }
        for (Attribute<?> extraAttribute : extraAttributes) {
            int candidateCount = this.candidateAttributeSets.length;
            BitSet any = new BitSet(candidateCount);
            for (int c = 0; c < candidateCount; ++c) {
                ImmutableAttributes candidateAttributeSet = this.candidateAttributeSets[c];
                if (!candidateAttributeSet.findEntry(extraAttribute.getName()).isPresent()) continue;
                any.set(c);
            }
            if (any.cardinality() <= 0 || any.cardinality() == candidateCount) continue;
            this.remaining.andNot(any);
            if (this.remaining.cardinality() == 0) break;
        }
    }

    private void disambiguateWithRequestedAttributeValues() {
        AttributeSelectionSchema.PrecedenceResult precedenceResult = this.schema.orderByPrecedence((Collection<Attribute<?>>)this.requested.keySet());
        for (int a : precedenceResult.getSortedOrder()) {
            this.disambiguateRequestedAttribute(a);
            if (this.remaining.cardinality() == 0) {
                return;
            }
            if (this.remaining.cardinality() != 1) continue;
            return;
        }
        for (int a : precedenceResult.getUnsortedOrder()) {
            this.disambiguateRequestedAttribute(a);
            if (this.remaining.cardinality() != 0) continue;
            return;
        }
    }

    private void disambiguateRequestedAttribute(int a) {
        Set<Object> candidateValues = MultipleCandidateMatcher.getCandidateValues(this.compatible, c -> this.getCandidateValue(c, a));
        if (candidateValues.size() <= 1) {
            return;
        }
        Set<Object> matches = this.schema.disambiguate(this.requestedAttributes.get(a), this.requestedAttributeValues[a], candidateValues);
        if (matches != null && matches.size() < candidateValues.size()) {
            int c2 = this.remaining.nextSetBit(0);
            while (c2 >= 0) {
                if (!matches.contains(this.getCandidateValue(c2, a))) {
                    this.remaining.clear(c2);
                }
                c2 = this.remaining.nextSetBit(c2 + 1);
            }
        }
    }

    private void disambiguateExtraAttribute(Attribute<?> attribute, BitSet candidates) {
        Set<Object> candidateValues = MultipleCandidateMatcher.getCandidateValues(candidates, c -> this.getCandidateValue(c, attribute));
        if (candidateValues.size() < 1) {
            return;
        }
        Set<Object> matches = this.schema.disambiguate(attribute, null, candidateValues);
        if (matches != null) {
            int c2 = this.remaining.nextSetBit(0);
            while (c2 >= 0) {
                if (!matches.contains(this.getCandidateValue(c2, attribute))) {
                    this.remaining.clear(c2);
                }
                c2 = this.remaining.nextSetBit(c2 + 1);
            }
        }
    }

    private static Set<Object> getCandidateValues(BitSet compatible, IntFunction<Object> candidateValueFetcher) {
        Set candidateValues = null;
        Object compatibleValue = null;
        boolean first = true;
        int c = compatible.nextSetBit(0);
        while (c >= 0) {
            Object candidateValue = candidateValueFetcher.apply(c);
            if (candidateValue != null) {
                if (first) {
                    compatibleValue = candidateValue;
                    first = false;
                } else if (compatibleValue != candidateValue || candidateValues != null) {
                    if (candidateValues == null) {
                        candidateValues = Sets.newHashSetWithExpectedSize((int)compatible.cardinality());
                        candidateValues.add(compatibleValue);
                    }
                    candidateValues.add(candidateValue);
                }
            }
            c = compatible.nextSetBit(c + 1);
        }
        if (candidateValues == null) {
            if (compatibleValue == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(compatibleValue);
        }
        return candidateValues;
    }

    private void disambiguateWithExtraAttributes(Attribute<?>[] extraAttributes) {
        AttributeSelectionSchema.PrecedenceResult precedenceResult = this.schema.orderByPrecedence(Arrays.asList(extraAttributes));
        for (int a : precedenceResult.getSortedOrder()) {
            this.disambiguateExtraAttribute(extraAttributes[a], this.remaining);
            if (this.remaining.cardinality() == 0) {
                return;
            }
            if (this.remaining.cardinality() != 1) continue;
            return;
        }
        BitSet candidates = new BitSet();
        candidates.or(this.remaining);
        for (int a : precedenceResult.getUnsortedOrder()) {
            this.disambiguateExtraAttribute(extraAttributes[a], candidates);
            if (this.remaining.cardinality() != 0) continue;
            return;
        }
    }

    private int[] getCandidates(BitSet liveSet) {
        if (liveSet.cardinality() == 0) {
            return new int[0];
        }
        if (liveSet.cardinality() == 1) {
            return new int[]{liveSet.nextSetBit(0)};
        }
        int i = 0;
        int[] result2 = new int[liveSet.cardinality()];
        int c = liveSet.nextSetBit(0);
        while (c >= 0) {
            result2[i++] = c;
            c = liveSet.nextSetBit(c + 1);
        }
        return result2;
    }

    @Nullable
    private Object getCandidateValue(int c, Attribute<?> attribute) {
        AttributeValue<?> attributeValue = this.candidateAttributeSets[c].findEntry(attribute.getName());
        return attributeValue.isPresent() ? attributeValue.coerce(attribute) : null;
    }

    @Nullable
    private Object getCandidateValue(int c, int a) {
        return this.candidateValues[this.getValueIndex(c, a)];
    }

    private void setCandidateValue(int c, int a, @Nullable Object value) {
        this.candidateValues[this.getValueIndex((int)c, (int)a)] = value;
    }

    private int getValueIndex(int c, int a) {
        return c * this.requestedAttributes.size() + a;
    }

    private static enum MatchResult {
        MATCH,
        MISSING,
        NO_MATCH;

    }
}

