/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.LogLevelConverter;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.operations.LogEventBuildOperationProgressDetails;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.logging.LogEventLevel;

public class LogEvent
extends RenderableOutputEvent
implements LogEventBuildOperationProgressDetails {
    private final String message;
    private final Throwable throwable;

    public LogEvent(long timestamp, String category, LogLevel logLevel, String message, @Nullable Throwable throwable) {
        this(timestamp, category, logLevel, message, throwable, null);
    }

    public LogEvent(long timestamp, String category, LogLevel logLevel, String message, @Nullable Throwable throwable, @Nullable OperationIdentifier buildOperationIdentifier) {
        super(timestamp, category, logLevel, buildOperationIdentifier);
        this.message = message;
        this.throwable = throwable;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void render(StyledTextOutput output) {
        output.text(this.message);
        output.println();
        if (this.throwable != null) {
            output.exception(this.throwable);
        }
    }

    public String toString() {
        return "[" + (Object)((Object)this.getLogLevel()) + "] [" + this.getCategory() + "] " + this.message;
    }

    @Override
    public LogEventLevel getLevel() {
        return LogLevelConverter.convert(this.getLogLevel());
    }

    @Override
    public RenderableOutputEvent withBuildOperationId(OperationIdentifier buildOperationId) {
        return new LogEvent(this.getTimestamp(), this.getCategory(), this.getLogLevel(), this.message, this.throwable, buildOperationId);
    }
}

