/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.internal.DefaultClassLoaderWorkerSpec;

public class DefaultProcessWorkerSpec
extends DefaultClassLoaderWorkerSpec
implements ProcessWorkerSpec,
ClassLoaderWorkerSpec {
    private static final Pattern INHERITED_UNIX_ENVIRONMENT = Pattern.compile("(LANG|LANGUAGE|LC_.*)");
    protected final JavaForkOptions forkOptions;

    @Inject
    public DefaultProcessWorkerSpec(JavaForkOptions forkOptions, ObjectFactory objectFactory) {
        super(objectFactory);
        this.forkOptions = forkOptions;
        this.forkOptions.setEnvironment(DefaultProcessWorkerSpec.sanitizeEnvironment(forkOptions));
    }

    private static Map<String, Object> sanitizeEnvironment(JavaForkOptions forkOptions) {
        if (!OperatingSystem.current().isUnix()) {
            return ImmutableMap.of();
        }
        return (Map)forkOptions.getEnvironment().entrySet().stream().filter(entry -> INHERITED_UNIX_ENVIRONMENT.matcher((CharSequence)entry.getKey()).matches()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public JavaForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Override
    public void forkOptions(Action<? super JavaForkOptions> forkOptionsAction) {
        forkOptionsAction.execute(this.forkOptions);
    }
}

