/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"DELETED_FILE_MARKER", "", "collectFileStatesFromFiles", "", "Lcom/intellij/settingsSync/FileState;", "paths", "Ljava/nio/file/Path;", "rootConfigPath", "getFileStateFromFileWithDeletedMarker", "file", "storageBasePath", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nFileState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileState.kt\ncom/intellij/settingsSync/FileStateKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,70:1\n1155#2,3:71\n*S KotlinDebug\n*F\n+ 1 FileState.kt\ncom/intellij/settingsSync/FileStateKt\n*L\n62#1:71,3\n*E\n"})
public final class FileStateKt {
    @NotNull
    public static final String DELETED_FILE_MARKER = "DELETED";

    @NotNull
    public static final FileState getFileStateFromFileWithDeletedMarker(@NotNull Path file, @NotNull Path storageBasePath) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)storageBasePath, (String)"storageBasePath");
        byte[] byArray = Files.readAllBytes(file);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
        byte[] bytes = byArray;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset charset2 = charset;
        String text = new String(bytes, charset2);
        String fileSpec = PathKt.getSystemIndependentPath((Path)PathsKt.relativeTo((Path)file, (Path)storageBasePath));
        return Intrinsics.areEqual((Object)text, (Object)DELETED_FILE_MARKER) ? (FileState)new FileState.Deleted(fileSpec) : (FileState)new FileState.Modified(fileSpec, bytes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<FileState> collectFileStatesFromFiles(@NotNull Set<? extends Path> paths, @NotNull Path rootConfigPath) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)rootConfigPath, (String)"rootConfigPath");
        Set fileStates2 = new LinkedHashSet();
        for (Path path : paths) {
            void $this$mapTo$iv;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ((Collection)fileStates2).add(FileStateKt.getFileStateFromFileWithDeletedMarker(path, rootConfigPath));
                continue;
            }
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file)), (Function1)collectFileStatesFromFiles.fileStatesFromFolder.1.INSTANCE);
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                File file2 = (File)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Path path2 = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                collection.add(FileStateKt.getFileStateFromFileWithDeletedMarker(path2, rootConfigPath));
            }
            HashSet fileStatesFromFolder2 = (HashSet)destination$iv;
            fileStates2.addAll(fileStatesFromFolder2);
        }
        return fileStates2;
    }
}

