/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentCategorizer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.settingsSync.SettingsSyncSettings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\"\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001H\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"findComponentClasses", "", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "", "fileSpec", "", "getCategory", "Lcom/intellij/openapi/components/SettingsCategory;", "componentClasses", "getSchemeCategory", "getSubCategory", "isSyncEnabled", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "removeOsPrefix", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncFiltering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncFiltering.kt\ncom/intellij/settingsSync/SettingsSyncFilteringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1855#2,2:90\n*S KotlinDebug\n*F\n+ 1 SettingsSyncFiltering.kt\ncom/intellij/settingsSync/SettingsSyncFilteringKt\n*L\n39#1:90,2\n*E\n"})
public final class SettingsSyncFilteringKt {
    public static final boolean isSyncEnabled(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        SettingsCategory category;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (roamingType == RoamingType.DISABLED) {
            return false;
        }
        String rawFileSpec = SettingsSyncFilteringKt.removeOsPrefix(fileSpec);
        if (Intrinsics.areEqual((Object)rawFileSpec, (Object)"settingsSync.xml")) {
            return true;
        }
        List<Class<PersistentStateComponent<Object>>> componentClasses = SettingsSyncFilteringKt.findComponentClasses(rawFileSpec);
        SettingsCategory settingsCategory = SettingsSyncFilteringKt.getSchemeCategory(rawFileSpec);
        if (settingsCategory == null) {
            settingsCategory = SettingsSyncFilteringKt.getCategory(componentClasses);
        }
        if ((category = settingsCategory) != SettingsCategory.OTHER && SettingsSyncSettings.Companion.getInstance().isCategoryEnabled(category)) {
            String subCategory = SettingsSyncFilteringKt.getSubCategory(componentClasses);
            if (subCategory != null) {
                return SettingsSyncSettings.Companion.getInstance().isSubcategoryEnabled(category, subCategory);
            }
            return true;
        }
        return false;
    }

    private static final String removeOsPrefix(String fileSpec) {
        String string;
        String osPrefix = StoreUtilKt.getPerOsSettingsStorageFolderName() + "/";
        if (StringsKt.startsWith$default((String)fileSpec, (String)osPrefix, (boolean)false, (int)2, null)) {
            String string2 = StringUtil.trimStart((String)fileSpec, (String)osPrefix);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(...)");
        } else {
            string = fileSpec;
        }
        return string;
    }

    private static final SettingsCategory getCategory(List<Class<PersistentStateComponent<Object>>> componentClasses) {
        if (componentClasses.isEmpty()) {
            return SettingsCategory.OTHER;
        }
        if (componentClasses.size() == 1) {
            SettingsCategory settingsCategory = ComponentCategorizer.getCategory(componentClasses.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)settingsCategory, (String)"getCategory(...)");
            return settingsCategory;
        }
        Iterable $this$forEach$iv = componentClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SettingsCategory category;
            Class it = (Class)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ComponentCategorizer.getCategory((Class)it), (String)"getCategory(...)");
            if (category == SettingsCategory.OTHER) continue;
            return category;
        }
        return SettingsCategory.OTHER;
    }

    private static final SettingsCategory getSchemeCategory(String fileSpec) {
        String string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)fileSpec, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separatorIndex >= 0) {
            String string2 = fileSpec.substring(0, separatorIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = fileSpec;
        }
        String directoryName = string;
        Ref.ObjectRef settingsCategory = new Ref.ObjectRef();
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(directoryName, (Ref.ObjectRef<SettingsCategory>)settingsCategory){
            final /* synthetic */ String $directoryName;
            final /* synthetic */ Ref.ObjectRef<SettingsCategory> $settingsCategory;
            {
                this.$directoryName = $directoryName;
                this.$settingsCategory = $settingsCategory;
                super(1);
            }

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getFileSpec(), (Object)this.$directoryName)) {
                    this.$settingsCategory.element = it.getSettingsCategory();
                }
            }
        });
        return (SettingsCategory)settingsCategory.element;
    }

    private static final String getSubCategory(List<Class<PersistentStateComponent<Object>>> componentClasses) {
        for (Class<PersistentStateComponent<Object>> componentClass : componentClasses) {
            if (!AppEditorFontOptions.class.isAssignableFrom(componentClass)) continue;
            return "editorFont";
        }
        return null;
    }

    private static final List<Class<PersistentStateComponent<Object>>> findComponentClasses(String fileSpec) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
        ArrayList<Class<PersistentStateComponent<Object>>> componentClasses = new ArrayList<Class<PersistentStateComponent<Object>>>();
        componentManager.processAllImplementationClasses(new Function2<Class<?>, PluginDescriptor, Unit>(fileSpec, componentClasses){
            final /* synthetic */ String $fileSpec;
            final /* synthetic */ ArrayList<Class<PersistentStateComponent<Object>>> $componentClasses;
            {
                this.$fileSpec = $fileSpec;
                this.$componentClasses = $componentClasses;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                block2: {
                    Storage[] state;
                    Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                    if (!PersistentStateComponent.class.isAssignableFrom(aClass)) break block2;
                    Storage[] storageArray = state = aClass.getAnnotation(State.class);
                    if (state != null && (storageArray = storageArray.storages()) != null) {
                        void $this$forEach$iv;
                        Storage[] storageArray2 = storageArray;
                        String string = this.$fileSpec;
                        ArrayList<Class<PersistentStateComponent<Object>>> arrayList = this.$componentClasses;
                        boolean $i$f$forEach = false;
                        int n = ((void)$this$forEach$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void element$iv;
                            void storage = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            if (storage.deprecated() || !Intrinsics.areEqual((Object)storage.value(), (Object)string)) continue;
                            arrayList.add(aClass);
                        }
                    }
                }
            }
        });
        return componentClasses;
    }
}

