/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.X11Forwarding;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\u0010H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0006*\u00020\u0011H\u0002\u001a\u0014\u0010\u000f\u001a\n \u0012*\u0004\u0018\u00010\u000b0\u000b*\u00020\u0013H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "minimalX11Port", "", "tryConnectToRegularDisplay", "Ljava/net/Socket;", "d", "", "tryConnectToWindowsDisplay", "tryConnectToXquartz", "Lorg/newsclub/net/unix/AFUNIXSocket;", "verifyDisplay", "", "value", "tryConnect", "Lcom/intellij/ssh/X11Forwarding;", "Ljava/net/InetSocketAddress;", "kotlin.jvm.PlatformType", "Lorg/newsclub/net/unix/AFUNIXSocketAddress;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nX11Forwarding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 X11Forwarding.kt\ncom/intellij/ssh/X11ForwardingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class X11ForwardingKt {
    private static final int minimalX11Port = 6000;
    @NotNull
    private static final Logger LOG;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Socket tryConnect(@NotNull X11Forwarding $this$tryConnect) throws IOException {
        Object object;
        Object object2;
        block4: {
            block3: {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$tryConnect, (String)"<this>");
                String it = string2 = $this$tryConnect.getDisplayName();
                boolean bl = false;
                String string3 = string = ((CharSequence)it).length() > 0 ? string2 : null;
                if (string == null) break block3;
                object2 = string;
                String p0 = object2;
                boolean bl2 = false;
                X11ForwardingKt.verifyDisplay(p0);
                String it2 = object2;
                boolean bl3 = false;
                AFUNIXSocket aFUNIXSocket = X11ForwardingKt.tryConnectToXquartz(it2);
                object2 = aFUNIXSocket != null ? (Socket)aFUNIXSocket : X11ForwardingKt.tryConnectToRegularDisplay(it2);
                if (object2 != null) break block4;
            }
            Socket socket = X11ForwardingKt.tryConnectToWindowsDisplay();
            object = socket;
            if (socket != null) return object;
            X11Forwarding $this$tryConnect_u24lambda_u242 = $this$tryConnect;
            boolean bl = false;
            LOG.info("Can't extract path to X11 socket from DISPLAY=" + $this$tryConnect_u24lambda_u242.getDisplayName());
            return null;
        }
        object = object2;
        return object;
    }

    private static final void verifyDisplay(String value) {
        if (((CharSequence)value).length() > 0) {
            CharSequence charSequence = value;
            if (!new Regex("^[A-Za-z0-9:/._-]+$").matches(charSequence)) {
                boolean $i$a$-require-X11ForwardingKt$verifyDisplay$32 = false;
                String $i$a$-require-X11ForwardingKt$verifyDisplay$32 = "DISPLAY = `" + value + "` contains invalid character";
                throw new IllegalArgumentException($i$a$-require-X11ForwardingKt$verifyDisplay$32.toString());
            }
            if (!(value.length() < 512)) {
                boolean bl = false;
                String string = "DISPLAY is too long";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    private static final Socket tryConnect(InetSocketAddress $this$tryConnect) {
        Socket socket;
        Socket it = socket = new Socket();
        boolean bl = false;
        it.connect($this$tryConnect);
        return socket;
    }

    private static final AFUNIXSocket tryConnect(AFUNIXSocketAddress $this$tryConnect) {
        AFUNIXSocket aFUNIXSocket;
        AFUNIXSocket it = aFUNIXSocket = AFUNIXSocket.newInstance();
        boolean bl = false;
        it.connect((SocketAddress)$this$tryConnect);
        return aFUNIXSocket;
    }

    private static final Socket tryConnectToRegularDisplay(String d) {
        CharSequence charSequence = d;
        if (new Regex("^:[0-9]+$").matches(charSequence)) {
            String string = d.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String path = "/tmp/.X11-unix/X" + string;
            LOG.info("DISPLAY=" + d + " points to unix:" + path);
            return (Socket)X11ForwardingKt.tryConnect(new AFUNIXSocketAddress(new File(path)));
        }
        if (StringsKt.startsWith$default((String)d, (String)"unix:", (boolean)false, (int)2, null)) {
            LOG.info("DISPLAY=" + d + " points to " + d);
            String string = d.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return (Socket)X11ForwardingKt.tryConnect(new AFUNIXSocketAddress(new File(string)));
        }
        int colonIdx = StringsKt.lastIndexOf$default((CharSequence)d, (char)':', (int)0, (boolean)false, (int)6, null);
        if (colonIdx >= 0) {
            Object object;
            Object object2;
            Object $i$a$-runCatching-X11ForwardingKt$tryConnectToRegularDisplay$addr$22;
            String string = d.substring(0, colonIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String addrString = string;
            try {
                boolean $i$a$-runCatching-X11ForwardingKt$tryConnectToRegularDisplay$addr$22 = false;
                $i$a$-runCatching-X11ForwardingKt$tryConnectToRegularDisplay$addr$22 = Result.constructor-impl((Object)InetAddress.getByName(addrString));
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-X11ForwardingKt$tryConnectToRegularDisplay$addr$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-X11ForwardingKt$tryConnectToRegularDisplay$addr$22);
            if (throwable == null) {
                object2 = $i$a$-runCatching-X11ForwardingKt$tryConnectToRegularDisplay$addr$22;
            } else {
                Throwable it = throwable;
                boolean bl = false;
                LOG.warn("Can't resolve " + addrString, it);
                object2 = null;
            }
            InetAddress addr = (InetAddress)object2;
            try {
                boolean bl = false;
                String string2 = d.substring(colonIdx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                object = Result.constructor-impl((Object)(Integer.parseInt(string2) + 6000));
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Integer n = -1;
            int port2 = ((Number)(Result.isFailure-impl((Object)object) ? n : object)).intValue();
            if (addr != null) {
                boolean bl = 6000 <= port2 ? port2 < 65536 : false;
                if (bl) {
                    LOG.info("DISPLAY=" + d + " points to " + addr + ":" + port2);
                    return X11ForwardingKt.tryConnect(new InetSocketAddress(addr, port2));
                }
            }
        }
        return null;
    }

    private static final Socket tryConnectToWindowsDisplay() {
        Socket socket;
        if (SystemInfo.isWindows) {
            Socket socket2;
            LOG.info("Trying tcp:localhost:6000 on Windows");
            try {
                socket2 = X11ForwardingKt.tryConnect(new InetSocketAddress(InetAddress.getLoopbackAddress(), 6000));
            }
            catch (IOException ignored) {
                socket2 = null;
            }
            socket = socket2;
        } else {
            socket = null;
        }
        return socket;
    }

    private static final AFUNIXSocket tryConnectToXquartz(String d) {
        AFUNIXSocket aFUNIXSocket;
        if (!SystemInfo.isMac) {
            aFUNIXSocket = null;
        } else if (d.charAt(0) != '/') {
            aFUNIXSocket = null;
        } else if (new File(d).exists()) {
            LOG.info("DISPLAY=" + d + " is a Mac X socket that points to unix:" + d);
            AFUNIXSocketAddress aFUNIXSocketAddress = AFUNIXSocketAddress.of((File)new File(d));
            Intrinsics.checkNotNullExpressionValue((Object)aFUNIXSocketAddress, (String)"of(...)");
            aFUNIXSocket = X11ForwardingKt.tryConnect(aFUNIXSocketAddress);
        } else {
            String substr = StringsKt.substringBeforeLast((String)d, (char)'.', (String)"");
            if (!Intrinsics.areEqual((Object)substr, (Object)"")) {
                LOG.info("DISPLAY=" + d + " is a Mac X socket that points to unix:" + substr);
                AFUNIXSocketAddress aFUNIXSocketAddress = AFUNIXSocketAddress.of((File)new File(substr));
                Intrinsics.checkNotNullExpressionValue((Object)aFUNIXSocketAddress, (String)"of(...)");
                aFUNIXSocket = X11ForwardingKt.tryConnect(aFUNIXSocketAddress);
            } else {
                aFUNIXSocket = null;
            }
        }
        return aFUNIXSocket;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$verifyDisplay(String value) {
        X11ForwardingKt.verifyDisplay(value);
    }

    static {
        Logger logger = Logger.getInstance(X11Forwarding.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

