/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.CommonTransformationsProxyCallTreeNode;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.ValueType;
import com.intellij.profiler.model.diff.DiffCallTreeNode;
import com.intellij.profiler.model.diff.DiffCallWithValue;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.ToLongFunction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a:\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a.\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0001\u001a\u0006\u0010\u0019\u001a\u00020\u0017\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u001fH\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030 H\u0000\u001a\u0018\u0010!\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0000\u001a\f\u0010%\u001a\u00020&*\u00020'H\u0000\u001a\u001a\u0010(\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030)\u001a\n\u0010+\u001a\u00020\u0017*\u00020,\u001a\u001e\u0010-\u001a\u00020$*\u00020\u00112\u0006\u0010.\u001a\u00020\u00172\b\b\u0002\u0010/\u001a\u00020\u0017H\u0000\u001a\u0010\u00100\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u001fH\u0000\u001a\u0010\u00100\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030 H\u0000\u001a3\u00101\u001a\u00020\u001e\"\u0012\b\u0000\u00102*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030403*\u0002H22\f\u00105\u001a\b\u0012\u0004\u0012\u0002H206H\u0000\u00a2\u0006\u0002\u00107\u001a\u0016\u00108\u001a\u00020\u001e*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030403H\u0000\"\u0015\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"BACKGROUND", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "DEFAULT_TABLE_COLUMN_PROPORTION", "", "filteringTableViewSpeedSearch", "Lcom/intellij/ui/TableViewSpeedSearch;", "T", "", "table", "Lcom/intellij/ui/table/TableView;", "toString", "Lkotlin/Function1;", "", "findTableScrollPane", "Ljavax/swing/JScrollPane;", "root", "Ljavax/swing/JComponent;", "fractionToString", "fraction", "", "minimumVisibleValue", "sign", "", "useTimesForBigFractions", "isNewFlameGraphView", "applyDefaultBackground", "", "Lcom/intellij/ui/components/JBTreeTable;", "baselineValue", "", "Lcom/intellij/profiler/model/CommonTransformationsProxyCallTreeNode;", "Lcom/intellij/profiler/model/diff/DiffCallTreeNode;", "dropLastInplace", "", "n", "", "getSelectThreadActionDescriptor", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "Lcom/intellij/profiler/model/ThreadInfo;", "isChildOf", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "node", "isZoomKeyDown", "Ljava/awt/event/MouseEvent;", "metricsStringWidth", "isExpanded", "isSigned", "newValue", "sumOf", "Node", "Lcom/intellij/profiler/model/TreeNode;", "Lcom/intellij/profiler/model/CallWithValue;", "safeExtractor", "Ljava/util/function/ToLongFunction;", "(Lcom/intellij/profiler/model/TreeNode;Ljava/util/function/ToLongFunction;)J", "valueOrSumOfChildrenValues", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerUIUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerUIUtils.kt\ncom/intellij/profiler/ui/ProfilerUIUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class ProfilerUIUtilsKt {
    public static final float DEFAULT_TABLE_COLUMN_PROPORTION = 0.1f;
    @JvmField
    @NotNull
    public static final Color BACKGROUND;

    public static final void applyDefaultBackground(@NotNull JBTreeTable $this$applyDefaultBackground) {
        Intrinsics.checkNotNullParameter((Object)$this$applyDefaultBackground, (String)"<this>");
        $this$applyDefaultBackground.getTable().setBackground(BACKGROUND);
        $this$applyDefaultBackground.getTree().setBackground(BACKGROUND);
        JScrollPane tableScrollPane = ProfilerUIUtilsKt.findTableScrollPane((JComponent)$this$applyDefaultBackground);
        tableScrollPane.getVerticalScrollBar().setBackground(BACKGROUND);
        tableScrollPane.getHorizontalScrollBar().setBackground(BACKGROUND);
        tableScrollPane.getCorner("LOWER_RIGHT_CORNER").setBackground(BACKGROUND);
    }

    private static final JScrollPane findTableScrollPane(JComponent root) {
        JComponent jComponent = UIUtil.findComponentOfType((JComponent)root, OnePixelSplitter.class);
        Intrinsics.checkNotNull((Object)jComponent);
        OnePixelSplitter splitter = (OnePixelSplitter)jComponent;
        JComponent jComponent2 = splitter.getSecondComponent();
        Intrinsics.checkNotNull((Object)jComponent2, (String)"null cannot be cast to non-null type javax.swing.JScrollPane");
        return (JScrollPane)jComponent2;
    }

    public static final int metricsStringWidth(@NotNull JComponent $this$metricsStringWidth, boolean isExpanded, boolean isSigned) {
        Intrinsics.checkNotNullParameter((Object)$this$metricsStringWidth, (String)"<this>");
        FontMetrics fm = $this$metricsStringWidth.getFontMetrics($this$metricsStringWidth.getFont());
        double value = isExpanded && isSigned ? 9999.9 : (!isExpanded && !isSigned ? 99.9 : 999.9);
        String string = "%.1f%%";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{value};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        return MathKt.roundToInt((double)fm.getStringBounds(string2, null).getWidth());
    }

    public static /* synthetic */ int metricsStringWidth$default(JComponent jComponent, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return ProfilerUIUtilsKt.metricsStringWidth(jComponent, bl, bl2);
    }

    @NlsSafe
    @NotNull
    public static final String fractionToString(double fraction, double minimumVisibleValue, boolean sign, boolean useTimesForBigFractions) {
        Object object;
        if (!(minimumVisibleValue < 1.0)) {
            boolean bl = false;
            String string = "minimumVisibleValue should not be 1.0 or more";
            throw new IllegalArgumentException(string.toString());
        }
        if (Math.abs(fraction) < minimumVisibleValue) {
            object = "< " + MathKt.roundToInt((double)(minimumVisibleValue * (double)100)) + "%";
        } else if (fraction > 1.0 && useTimesForBigFractions) {
            String string = "x%.1f";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{fraction + 1.0};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        } else {
            String string = "%" + (sign && !(fraction == 0.0) ? "+" : "") + ".1f%%";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{fraction * (double)100};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
        }
        return object;
    }

    public static /* synthetic */ String fractionToString$default(double d, double d2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.01;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return ProfilerUIUtilsKt.fractionToString(d, d2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public static final <Node extends TreeNode<? extends CallWithValue<?>>> long sumOf(@NotNull Node $this$sumOf, @NotNull ToLongFunction<Node> safeExtractor) {
        long l;
        Intrinsics.checkNotNullParameter($this$sumOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(safeExtractor, (String)"safeExtractor");
        CallWithValue<?> callWithValue = $this$sumOf.getData();
        if (callWithValue != null) {
            CallWithValue<?> it = callWithValue;
            boolean bl = false;
            l = safeExtractor.applyAsLong($this$sumOf);
        } else {
            Iterable iterable = $this$sumOf.getChildren();
            long l2 = 0L;
            for (Object t : iterable) {
                void it;
                TreeNode treeNode = (TreeNode)t;
                long l3 = l2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type Node of com.intellij.profiler.ui.ProfilerUIUtilsKt.sumOf$lambda$2");
                long l4 = safeExtractor.applyAsLong(it);
                l2 = l3 + l4;
            }
            l = l2;
        }
        return l;
    }

    public static final long valueOrSumOfChildrenValues(@NotNull TreeNode<? extends CallWithValue<?>> $this$valueOrSumOfChildrenValues) {
        Intrinsics.checkNotNullParameter($this$valueOrSumOfChildrenValues, (String)"<this>");
        return ProfilerUIUtilsKt.sumOf($this$valueOrSumOfChildrenValues, ProfilerUIUtilsKt::valueOrSumOfChildrenValues$lambda$3);
    }

    public static final boolean isZoomKeyDown(@NotNull MouseEvent $this$isZoomKeyDown) {
        Intrinsics.checkNotNullParameter((Object)$this$isZoomKeyDown, (String)"<this>");
        return $this$isZoomKeyDown.isControlDown() || $this$isZoomKeyDown.isMetaDown();
    }

    public static final long baselineValue(@NotNull DiffCallTreeNode<?> $this$baselineValue) {
        Intrinsics.checkNotNullParameter($this$baselineValue, (String)"<this>");
        return ProfilerUIUtilsKt.sumOf((TreeNode)$this$baselineValue, ProfilerUIUtilsKt::baselineValue$lambda$4);
    }

    public static final long newValue(@NotNull DiffCallTreeNode<?> $this$newValue) {
        Intrinsics.checkNotNullParameter($this$newValue, (String)"<this>");
        return ProfilerUIUtilsKt.sumOf((TreeNode)$this$newValue, ProfilerUIUtilsKt::newValue$lambda$5);
    }

    public static final long baselineValue(@NotNull CommonTransformationsProxyCallTreeNode<?> $this$baselineValue) {
        Intrinsics.checkNotNullParameter($this$baselineValue, (String)"<this>");
        return ProfilerUIUtilsKt.sumOf((TreeNode)$this$baselineValue, ProfilerUIUtilsKt::baselineValue$lambda$6);
    }

    public static final long newValue(@NotNull CommonTransformationsProxyCallTreeNode<?> $this$newValue) {
        Intrinsics.checkNotNullParameter($this$newValue, (String)"<this>");
        return ProfilerUIUtilsKt.sumOf((TreeNode)$this$newValue, ProfilerUIUtilsKt::newValue$lambda$7);
    }

    @NotNull
    public static final <T> TableViewSpeedSearch<T> filteringTableViewSpeedSearch(@NotNull TableView<T> table, @NotNull Function1<? super T, String> toString) {
        TableViewSpeedSearch tableViewSpeedSearch;
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Intrinsics.checkNotNullParameter(toString, (String)"toString");
        TableViewSpeedSearch $this$filteringTableViewSpeedSearch_u24lambda_u248 = tableViewSpeedSearch = new TableViewSpeedSearch<T>(table, toString){
            final /* synthetic */ Function1<T, String> $toString;
            {
                this.$toString = $toString;
                super($table, null);
            }

            @Nullable
            protected String getItemText(@NotNull T element2) {
                Intrinsics.checkNotNullParameter(element2, (String)"element");
                return (String)this.$toString.invoke(element2);
            }

            protected boolean isStickySearch() {
                return false;
            }
        };
        boolean bl = false;
        $this$filteringTableViewSpeedSearch_u24lambda_u248.setupListeners();
        $this$filteringTableViewSpeedSearch_u24lambda_u248.setFilteringMode(true);
        return tableViewSpeedSearch;
    }

    public static final boolean isNewFlameGraphView() {
        return ExperimentalUI.Companion.isNewUI() && ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getExperimentalStyleForNewUi();
    }

    public static final void dropLastInplace(@NotNull List<?> $this$dropLastInplace, int n) {
        Intrinsics.checkNotNullParameter($this$dropLastInplace, (String)"<this>");
        int resultSize = $this$dropLastInplace.size() - n;
        if (resultSize <= 0) {
            $this$dropLastInplace.clear();
        } else {
            while ($this$dropLastInplace.size() > resultSize) {
                $this$dropLastInplace.remove(CollectionsKt.getLastIndex($this$dropLastInplace));
            }
        }
    }

    @NotNull
    public static final ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor getSelectThreadActionDescriptor(@NotNull ThreadInfo $this$getSelectThreadActionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectThreadActionDescriptor, (String)"<this>");
        return $this$getSelectThreadActionDescriptor == AllThreadsMerged.INSTANCE ? ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.THREAD_LIST_ATM : ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.THREAD_LIST_CUSTOM_THREAD;
    }

    public static final boolean isChildOf(@NotNull FlameGraphNode<?> $this$isChildOf, @NotNull FlameGraphNode<?> node2) {
        Intrinsics.checkNotNullParameter($this$isChildOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        return $this$isChildOf.getDepth() > node2.getDepth() && $this$isChildOf.getStart() >= node2.getStart() && $this$isChildOf.getEnd() <= node2.getEnd();
    }

    private static final long valueOrSumOfChildrenValues$lambda$3(TreeNode it) {
        Object Data = it.getData();
        Intrinsics.checkNotNull(Data);
        return ((CallWithValue)Data).getValue();
    }

    private static final long baselineValue$lambda$4(DiffCallTreeNode it) {
        Object object = it.getData();
        Intrinsics.checkNotNull((Object)object);
        return ((DiffCallWithValue)object).getBaselineValue();
    }

    private static final long newValue$lambda$5(DiffCallTreeNode it) {
        Object object = it.getData();
        Intrinsics.checkNotNull((Object)object);
        return ((DiffCallWithValue)object).getNewValue();
    }

    private static final long baselineValue$lambda$6(CommonTransformationsProxyCallTreeNode it) {
        ValueType valueType = it.getWrappedValue();
        Intrinsics.checkNotNull((Object)valueType, (String)"null cannot be cast to non-null type com.intellij.profiler.model.ValueType.Diff");
        return ((ValueType.Diff)valueType).getBaselineValue();
    }

    private static final long newValue$lambda$7(CommonTransformationsProxyCallTreeNode it) {
        ValueType valueType = it.getWrappedValue();
        Intrinsics.checkNotNull((Object)valueType, (String)"null cannot be cast to non-null type com.intellij.profiler.model.ValueType.Diff");
        return ((ValueType.Diff)valueType).getNewValue();
    }

    static {
        Color color2 = JBUI.CurrentTheme.ToolWindow.background();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"background(...)");
        BACKGROUND = color2;
    }
}

