/*
 * Decompiled with CFR 0.152.
 */
package training.project;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.project.ProjectUtils;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fJ;\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00130\u001eJ\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0007H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0004JC\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\f2!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00130\u001eH\u0002J\u0016\u0010/\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001cJA\u00100\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00130\u001eJ\u0010\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u001cH\u0002J\u0018\u0010%\u001a\n 3*\u0004\u0018\u00010\u00070\u00072\u0006\u00104\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u00065"}, d2={"Ltraining/project/ProjectUtils;", "", "()V", "FEATURE_TRAINER_VERSION", "", "LEARNING_PROJECT_MODIFICATION", "learningProjectsPath", "Ljava/nio/file/Path;", "getLearningProjectsPath", "()Ljava/nio/file/Path;", "chooseParentDirectoryForLearningProject", "langSupport", "Ltraining/lang/LangSupport;", "copyLearningProjectFiles", "newContentDirectory", "createProjectDirectory", "", "place", "createVersionFile", "", "newProjectDirectory", "getCurrentLearningProjectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLearningInstallationContentRoot", "getProjectRoot", "languageSupport", "importOrOpenProject", "projectToClose", "Lcom/intellij/openapi/project/Project;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "isEmptyDir", "path", "isSameVersion", "versionFile", "learningProjectUrl", "Ljava/net/URL;", "markDirectoryAsSourcesRoot", "project", "pathToSources", "openOrImportLearningProject", "contentRoot", "openProjectTask", "Lcom/intellij/ide/impl/OpenProjectTask;", "restoreProject", "simpleInstallAndOpenLearningProject", "updateLearningModificationTimestamp", "it", "kotlin.jvm.PlatformType", "dest", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nProjectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectUtils.kt\ntraining/project/ProjectUtils\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n42#2,10:352\n8#3:362\n8#3:367\n11065#4:363\n11400#4,3:364\n1#5:368\n1747#6,3:369\n*S KotlinDebug\n*F\n+ 1 ProjectUtils.kt\ntraining/project/ProjectUtils\n*L\n56#1:352,10\n249#1:362\n341#1:367\n249#1:363\n249#1:364,3\n285#1:369,3\n*E\n"})
public final class ProjectUtils {
    @NotNull
    public static final ProjectUtils INSTANCE = new ProjectUtils();
    @NotNull
    private static final String LEARNING_PROJECT_MODIFICATION = "LEARNING_PROJECT_MODIFICATION";
    @NotNull
    private static final String FEATURE_TRAINER_VERSION = "feature-trainer-version.txt";

    private ProjectUtils() {
    }

    @NotNull
    public final Path getLearningProjectsPath() {
        String[] stringArray = new String[]{"demo"};
        Path path = Paths.get(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public final void importOrOpenProject(@NotNull LangSupport langSupport2, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        String title$iv = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(projectToClose, title$iv, cancellable$iv, langSupport2, projectToClose, postInitCallback){
            final /* synthetic */ LangSupport $langSupport$inlined;
            final /* synthetic */ Project $projectToClose$inlined;
            final /* synthetic */ Function1 $postInitCallback$inlined;
            {
                this.$langSupport$inlined = langSupport2;
                this.$projectToClose$inlined = project;
                this.$postInitCallback$inlined = function1;
                super($project, $title, $cancellable);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                Path path = ProjectUtils.access$getLearningInstallationContentRoot(ProjectUtils.INSTANCE, this.$langSupport$inlined);
                if (path != null) {
                    Path dest = path;
                    Path path2 = ProjectUtils.access$versionFile(ProjectUtils.INSTANCE, dest);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"access$versionFile(...)");
                    if (!ProjectUtils.access$isSameVersion(ProjectUtils.INSTANCE, path2)) {
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(dest, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            PathKt.delete$default((Path)dest, (boolean)false, (int)1, null);
                        }
                        this.$langSupport$inlined.installAndOpenLearningProject(dest, this.$projectToClose$inlined, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>((Function1<? super Project, Unit>)this.$postInitCallback$inlined){
                            final /* synthetic */ Function1<Project, Unit> $postInitCallback;
                            {
                                this.$postInitCallback = $postInitCallback;
                                super(1);
                            }

                            public final void invoke(@NotNull Project it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$postInitCallback.invoke((Object)it);
                            }
                        }));
                    } else {
                        String path3 = ((Object)this.$langSupport$inlined.getLearningProjectPath(dest).toAbsolutePath()).toString();
                        LangManager.Companion.getInstance().setLearningProjectPath(this.$langSupport$inlined, path3);
                        ProjectUtils.access$openOrImportLearningProject(ProjectUtils.INSTANCE, dest, OpenProjectTaskKt.OpenProjectTask((Function1)((Function1)new Function1<OpenProjectTaskBuilder, Unit>(this.$projectToClose$inlined){
                            final /* synthetic */ Project $projectToClose;
                            {
                                this.$projectToClose = $projectToClose;
                                super(1);
                            }

                            public final void invoke(@NotNull OpenProjectTaskBuilder $this$OpenProjectTask) {
                                Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
                                $this$OpenProjectTask.setProjectToClose(this.$projectToClose);
                            }
                        })), this.$langSupport$inlined, this.$postInitCallback$inlined);
                    }
                }
            }
        });
    }

    private final Path getLearningInstallationContentRoot(LangSupport langSupport2) {
        Path path;
        Path path2;
        String storedProjectPath;
        String string = storedProjectPath = LangManager.Companion.getInstance().getLearningProjectPath(langSupport2.getPrimaryLanguage());
        if (string != null) {
            Path path3 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            path2 = langSupport2.getContentRootPath(path3);
        } else {
            path2 = null;
        }
        Path path4 = path2;
        Path canonicalPlace = this.getLearningProjectsPath().resolve(langSupport2.getContentRootDirectoryName());
        boolean useCanonical = true;
        if (path4 != null && !Intrinsics.areEqual((Object)path4, (Object)canonicalPlace)) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path5 = this.versionFile(path4);
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"versionFile(...)");
                Path path6 = path5;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(path6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Intrinsics.checkNotNull((Object)canonicalPlace);
                    if (this.createProjectDirectory(canonicalPlace)) {
                        RecentProjectListActionProvider rpProvider = RecentProjectListActionProvider.Companion.getInstance();
                        List projectActions = RecentProjectListActionProvider.getActions$default((RecentProjectListActionProvider)rpProvider, (boolean)false, (boolean)false, (int)3, null);
                        for (AnAction action2 : projectActions) {
                            ReopenProjectAction reopenProjectAction = action2 instanceof ReopenProjectAction ? (ReopenProjectAction)action2 : null;
                            String projectPath = reopenProjectAction != null ? reopenProjectAction.getProjectPath() : null;
                            if (projectPath == null || !Intrinsics.areEqual((Object)Paths.get(projectPath, new String[0]), (Object)path4)) continue;
                            RecentProjectsManager.Companion.getInstance().removePath(projectPath);
                        }
                        PathKt.delete((Path)path4, (boolean)true);
                    } else {
                        useCanonical = false;
                    }
                }
            }
        }
        if (useCanonical) {
            Intrinsics.checkNotNull((Object)canonicalPlace);
            if (this.createProjectDirectory(canonicalPlace)) {
                path = canonicalPlace;
            } else {
                path = (Path)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Path>(langSupport2){
                    final /* synthetic */ LangSupport $langSupport;
                    {
                        this.$langSupport = $langSupport;
                        super(0);
                    }

                    @Nullable
                    public final Path invoke() {
                        return ProjectUtils.access$chooseParentDirectoryForLearningProject(ProjectUtils.INSTANCE, this.$langSupport);
                    }
                }), (int)1, null);
                if (path == null) {
                    return null;
                }
            }
        } else {
            Path path7 = path4;
            path = path7;
            Intrinsics.checkNotNull((Object)path7);
        }
        return path;
    }

    private final boolean createProjectDirectory(Path place) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(place, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        try {
            PathKt.createDirectories((Path)place);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final VirtualFile getCurrentLearningProjectRoot() {
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw new IllegalStateException("No current language support".toString());
        }
        LangSupport languageSupport = langSupport2;
        return this.getProjectRoot(languageSupport);
    }

    @NotNull
    public final VirtualFile getProjectRoot(@NotNull LangSupport languageSupport) {
        Intrinsics.checkNotNullParameter((Object)languageSupport, (String)"languageSupport");
        Path path = this.getLearningInstallationContentRoot(languageSupport);
        if (path == null) {
            throw new IllegalStateException(("No path for learning project for " + languageSupport).toString());
        }
        Path learningInstallationContentRoot = path;
        Path projectPath = languageSupport.getLearningProjectPath(learningInstallationContentRoot);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(projectPath);
        if (virtualFile == null) {
            throw new IllegalStateException(("Cannot to convert " + projectPath + " to virtual file").toString());
        }
        return virtualFile;
    }

    public final void simpleInstallAndOpenLearningProject(@NotNull Path contentRoot, @NotNull LangSupport langSupport2, @NotNull OpenProjectTask openProjectTask, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        Intrinsics.checkNotNullParameter((Object)openProjectTask, (String)"openProjectTask");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        Path actualContentRoot = this.copyLearningProjectFiles(contentRoot, langSupport2);
        if (actualContentRoot == null) {
            return;
        }
        this.createVersionFile(actualContentRoot);
        this.openOrImportLearningProject(actualContentRoot, openProjectTask, langSupport2, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(postInitCallback){
            final /* synthetic */ Function1<Project, Unit> $postInitCallback;
            {
                this.$postInitCallback = $postInitCallback;
                super(1);
            }

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ProjectUtils.access$updateLearningModificationTimestamp(ProjectUtils.INSTANCE, it);
                this.$postInitCallback.invoke((Object)it);
            }
        }));
    }

    private final void updateLearningModificationTimestamp(Project it) {
        PropertiesComponent.getInstance((Project)it).setValue(LEARNING_PROJECT_MODIFICATION, String.valueOf(System.currentTimeMillis()));
    }

    private final void openOrImportLearningProject(Path contentRoot, OpenProjectTask openProjectTask, LangSupport langSupport2, Function1<? super Project, Unit> postInitCallback) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(langSupport2.getLearningProjectPath(contentRoot));
        if (virtualFile == null) {
            throw new IllegalStateException("Copied Learn project folder is null".toString());
        }
        VirtualFile projectDirectoryVirtualFile = virtualFile;
        OpenProjectTask task2 = OpenProjectTask.copy$default((OpenProjectTask)openProjectTask, (boolean)false, null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, (Function1)openOrImportLearningProject.task.1.INSTANCE, null, null, (boolean)false, null, null, (int)0x3EFFFF, null);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(contentRoot, langSupport2, projectDirectoryVirtualFile, task2, postInitCallback){
            final /* synthetic */ Path $contentRoot;
            final /* synthetic */ LangSupport $langSupport;
            final /* synthetic */ VirtualFile $projectDirectoryVirtualFile;
            final /* synthetic */ OpenProjectTask $task;
            final /* synthetic */ Function1<Project, Unit> $postInitCallback;
            {
                this.$contentRoot = $contentRoot;
                this.$langSupport = $langSupport;
                this.$projectDirectoryVirtualFile = $projectDirectoryVirtualFile;
                this.$task = $task;
                this.$postInitCallback = $postInitCallback;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Project project;
                TrustedPaths.Companion.getInstance().setProjectPathTrusted(this.$contentRoot, true);
                int confirmOpenNewProject = GeneralSettings.Companion.getInstance().getConfirmOpenNewProject();
                if (confirmOpenNewProject == 2) {
                    GeneralSettings.Companion.getInstance().setConfirmOpenNewProject(1);
                }
                try {
                    project = this.$langSupport.openOrImportLearningProject(this.$projectDirectoryVirtualFile, this.$task);
                }
                finally {
                    if (confirmOpenNewProject == 2) {
                        GeneralSettings.Companion.getInstance().setConfirmOpenNewProject(confirmOpenNewProject);
                    }
                }
                Project project2 = project;
                this.$postInitCallback.invoke((Object)project2);
            }
        }), (int)1, null);
    }

    private final Path copyLearningProjectFiles(Path newContentDirectory, LangSupport langSupport2) {
        Path targetDirectory = newContentDirectory;
        File file = targetDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        if (!LangSupport.copyLearningProjectFiles$default(langSupport2, file, null, 2, null)) {
            Path path = (Path)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Path>(langSupport2){
                final /* synthetic */ LangSupport $langSupport;
                {
                    this.$langSupport = $langSupport;
                    super(0);
                }

                @Nullable
                public final Path invoke() {
                    return ProjectUtils.access$chooseParentDirectoryForLearningProject(ProjectUtils.INSTANCE, this.$langSupport);
                }
            }), (int)1, null);
            if (path == null) {
                return null;
            }
            targetDirectory = path;
            File file2 = targetDirectory.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            if (!LangSupport.copyLearningProjectFiles$default(langSupport2, file2, null, 2, null)) {
                ActionsKt.invokeLater$default(null, (Function0)copyLearningProjectFiles.2.INSTANCE, (int)1, null);
                throw new IllegalStateException("Cannot create learning demo project. See LOG files for details.".toString());
            }
        }
        Path path = langSupport2.getLearningProjectPath(targetDirectory);
        LangManager.Companion.getInstance().setLearningProjectPath(langSupport2, ((Object)path.toAbsolutePath()).toString());
        return targetDirectory;
    }

    @NotNull
    public final URL learningProjectUrl(@NotNull LangSupport langSupport2) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        URL uRL = langSupport2.getClass().getClassLoader().getResource(langSupport2.getProjectResourcePath());
        if (uRL == null) {
            throw new IllegalArgumentException("No project " + langSupport2.getProjectResourcePath() + " in resources for " + langSupport2.getPrimaryLanguage() + " IDE learning course");
        }
        return uRL;
    }

    private final Path chooseParentDirectoryForLearningProject(LangSupport langSupport2) {
        Object[] objectArray = new Object[]{langSupport2.getContentRootDirectoryName()};
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false).withTitle(LearnBundle.INSTANCE.message("learn.project.initializing.choose.place", objectArray));
        FileChooserDialogImpl dialog2 = new FileChooserDialogImpl(descriptor, null);
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        dialog2.choose(VfsUtil.getUserHomeDir(), arg_0 -> ProjectUtils.chooseParentDirectoryForLearningProject$lambda$1(result2, arg_0));
        List list2 = (List)result2.element;
        if (list2 == null) {
            return null;
        }
        List directories = list2;
        if (directories.isEmpty()) {
            throw new IllegalStateException("No directory selected for the project".toString());
        }
        VirtualFile chosen = (VirtualFile)CollectionsKt.single((List)directories);
        String string = chosen.getCanonicalPath();
        if (string == null) {
            throw new IllegalStateException(("No canonical path for " + chosen).toString());
        }
        String canonicalPath = string;
        return new File(canonicalPath, langSupport2.getContentRootDirectoryName()).toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createVersionFile(Path newProjectDirectory) {
        Closeable closeable = new PrintWriter(newProjectDirectory.resolve(FEATURE_TRAINER_VERSION).toFile(), "UTF-8");
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl = false;
            it.println(UtilsKt.getFeatureTrainerVersion());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isSameVersion(Path versionFile) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(versionFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        Optional<String> res = Files.lines(versionFile).findFirst();
        if (res.isPresent()) {
            return Intrinsics.areEqual((Object)UtilsKt.getFeatureTrainerVersion(), (Object)res.get());
        }
        return false;
    }

    private final Path versionFile(Path dest) {
        return dest.resolve(FEATURE_TRAINER_VERSION);
    }

    /*
     * WARNING - void declaration
     */
    public final void markDirectoryAsSourcesRoot(@NotNull Project project, @NotNull String pathToSources) {
        Object object;
        ModifiableRootModel rootsModel;
        VirtualFile sourcesRoot;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pathToSources, (String)"pathToSources");
            Object[] modules2 = ModuleManager.Companion.getInstance(project).getModules();
            if (modules2.length > 1) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ProjectUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = modules2;
                Logger logger2 = logger;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                logger2.error("The learning project has more than one module: " + (List)destination$iv$iv);
            }
            Module module = (Module)ArraysKt.first((Object[])modules2);
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            String sourcesPath = string + "/" + pathToSources;
            sourcesRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourcesPath);
            if (sourcesRoot == null) {
                String status = !new File(sourcesPath).exists() ? "does not exist" : (new File(sourcesPath).isDirectory() ? "existed directory" : "it is regular file");
                throw new IllegalStateException(("Failed to find directory with source files: " + sourcesPath + " (" + status + ")").toString());
            }
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
            rootsModel = modifiableRootModel;
            ContentEntry[] contentEntryArray = rootsModel.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
            for (Object object2 : (Object[])contentEntryArray) {
                ContentEntry it = (ContentEntry)object2;
                boolean bl = false;
                VirtualFile contentEntryFile = it.getFile();
                if (!(contentEntryFile != null && VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)sourcesRoot, (boolean)false))) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        ContentEntry contentEntry = (ContentEntry)object;
        if (contentEntry == null) {
            throw new IllegalStateException(("Failed to find content entry for file: " + sourcesRoot.getName()).toString());
        }
        ContentEntry contentEntry2 = contentEntry;
        contentEntry2.addSourceFolder(sourcesRoot, false);
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>((Object)rootsModel){

            public final void invoke() {
                ((ModifiableRootModel)this.receiver).commit();
            }
        }));
        project.save();
    }

    public final void restoreProject(@NotNull LangSupport languageSupport, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)languageSupport, (String)"languageSupport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableFuture done = new CompletableFuture();
        AppUIExecutor.onWriteThread().withDocumentsCommitted(project).submit(() -> ProjectUtils.restoreProject$lambda$7(project, languageSupport, done));
        Boolean success = (Boolean)done.get();
        if (!success.booleanValue()) {
            ProjectUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProjectUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("IFT Learning project files refresh failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isEmptyDir(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Closeable closeable = Files.newDirectoryStream(path);
            Throwable throwable = null;
            try {
                DirectoryStream directory = (DirectoryStream)closeable;
                boolean bl = false;
                boolean bl2 = !directory.iterator().hasNext();
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return false;
    }

    private static final void chooseParentDirectoryForLearningProject$lambda$1(Ref.ObjectRef $result, List it) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.element = it;
    }

    private static final boolean restoreProject$lambda$7$lambda$6(List $needReplace, List $validContent, Ref.BooleanRef $modified, File it) {
        Intrinsics.checkNotNullParameter((Object)$needReplace, (String)"$needReplace");
        Intrinsics.checkNotNullParameter((Object)$validContent, (String)"$validContent");
        Intrinsics.checkNotNullParameter((Object)$modified, (String)"$modified");
        Path path = it.toPath();
        boolean needCopy = $needReplace.contains(path) || !$validContent.contains(path);
        $modified.element = needCopy || $modified.element;
        return needCopy;
    }

    private static final void restoreProject$lambda$7(Project $project, LangSupport $languageSupport, CompletableFuture $done) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$languageSupport, (String)"$languageSupport");
        Intrinsics.checkNotNullParameter((Object)$done, (String)"$done");
        try {
            String string = PropertiesComponent.getInstance((Project)$project).getValue(LEARNING_PROJECT_MODIFICATION);
            long stamp = string != null ? Long.parseLong(string) : 0L;
            List needReplace = new ArrayList();
            List validContent = new ArrayList();
            List directories = new ArrayList();
            VirtualFile root = INSTANCE.getProjectRoot($languageSupport);
            Path path = root.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path contentRootPath = $languageSupport.getContentRootPath(path);
            Iterator iterator = Files.walk(contentRootPath, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Path path2;
                block11: {
                    path2 = (Path)iterator.next();
                    Path path3 = contentRootPath.relativize(path2);
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"relativize(...)");
                    Iterable $this$any$iv = path3;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Path file = (Path)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)file);
                            boolean bl3 = Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)".idea") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"git") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)".git") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)".gitignore") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"venv") || Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)FEATURE_TRAINER_VERSION) || StringsKt.endsWith$default((String)PathsKt.getName((Path)file), (String)".iml", (boolean)false, (int)2, null);
                            if (!bl3) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                Intrinsics.checkNotNull((Object)path2);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    directories.add(path2);
                    continue;
                }
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(this, *options)");
                if (fileTime.toMillis() > stamp) {
                    needReplace.add(path2);
                    continue;
                }
                validContent.add(path2);
            }
            Ref.BooleanRef modified = new Ref.BooleanRef();
            for (Path path4 : needReplace) {
                PathKt.delete$default((Path)path4, (boolean)false, (int)1, null);
                modified.element = true;
            }
            File contentRoodDirectory = contentRootPath.toFile();
            Intrinsics.checkNotNull((Object)contentRoodDirectory);
            $languageSupport.copyLearningProjectFiles(contentRoodDirectory, arg_0 -> ProjectUtils.restoreProject$lambda$7$lambda$6(needReplace, validContent, modified, arg_0));
            for (Path path5 : directories) {
                if (!INSTANCE.isEmptyDir(path5)) continue;
                modified.element = true;
                PathKt.delete$default((Path)path5, (boolean)false, (int)1, null);
            }
            if (modified.element) {
                PropertiesComponent.getInstance((Project)$project).setValue(LEARNING_PROJECT_MODIFICATION, String.valueOf(System.currentTimeMillis()));
            }
            $done.complete(true);
        }
        catch (Exception e) {
            $done.complete(false);
            throw e;
        }
    }

    public static final /* synthetic */ Path access$chooseParentDirectoryForLearningProject(ProjectUtils $this, LangSupport langSupport2) {
        return $this.chooseParentDirectoryForLearningProject(langSupport2);
    }

    public static final /* synthetic */ void access$updateLearningModificationTimestamp(ProjectUtils $this, Project it) {
        $this.updateLearningModificationTimestamp(it);
    }

    public static final /* synthetic */ Path access$getLearningInstallationContentRoot(ProjectUtils $this, LangSupport langSupport2) {
        return $this.getLearningInstallationContentRoot(langSupport2);
    }

    public static final /* synthetic */ boolean access$isSameVersion(ProjectUtils $this, Path versionFile) {
        return $this.isSameVersion(versionFile);
    }

    public static final /* synthetic */ Path access$versionFile(ProjectUtils $this, Path dest) {
        return $this.versionFile(dest);
    }

    public static final /* synthetic */ void access$openOrImportLearningProject(ProjectUtils $this, Path contentRoot, OpenProjectTask openProjectTask, LangSupport langSupport2, Function1 postInitCallback) {
        $this.openOrImportLearningProject(contentRoot, openProjectTask, langSupport2, (Function1<? super Project, Unit>)postInitCallback);
    }
}

