/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.ide.ui.text.ActionKeyPopupKt;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.CodeTextPart;
import com.intellij.ide.ui.text.parts.IconTextPart;
import com.intellij.ide.ui.text.parts.IllustrationTextPart;
import com.intellij.ide.ui.text.parts.LinkTextPart;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.ShortcutTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.GotItTextBuilder;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonUtil;
import training.learn.LearnBundle;
import training.statistic.StatisticBase;
import training.ui.LearningUiManager;
import training.ui.MessageFactory;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u00120\u0010\u00a2\u0006\u0002\b\u00132\b\b\u0001\u0010\u0014\u001a\u00020\nJ\u0012\u0010\u0015\u001a\u00020\u000e2\b\b\u0001\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltraining/ui/MessageFactory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "convert", "", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "text", "", "convertParagraph", "Lcom/intellij/ide/ui/text/parts/TextPart;", "element", "Lorg/jdom/Element;", "convertToGotItFormat", "Lkotlin/Function1;", "Lcom/intellij/ui/GotItTextBuilder;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/ExtensionFunctionType;", "htmlText", "parseXml", "IftShortcutTextPart", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nMessageFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageFactory.kt\ntraining/ui/MessageFactory\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,203:1\n151#2,6:204\n*S KotlinDebug\n*F\n+ 1 MessageFactory.kt\ntraining/ui/MessageFactory\n*L\n56#1:204,6\n*E\n"})
public final class MessageFactory {
    @NotNull
    public static final MessageFactory INSTANCE = new MessageFactory();
    @NotNull
    private static final Logger LOG;

    private MessageFactory() {
    }

    @NotNull
    public final List<TextParagraph> convert(@Language(value="HTML") @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String[] stringArray = new String[]{"\n"};
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)convert.1.INSTANCE));
    }

    private final Element parseXml(@Language(value="HTML") String text2) {
        String wrappedText;
        String string = wrappedText = "<root>" + text2 + "</root>";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Element element = JDOMUtil.load((InputStream)new ByteArrayInputStream(byArray));
        if (element == null) {
            throw new IllegalStateException(("Can't parse as XML:\n" + text2).toString());
        }
        return element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<TextPart> convertParagraph(Element element) {
        List list2 = new ArrayList();
        for (Content content : element.getContent()) {
            if (content instanceof Text) {
                Object text2 = content.getValue();
                if (Pattern.matches(" *\\p{IsPunctuation}.*", (CharSequence)text2)) {
                    int n;
                    CharSequence $this$indexOfFirst$iv;
                    block45: {
                        String string = text2;
                        Intrinsics.checkNotNull((Object)string);
                        $this$indexOfFirst$iv = string;
                        boolean $i$f$indexOfFirst = false;
                        int n2 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n2; ++index$iv) {
                            char it = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl = false;
                            if (!(it != ' ')) continue;
                            n = index$iv;
                            break block45;
                        }
                        n = -1;
                    }
                    int indexOfFirst = n;
                    String string = StringsKt.repeat((CharSequence)"\u00a0", (int)indexOfFirst);
                    $this$indexOfFirst$iv = text2;
                    Intrinsics.checkNotNull((Object)$this$indexOfFirst$iv);
                    String string2 = ((String)$this$indexOfFirst$iv).substring(indexOfFirst);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    text2 = string + string2;
                }
                String indexOfFirst = text2;
                Intrinsics.checkNotNull((Object)indexOfFirst);
                list2.add(new RegularTextPart(indexOfFirst, false, 2, null));
                continue;
            }
            if (!(content instanceof Element)) continue;
            XMLOutputter outputter = new XMLOutputter();
            Intrinsics.checkNotNullExpressionValue((Object)Strings.unescapeXmlEntities((String)outputter.outputString(((Element)content).getContent())), (String)"unescapeXmlEntities(...)");
            String string = ((Element)content).getName();
            if (string == null) throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
            int n = -1;
            switch (string.hashCode()) {
                case 97: {
                    if (string.equals("a")) {
                        n = 1;
                    }
                    break;
                }
                case -891980137: {
                    if (string.equals("strong")) {
                        n = 2;
                    }
                    break;
                }
                case 3059181: {
                    if (string.equals("code")) {
                        n = 3;
                    }
                    break;
                }
                case -342500282: {
                    if (string.equals("shortcut")) {
                        n = 4;
                    }
                    break;
                }
                case 3226745: {
                    if (string.equals("icon")) {
                        n = 5;
                    }
                    break;
                }
                case -172220347: {
                    if (string.equals("callback")) {
                        n = 6;
                    }
                    break;
                }
                case -1422950858: {
                    if (string.equals("action")) {
                        n = 7;
                    }
                    break;
                }
                case 891970896: {
                    if (string.equals("illustration")) {
                        n = 8;
                    }
                    break;
                }
                case 104106: {
                    if (string.equals("ide")) {
                        n = 9;
                    }
                    break;
                }
                case -737600009: {
                    if (string.equals("icon_idx")) {
                        n = 10;
                    }
                    break;
                }
                case 1457652349: {
                    if (string.equals("raw_shortcut")) {
                        n = 11;
                    }
                    break;
                }
            }
            TextPart newPart2 = switch (n) {
                case 5 -> throw new IllegalStateException("Need to return reflection-based icon processing".toString());
                case 10 -> {
                    Icon icon;
                    String text;
                    if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)text) == null) {
                        throw new IllegalStateException(("Not found icon with id: " + text).toString());
                    }
                    yield (TextPart)new IconTextPart(icon);
                }
                case 8 -> {
                    Icon icon;
                    String text;
                    if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)text) == null) {
                        throw new IllegalStateException(("Not found icon with id: " + text).toString());
                    }
                    yield (TextPart)new IllustrationTextPart(icon);
                }
                case 2 -> {
                    String text;
                    yield (TextPart)new RegularTextPart(text, true);
                }
                case 3 -> {
                    String text;
                    yield (TextPart)new CodeTextPart(text);
                }
                case 6 -> {
                    String text;
                    String id = ((Element)content).getAttributeValue("id");
                    if (id == null) throw new IllegalStateException(("'callback' tag with text '" + text + "' should contain 'id' attribute").toString());
                    Function0<Unit> callback = LearningUiManager.INSTANCE.getAndClearCallback(id);
                    if (callback == null) {
                        throw new IllegalStateException(("Unknown callback with id '" + id + "' and text '" + text + "'").toString());
                    }
                    yield (TextPart)new LinkTextPart(text, callback);
                }
                case 1 -> {
                    String text;
                    String var10_18 = ((Element)content).getAttributeValue("href");
                    if (var10_18 == null) {
                        throw new IllegalStateException(("'a' tag with text '" + text + "' should contain 'href' attribute").toString());
                    }
                    String link = var10_18;
                    yield (TextPart)new LinkTextPart(text, (Function0)new Function0<Unit>(link){
                        final /* synthetic */ String $link;
                        {
                            this.$link = $link;
                            super(0);
                        }

                        public final void invoke() {
                            try {
                                UtilsKt.openLinkInBrowser(this.$link);
                            }
                            catch (Exception ex) {
                                MessageFactory.access$getLOG$p().warn((Throwable)ex);
                            }
                        }
                    });
                }
                case 7 -> {
                    String text;
                    yield (TextPart)new IftShortcutTextPart(text, false);
                }
                case 4 -> {
                    String text;
                    yield (TextPart)new IftShortcutTextPart(text, true);
                }
                case 11 -> {
                    String text;
                    yield (TextPart)new IftShortcutTextPart(text, true);
                }
                case 9 -> (TextPart)new RegularTextPart(LessonUtil.INSTANCE.getProductName(), false, 2, null);
                default -> throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
            };
            list2.add(newPart2);
        }
        return list2;
    }

    @NotNull
    public final Function1<GotItTextBuilder, String> convertToGotItFormat(@Language(value="HTML") @NotNull String htmlText) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        return (Function1)new Function1<GotItTextBuilder, String>(htmlText){
            final /* synthetic */ String $htmlText;
            {
                this.$htmlText = $htmlText;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final String invoke(@NotNull GotItTextBuilder $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                if (StringsKt.contains$default((CharSequence)this.$htmlText, (char)'\n', (boolean)false, (int)2, null)) {
                    throw new IllegalStateException(("GotIt tooltip can contain only single paragraph, provided text:\n" + this.$htmlText).toString());
                }
                String spaces = "\u00a0\u00a0";
                String adjustedText = StringsKt.replace$default((String)StringsKt.replace$default((String)this.$htmlText, (String)(spaces + "<"), (String)"<", (boolean)false, (int)4, null), (String)(">" + spaces), (String)">", (boolean)false, (int)4, null);
                Element element = MessageFactory.access$parseXml(MessageFactory.INSTANCE, adjustedText);
                StringBuilder builder = new StringBuilder();
                for (Content content : element.getContent()) {
                    String string;
                    Object text2;
                    if (content instanceof Text) {
                        text2 = content.getValue();
                        if (Pattern.matches(" *\\p{IsPunctuation}.*", (CharSequence)text2)) {
                            int n;
                            block45: {
                                string = text2;
                                Intrinsics.checkNotNull((Object)string);
                                CharSequence $this$indexOfFirst$iv = string;
                                boolean $i$f$indexOfFirst = false;
                                int n2 = $this$indexOfFirst$iv.length();
                                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                                    boolean bl = false;
                                    if (!(it != ' ')) continue;
                                    n = index$iv;
                                    break block45;
                                }
                                n = -1;
                            }
                            int indexOfFirst = n;
                            String string2 = StringsKt.repeat((CharSequence)"\u00a0", (int)indexOfFirst);
                            string = text2;
                            Intrinsics.checkNotNull((Object)string);
                            String string3 = string.substring(indexOfFirst);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                            text2 = string2 + string3;
                        }
                        builder.append((String)text2);
                        continue;
                    }
                    if (!(content instanceof Element)) continue;
                    text2 = new XMLOutputter().outputString(((Element)content).getContent());
                    string = ((Element)content).getName();
                    if (string == null) throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
                    int n = -1;
                    switch (string.hashCode()) {
                        case 97: {
                            if (string.equals("a")) {
                                n = 1;
                            }
                            break;
                        }
                        case -891980137: {
                            if (string.equals("strong")) {
                                n = 2;
                            }
                            break;
                        }
                        case 3059181: {
                            if (string.equals("code")) {
                                n = 3;
                            }
                            break;
                        }
                        case -342500282: {
                            if (string.equals("shortcut")) {
                                n = 4;
                            }
                            break;
                        }
                        case 3226745: {
                            if (string.equals("icon")) {
                                n = 5;
                            }
                            break;
                        }
                        case -172220347: {
                            if (string.equals("callback")) {
                                n = 6;
                            }
                            break;
                        }
                        case -1422950858: {
                            if (string.equals("action")) {
                                n = 7;
                            }
                            break;
                        }
                        case 891970896: {
                            if (string.equals("illustration")) {
                                n = 8;
                            }
                            break;
                        }
                        case 104106: {
                            if (string.equals("ide")) {
                                n = 9;
                            }
                            break;
                        }
                        case -737600009: {
                            if (string.equals("icon_idx")) {
                                n = 10;
                            }
                            break;
                        }
                        case 1457652349: {
                            if (string.equals("raw_shortcut")) {
                                n = 11;
                            }
                            break;
                        }
                    }
                    Object textToAppend = switch (n) {
                        case 2 -> "<b>" + (String)text2 + "</b>";
                        case 10 -> {
                            Icon icon;
                            if ((Icon)LearningUiManager.INSTANCE.getIconMap().get(text2) == null) {
                                throw new IllegalStateException(("Not found icon with id: " + (String)text2).toString());
                            }
                            yield $this$null.icon(icon);
                        }
                        case 6 -> {
                            String id = ((Element)content).getAttributeValue("id");
                            if (id == null) throw new IllegalStateException(("'callback' tag with text '" + (String)text2 + "' should contain 'id' attribute").toString());
                            Function0<Unit> callback = LearningUiManager.INSTANCE.getAndClearCallback(id);
                            if (callback == null) throw new IllegalStateException(("Unknown callback with id '" + id + "' and text '" + (String)text2 + "'").toString());
                            Intrinsics.checkNotNull((Object)text2);
                            yield $this$null.link((String)text2, callback);
                        }
                        case 1 -> {
                            String var12_19 = ((Element)content).getAttributeValue("href");
                            if (var12_19 == null) {
                                throw new IllegalStateException(("'a' tag with text '" + (String)text2 + "' should contain 'href' attribute").toString());
                            }
                            String link = var12_19;
                            Intrinsics.checkNotNull((Object)text2);
                            yield $this$null.browserLink((String)text2, new URL(link));
                        }
                        case 7 -> {
                            Intrinsics.checkNotNull((Object)text2);
                            yield $this$null.shortcut((String)text2);
                        }
                        case 11 -> {
                            KeyStroke keyStroke;
                            if (KeyStroke.getKeyStroke((String)text2) == null) {
                                throw new IllegalStateException(("Failed to parse key stroke, element: " + element).toString());
                            }
                            yield $this$null.shortcut(keyStroke);
                        }
                        case 3 -> {
                            Intrinsics.checkNotNull((Object)text2);
                            yield $this$null.code((String)text2);
                        }
                        case 9 -> LessonUtil.INSTANCE.getProductName();
                        case 5 -> throw new IllegalStateException("Need to return reflection-based icon processing".toString());
                        case 8 -> throw new IllegalStateException("Illustrations are not supported in Features Trainer GotIt tooltips for now".toString());
                        case 4 -> throw new IllegalStateException(("Use 'raw_shortcut' with providing key stroke instead, element: " + element).toString());
                        default -> throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
                    };
                    builder.append((String)textToAppend);
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        };
    }

    public static final /* synthetic */ Element access$parseXml(MessageFactory $this, String text2) {
        return $this.parseXml(text2);
    }

    public static final /* synthetic */ List access$convertParagraph(MessageFactory $this, Element element) {
        return $this.convertParagraph(element);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(MessageFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002R=\u0010\u0007\u001a+\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ltraining/ui/MessageFactory$IftShortcutTextPart;", "Lcom/intellij/ide/ui/text/parts/ShortcutTextPart;", "text", "", "isRaw", "", "(Ljava/lang/String;Z)V", "onClickAction", "Lkotlin/Function3;", "Ljavax/swing/JTextPane;", "Ljava/awt/Point;", "", "Lkotlin/ParameterName;", "name", "height", "", "getOnClickAction", "()Lkotlin/jvm/functions/Function3;", "showActionKeyPopupExtended", "textPane", "point", "actionId", "intellij.featuresTrainer"})
    private static final class IftShortcutTextPart
    extends ShortcutTextPart {
        public IftShortcutTextPart(@NotNull String text2, boolean isRaw) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(text2, isRaw);
        }

        @Nullable
        public Function3<JTextPane, Point, Integer, Unit> getOnClickAction() {
            return !this.isRaw() ? (Function3)new Function3<JTextPane, Point, Integer, Unit>(this){
                final /* synthetic */ IftShortcutTextPart this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(@NotNull JTextPane textPane, @NotNull Point point, int height) {
                    Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
                    Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                    String actionId = this.this$0.getText();
                    IftShortcutTextPart.access$showActionKeyPopupExtended(this.this$0, textPane, point, height, actionId);
                    StatisticBase.Companion.logShortcutClicked(actionId);
                }
            } : null;
        }

        private final void showActionKeyPopupExtended(JTextPane textPane, Point point, int height, String actionId) {
            ActionKeyPopupKt.showActionKeyPopup((Component)textPane, (Point)point, (int)height, (String)actionId, (Function1)((Function1)new Function1<JPanel, Unit>(actionId){
                final /* synthetic */ String $actionId;
                {
                    this.$actionId = $actionId;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull JPanel panel) {
                    void it;
                    ActionLink actionLink;
                    Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                    ActionLink actionLink2 = actionLink = new ActionLink(LearnBundle.INSTANCE.message("shortcut.balloon.apply.this.action", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$actionId){
                        final /* synthetic */ String $actionId;
                        {
                            this.$actionId = $actionId;
                            super(1);
                        }

                        public final void invoke(@NotNull ActionEvent it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            AnAction action2 = ActionManager.getInstance().getAction(this.$actionId);
                            Intrinsics.checkNotNull((Object)action2);
                            UtilsKt.invokeActionForFocusContext(action2);
                        }
                    });
                    JPanel jPanel = panel;
                    boolean bl = false;
                    it.setForeground((Color)JBColor.namedColor((String)"ToolTip.linkForeground", (Color)JBUI.CurrentTheme.Link.Foreground.ENABLED));
                    jPanel.add((Component)actionLink);
                }
            }));
        }

        public static final /* synthetic */ void access$showActionKeyPopupExtended(IftShortcutTextPart $this, JTextPane textPane, Point point, int height, String actionId) {
            $this.showActionKeyPopupExtended(textPane, point, height, actionId);
        }
    }
}

