/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenConfigOpenQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J \u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenConfigBuildIssue;", "", "()V", "CONFIG_PARSE_ERROR", "", "CONFIG_VALUE_ERROR", "getConfigFile", "Lcom/intellij/build/issue/BuildIssue;", "configFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "errorMessage", "title", "getIssue", "project", "Lcom/intellij/openapi/project/Project;", "ex", "Lorg/jetbrains/idea/maven/server/MavenConfigParseException;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenBadConfigEventParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenBadConfigEventParser.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenConfigBuildIssue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class MavenConfigBuildIssue {
    @NotNull
    public static final MavenConfigBuildIssue INSTANCE = new MavenConfigBuildIssue();
    @NotNull
    public static final String CONFIG_PARSE_ERROR = "Unable to parse maven.config:";
    @NotNull
    public static final String CONFIG_VALUE_ERROR = "For input string:";

    private MavenConfigBuildIssue() {
    }

    @Nullable
    public final BuildIssue getIssue(@NotNull MavenConfigParseException ex) {
        BuildIssue buildIssue;
        VirtualFile configFile;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(ex.getDirectory());
        VirtualFile virtualFile2 = configFile = virtualFile != null ? virtualFile.findFileByRelativePath("/.mvn/maven.config") : null;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            String string = ex.getLocalizedMessage();
            if (string == null && (string = ex.getMessage()) == null) {
                string = ExceptionsKt.stackTraceToString((Throwable)((Throwable)ex));
            }
            buildIssue = INSTANCE.getConfigFile(it, string, CONFIG_PARSE_ERROR);
        } else {
            buildIssue = null;
        }
        return buildIssue;
    }

    @Nullable
    public final BuildIssue getIssue(@NotNull String title, @NotNull String errorMessage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<MavenProject> list = MavenProjectsManager.getInstance(project2).getRootProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
        MavenProject mavenProject2 = (MavenProject)CollectionsKt.firstOrNull(list);
        if (mavenProject2 == null) {
            MavenLog.LOG.warn("Cannot find appropriate maven project,project =  " + project2.getName());
            return null;
        }
        VirtualFile configFile = MavenUtil.getConfigFile(mavenProject2, "/.mvn/maven.config");
        if (configFile == null) {
            return null;
        }
        return this.getConfigFile(configFile, errorMessage, title);
    }

    private final BuildIssue getConfigFile(VirtualFile configFile, String errorMessage, String title) {
        MavenConfigOpenQuickFix mavenConfigOpenQuickFix = new MavenConfigOpenQuickFix(configFile, errorMessage);
        List quickFixes = CollectionsKt.listOf((Object)mavenConfigOpenQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        Object[] objectArray = new Object[]{mavenConfigOpenQuickFix.getId()};
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.maven.config.file", objectArray));
        return new BuildIssue(title, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $title;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        };
    }
}

