/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.internal.ReadStatisticsCollector;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenBuildBase;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenModelBase;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProfileActivation;
import org.jetbrains.idea.maven.model.MavenProfileActivationFile;
import org.jetbrains.idea.maven.model.MavenProfileActivationOS;
import org.jetbrains.idea.maven.model.MavenProfileActivationProperty;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectModelReadHelper;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectResolutionUtil;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenReadProjectCache;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenProjectReader {
    private static final String UNKNOWN = "Unknown";
    private MavenReadProjectCache myCache;
    private final Project myProject;
    private final MavenProjectModelReadHelper myReadHelper;
    private SettingsProfilesCache mySettingsProfilesCache;

    public MavenProjectReader(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectReader.$$$reportNull$$$0(0);
        }
        this.myCache = new MavenReadProjectCache();
        this.myProject = project2;
        this.myReadHelper = MavenUtil.createModelReadHelper(project2);
    }

    @NotNull
    public MavenProjectReaderResult readProject(MavenGeneralSettings generalSettings, VirtualFile file, MavenExplicitProfiles explicitProfiles, MavenProjectReaderProjectLocator locator) {
        Path basedir = MavenUtil.getBaseDir(file);
        Pair<RawModelReadResult, MavenExplicitProfiles> readResult = this.doReadProjectModel(generalSettings, basedir, file, explicitProfiles, new HashSet<VirtualFile>(), locator);
        MavenModel model = this.myReadHelper.interpolate(basedir, file, ((RawModelReadResult)readResult.first).model);
        HashMap<String, String> modelMap = new HashMap<String, String>();
        modelMap.put("groupId", model.getMavenId().getGroupId());
        modelMap.put("artifactId", model.getMavenId().getArtifactId());
        modelMap.put("version", model.getMavenId().getVersion());
        modelMap.put("build.outputDirectory", model.getBuild().getOutputDirectory());
        modelMap.put("build.testOutputDirectory", model.getBuild().getTestOutputDirectory());
        modelMap.put("build.finalName", model.getBuild().getFinalName());
        modelMap.put("build.directory", model.getBuild().getDirectory());
        return new MavenProjectReaderResult(model, modelMap, (MavenExplicitProfiles)readResult.second, null, ((RawModelReadResult)readResult.first).problems, new HashSet<MavenId>());
    }

    private Pair<RawModelReadResult, MavenExplicitProfiles> doReadProjectModel(MavenGeneralSettings generalSettings, Path projectPomDir, VirtualFile file, MavenExplicitProfiles explicitProfiles, Set<VirtualFile> recursionGuard, MavenProjectReaderProjectLocator locator) {
        RawModelReadResult cachedModel = this.myCache.get(file);
        if (cachedModel == null) {
            cachedModel = MavenProjectReader.doReadProjectModel(this.myProject, file, false);
            this.myCache.put(file, cachedModel);
        }
        MavenModel model = cachedModel.model;
        Set<String> alwaysOnProfiles = cachedModel.alwaysOnProfiles;
        Collection<MavenProjectProblem> problems = cachedModel.problems;
        model = this.resolveInheritance(generalSettings, model, projectPomDir, file, explicitProfiles, recursionGuard, locator, problems);
        this.addSettingsProfiles(generalSettings, model, alwaysOnProfiles, problems);
        ProfileApplicationResult applied = this.applyProfiles(model, projectPomDir, MavenUtil.getBaseDir(file), explicitProfiles, alwaysOnProfiles);
        model = applied.getModel();
        MavenProjectReader.repairModelBody(model);
        return Pair.create((Object)new RawModelReadResult(model, problems, alwaysOnProfiles), (Object)applied.getActivatedProfiles());
    }

    private static RawModelReadResult doReadProjectModel(Project project2, VirtualFile file, boolean headerOnly) {
        MavenModel result2 = null;
        Collection problems = MavenProjectProblem.createProblemsList();
        HashSet<String> alwaysOnProfiles = new HashSet<String>();
        String fileExtension = file.getExtension();
        if (!"pom".equalsIgnoreCase(fileExtension) && !"xml".equalsIgnoreCase(fileExtension)) {
            return MavenProjectReader.readProjectModelUsingMavenServer(project2, file, result2, problems, alwaysOnProfiles);
        }
        return MavenProjectReader.readMavenProjectModel(file, headerOnly, problems, alwaysOnProfiles, MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(file, project2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static RawModelReadResult readProjectModelUsingMavenServer(Project project2, VirtualFile file, MavenModel result2, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles) {
        String basedir = MavenUtil.getBaseDir(file).toString();
        MavenEmbeddersManager manager = MavenProjectsManager.getInstance(project2).getEmbeddersManager();
        MavenEmbedderWrapper embedder = manager.getEmbedder(MavenEmbeddersManager.FOR_MODEL_READ, basedir);
        try {
            result2 = embedder.readModel(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        catch (MavenProcessCanceledException mavenProcessCanceledException) {
        }
        finally {
            manager.release(embedder);
        }
        if (result2 == null) {
            result2 = new MavenModel();
            result2.setPackaging("jar");
        }
        return new RawModelReadResult(result2, problems, alwaysOnProfiles);
    }

    @NotNull
    private static RawModelReadResult readMavenProjectModel(VirtualFile file, boolean headerOnly, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles, boolean isAutomaticVersionFeatureEnabled) {
        MavenParent parent;
        MavenModel result2 = new MavenModel();
        Element xmlProject = MavenProjectReader.readXml(file, problems, MavenProjectProblem.ProblemType.SYNTAX);
        if (xmlProject == null || !"project".equals(xmlProject.getName())) {
            result2.setPackaging("jar");
            return new RawModelReadResult(result2, problems, alwaysOnProfiles);
        }
        if (MavenJDOMUtil.hasChildByPath(xmlProject, "parent")) {
            parent = new MavenParent(new MavenId(MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.groupId", UNKNOWN), MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.artifactId", UNKNOWN), MavenProjectReader.calculateParentVersion(xmlProject, problems, file, isAutomaticVersionFeatureEnabled)), MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.relativePath", "../pom.xml"));
            result2.setParent(parent);
        } else {
            parent = new MavenParent(new MavenId(UNKNOWN, UNKNOWN, UNKNOWN), "../pom.xml");
        }
        result2.setMavenId(new MavenId(MavenJDOMUtil.findChildValueByPath(xmlProject, "groupId", parent.getMavenId().getGroupId()), MavenJDOMUtil.findChildValueByPath(xmlProject, "artifactId", UNKNOWN), MavenJDOMUtil.findChildValueByPath(xmlProject, "version", parent.getMavenId().getVersion())));
        if (headerOnly) {
            return new RawModelReadResult(result2, problems, alwaysOnProfiles);
        }
        result2.setPackaging(MavenJDOMUtil.findChildValueByPath(xmlProject, "packaging", "jar"));
        result2.setName(MavenJDOMUtil.findChildValueByPath(xmlProject, "name"));
        MavenProjectReader.readModelBody((MavenModelBase)result2, (MavenBuildBase)result2.getBuild(), xmlProject);
        result2.setProfiles(MavenProjectReader.collectProfiles(file, xmlProject, problems, alwaysOnProfiles));
        return new RawModelReadResult(result2, problems, alwaysOnProfiles);
    }

    @NotNull
    private static String calculateParentVersion(Element xmlProject, Collection<MavenProjectProblem> problems, VirtualFile file, boolean isAutomaticVersionFeatureEnabled) {
        String version2 = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.version");
        if (version2 != null || !isAutomaticVersionFeatureEnabled) {
            String string = StringUtil.notNullize((String)version2, (String)UNKNOWN);
            if (string == null) {
                MavenProjectReader.$$$reportNull$$$0(1);
            }
            return string;
        }
        String parentGroupId = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.groupId");
        String parentArtifactId = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.artifactId");
        if (parentGroupId == null || parentArtifactId == null) {
            problems.add(new MavenProjectProblem(file.getPath(), MavenProjectBundle.message("consumer.pom.cannot.determine.parent.version", new Object[0]), MavenProjectProblem.ProblemType.STRUCTURE, false));
            return UNKNOWN;
        }
        String relativePath = MavenJDOMUtil.findChildValueByPath(xmlProject, "parent.relativePath", "../pom.xml");
        VirtualFile parentFile = file.getParent().findFileByRelativePath(relativePath);
        if (parentFile == null) {
            problems.add(new MavenProjectProblem(file.getPath(), MavenProjectBundle.message("consumer.pom.cannot.determine.parent.version", new Object[0]), MavenProjectProblem.ProblemType.STRUCTURE, false));
            return UNKNOWN;
        }
        Element parentXmlProject = MavenProjectReader.readXml(parentFile, problems, MavenProjectProblem.ProblemType.SYNTAX);
        version2 = MavenJDOMUtil.findChildValueByPath(parentXmlProject, "version");
        if (version2 != null) {
            String string = version2;
            if (string == null) {
                MavenProjectReader.$$$reportNull$$$0(2);
            }
            return string;
        }
        return MavenProjectReader.calculateParentVersion(parentXmlProject, problems, parentFile, isAutomaticVersionFeatureEnabled);
    }

    private static void repairModelBody(MavenModel model) {
        MavenBuild build = model.getBuild();
        if (StringUtil.isEmptyOrSpaces((String)build.getFinalName())) {
            build.setFinalName("${project.artifactId}-${project.version}");
        }
        if (build.getSources().isEmpty()) {
            build.addSource("src/main/java");
        }
        if (build.getTestSources().isEmpty()) {
            build.addTestSource("src/test/java");
        }
        build.setResources(MavenProjectReader.repairResources(build.getResources(), "src/main/resources"));
        build.setTestResources(MavenProjectReader.repairResources(build.getTestResources(), "src/test/resources"));
        build.setDirectory(StringUtil.isEmptyOrSpaces((String)build.getDirectory()) ? "target" : build.getDirectory());
        build.setOutputDirectory(StringUtil.isEmptyOrSpaces((String)build.getOutputDirectory()) ? "${project.build.directory}/classes" : build.getOutputDirectory());
        build.setTestOutputDirectory(StringUtil.isEmptyOrSpaces((String)build.getTestOutputDirectory()) ? "${project.build.directory}/test-classes" : build.getTestOutputDirectory());
    }

    private static List<MavenResource> repairResources(List<MavenResource> resources, @NotNull String defaultDir) {
        if (defaultDir == null) {
            MavenProjectReader.$$$reportNull$$$0(3);
        }
        ArrayList<MavenResource> result2 = new ArrayList<MavenResource>();
        if (resources.isEmpty()) {
            result2.add(MavenProjectReader.createResource(defaultDir));
            return result2;
        }
        for (MavenResource each : resources) {
            if (StringUtil.isEmptyOrSpaces((String)each.getDirectory())) continue;
            result2.add(each);
        }
        return result2;
    }

    private static MavenResource createResource(@NotNull String directory) {
        if (directory == null) {
            MavenProjectReader.$$$reportNull$$$0(4);
        }
        return new MavenResource(directory, false, null, Collections.emptyList(), Collections.emptyList());
    }

    private static List<MavenProfile> collectProfiles(VirtualFile projectFile, Element xmlProject, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles) {
        ArrayList<MavenProfile> result2 = new ArrayList<MavenProfile>();
        MavenProjectReader.collectProfiles(MavenJDOMUtil.findChildrenByPath(xmlProject, "profiles", "profile"), result2, "pom");
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile != null) {
            MavenProjectReader.collectProfilesFromSettingsXmlOrProfilesXml(profilesFile, "profilesXml", true, "profiles.xml", result2, alwaysOnProfiles, problems);
        }
        return result2;
    }

    private void addSettingsProfiles(MavenGeneralSettings generalSettings, MavenModel model, Set<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
        if (this.mySettingsProfilesCache == null) {
            ArrayList<MavenProfile> settingsProfiles = new ArrayList<MavenProfile>();
            Collection settingsProblems = MavenProjectProblem.createProblemsList();
            HashSet<String> settingsAlwaysOnProfiles = new HashSet<String>();
            for (VirtualFile each : generalSettings.getEffectiveSettingsFiles()) {
                MavenProjectReader.collectProfilesFromSettingsXmlOrProfilesXml(each, "settings", false, "settings.xml", settingsProfiles, settingsAlwaysOnProfiles, settingsProblems);
            }
            this.mySettingsProfilesCache = new SettingsProfilesCache(settingsProfiles, settingsAlwaysOnProfiles, settingsProblems);
        }
        ArrayList<MavenProfile> modelProfiles = new ArrayList<MavenProfile>(model.getProfiles());
        for (MavenProfile each : this.mySettingsProfilesCache.profiles) {
            MavenProjectReader.addProfileIfDoesNotExist(each, modelProfiles);
        }
        model.setProfiles(modelProfiles);
        problems.addAll(this.mySettingsProfilesCache.problems);
        alwaysOnProfiles.addAll(this.mySettingsProfilesCache.alwaysOnProfiles);
    }

    private static void collectProfilesFromSettingsXmlOrProfilesXml(VirtualFile profilesFile, String rootElementName, boolean wrapRootIfNecessary, String profilesSource, List<MavenProfile> result2, Set<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
        Element rootElement = MavenProjectReader.readXml(profilesFile, problems, MavenProjectProblem.ProblemType.SETTINGS_OR_PROFILES);
        if (rootElement == null) {
            return;
        }
        if (wrapRootIfNecessary && !rootElementName.equals(rootElement.getName())) {
            Element wrapper = new Element(rootElementName);
            wrapper.addContent(rootElement);
            rootElement = wrapper;
        }
        List<Element> xmlProfiles = MavenJDOMUtil.findChildrenByPath(rootElement, "profiles", "profile");
        MavenProjectReader.collectProfiles(xmlProfiles, result2, profilesSource);
        alwaysOnProfiles.addAll(MavenJDOMUtil.findChildrenValuesByPath(rootElement, "activeProfiles", "activeProfile"));
    }

    private static void collectProfiles(List<Element> xmlProfiles, List<MavenProfile> result2, String source) {
        for (Element each : xmlProfiles) {
            MavenProfile profile;
            String id = MavenJDOMUtil.findChildValueByPath(each, "id");
            if (StringUtil.isEmptyOrSpaces((String)id) || !MavenProjectReader.addProfileIfDoesNotExist(profile = new MavenProfile(id, source), result2)) continue;
            Element xmlActivation = MavenJDOMUtil.findChildByPath(each, "activation");
            if (xmlActivation != null) {
                Element xmlFile;
                MavenProfileActivation activation = new MavenProfileActivation();
                activation.setActiveByDefault("true".equals(MavenJDOMUtil.findChildValueByPath(xmlActivation, "activeByDefault")));
                Element xmlOS = MavenJDOMUtil.findChildByPath(xmlActivation, "os");
                if (xmlOS != null) {
                    activation.setOs(new MavenProfileActivationOS(MavenJDOMUtil.findChildValueByPath(xmlOS, "name"), MavenJDOMUtil.findChildValueByPath(xmlOS, "family"), MavenJDOMUtil.findChildValueByPath(xmlOS, "arch"), MavenJDOMUtil.findChildValueByPath(xmlOS, "version")));
                }
                activation.setJdk(MavenJDOMUtil.findChildValueByPath(xmlActivation, "jdk"));
                Element xmlProperty = MavenJDOMUtil.findChildByPath(xmlActivation, "property");
                if (xmlProperty != null) {
                    activation.setProperty(new MavenProfileActivationProperty(MavenJDOMUtil.findChildValueByPath(xmlProperty, "name"), MavenJDOMUtil.findChildValueByPath(xmlProperty, "value")));
                }
                if ((xmlFile = MavenJDOMUtil.findChildByPath(xmlActivation, "file")) != null) {
                    activation.setFile(new MavenProfileActivationFile(MavenJDOMUtil.findChildValueByPath(xmlFile, "exists"), MavenJDOMUtil.findChildValueByPath(xmlFile, "missing")));
                }
                profile.setActivation(activation);
            }
            MavenProjectReader.readModelBody((MavenModelBase)profile, profile.getBuild(), each);
        }
    }

    private static boolean addProfileIfDoesNotExist(MavenProfile profile, List<MavenProfile> result2) {
        for (MavenProfile each : result2) {
            if (!Objects.equals(each.getId(), profile.getId())) continue;
            return false;
        }
        result2.add(profile);
        return true;
    }

    private ProfileApplicationResult applyProfiles(MavenModel model, Path projectPomDir, Path basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return MavenServerManager.getInstance().getConnector(this.myProject, projectPomDir.toAbsolutePath().toString()).applyProfiles(model, basedir, explicitProfiles, alwaysOnProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenModel resolveInheritance(final MavenGeneralSettings generalSettings, MavenModel model, final Path projectPomDir, VirtualFile file, final MavenExplicitProfiles explicitProfiles, final Set<VirtualFile> recursionGuard, final MavenProjectReaderProjectLocator locator, Collection<MavenProjectProblem> problems) {
        if (recursionGuard.contains(file)) {
            problems.add(MavenProjectProblem.createProblem((String)file.getPath(), (String)MavenProjectBundle.message("maven.project.problem.recursiveInheritance", new Object[0]), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.PARENT, (boolean)false));
            return model;
        }
        recursionGuard.add(file);
        try {
            Pair parentModelWithProblems;
            final MavenParentDesc[] parentDesc = new MavenParentDesc[1];
            MavenParent parent = model.getParent();
            if (parent != null) {
                if (model.getMavenId().equals((Object)parent.getMavenId())) {
                    problems.add(MavenProjectProblem.createProblem((String)file.getPath(), (String)MavenProjectBundle.message("maven.project.problem.selfInheritance", new Object[0]), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.PARENT, (boolean)false));
                    MavenModel mavenModel = model;
                    return mavenModel;
                }
                parentDesc[0] = new MavenParentDesc(parent.getMavenId(), parent.getRelativePath());
            }
            if ((parentModelWithProblems = (Pair)new MavenParentProjectFileProcessor<Pair<VirtualFile, RawModelReadResult>>(this.myProject){

                @Override
                @Nullable
                protected VirtualFile findManagedFile(@NotNull MavenId id) {
                    if (id == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return locator.findProjectFile(id);
                }

                @Override
                @Nullable
                protected Pair<VirtualFile, RawModelReadResult> processRelativeParent(VirtualFile parentFile) {
                    MavenModel parentModel = MavenProjectReader.doReadProjectModel((Project)MavenProjectReader.this.myProject, (VirtualFile)parentFile, (boolean)true).model;
                    MavenId parentId2 = parentDesc[0].getParentId();
                    if (!parentId2.equals((Object)parentModel.getMavenId())) {
                        return null;
                    }
                    return (Pair)super.processRelativeParent(parentFile);
                }

                @Override
                protected Pair<VirtualFile, RawModelReadResult> processSuperParent(VirtualFile parentFile) {
                    return null;
                }

                @Override
                protected Pair<VirtualFile, RawModelReadResult> doProcessParent(VirtualFile parentFile) {
                    RawModelReadResult result2 = (RawModelReadResult)MavenProjectReader.this.doReadProjectModel((MavenGeneralSettings)generalSettings, (Path)projectPomDir, (VirtualFile)parentFile, (MavenExplicitProfiles)explicitProfiles, (Set<VirtualFile>)recursionGuard, (MavenProjectReaderProjectLocator)locator).first;
                    return Pair.create((Object)parentFile, (Object)result2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/project/MavenProjectReader$1", "findManagedFile"));
                }
            }.process(generalSettings, file, parentDesc[0])) == null) {
                MavenModel mavenModel = model;
                return mavenModel;
            }
            MavenModel parentModel = ((RawModelReadResult)parentModelWithProblems.second).model;
            if (!((RawModelReadResult)parentModelWithProblems.second).problems.isEmpty()) {
                problems.add(MavenProjectProblem.createProblem((String)((VirtualFile)parentModelWithProblems.first).getPath(), (String)MavenProjectBundle.message("maven.project.problem.parentHasProblems", parentModel.getMavenId()), (MavenProjectProblem.ProblemType)MavenProjectProblem.ProblemType.PARENT, (boolean)false));
            }
            model = this.myReadHelper.assembleInheritance(projectPomDir, parentModel, model);
            List profiles2 = model.getProfiles();
            for (MavenProfile each : parentModel.getProfiles()) {
                MavenProfile copyProfile = new MavenProfile(each.getId(), each.getSource());
                if (each.getActivation() != null) {
                    copyProfile.setActivation(each.getActivation().clone());
                }
                MavenProjectReader.addProfileIfDoesNotExist(copyProfile, profiles2);
            }
            MavenModel mavenModel = model;
            return mavenModel;
        }
        finally {
            recursionGuard.remove(file);
        }
    }

    @Deprecated(forRemoval=true)
    public Collection<MavenProjectReaderResult> resolveProject(MavenGeneralSettings generalSettings, MavenEmbedderWrapper embedder, Collection<VirtualFile> files2, MavenExplicitProfiles explicitProfiles, MavenProjectReaderProjectLocator locator) throws MavenProcessCanceledException {
        return MavenProjectResolutionUtil.resolveProjectSync(this, generalSettings, embedder, files2, explicitProfiles, locator, null, null, null, null, false);
    }

    private static void readModelBody(MavenModelBase mavenModelBase, MavenBuildBase mavenBuildBase, Element xmlModel) {
        mavenModelBase.setModules(MavenJDOMUtil.findChildrenValuesByPath(xmlModel, "modules", "module"));
        MavenProjectReader.collectProperties(MavenJDOMUtil.findChildByPath(xmlModel, "properties"), mavenModelBase);
        Element xmlBuild = MavenJDOMUtil.findChildByPath(xmlModel, "build");
        mavenBuildBase.setFinalName(MavenJDOMUtil.findChildValueByPath(xmlBuild, "finalName"));
        mavenBuildBase.setDefaultGoal(MavenJDOMUtil.findChildValueByPath(xmlBuild, "defaultGoal"));
        mavenBuildBase.setDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "directory"));
        mavenBuildBase.setResources(MavenProjectReader.collectResources(MavenJDOMUtil.findChildrenByPath(xmlBuild, "resources", "resource")));
        mavenBuildBase.setTestResources(MavenProjectReader.collectResources(MavenJDOMUtil.findChildrenByPath(xmlBuild, "testResources", "testResource")));
        mavenBuildBase.setFilters(MavenJDOMUtil.findChildrenValuesByPath(xmlBuild, "filters", "filter"));
        if (mavenBuildBase instanceof MavenBuild) {
            String testSource;
            MavenBuild mavenBuild = (MavenBuild)mavenBuildBase;
            String source = MavenJDOMUtil.findChildValueByPath(xmlBuild, "sourceDirectory");
            if (!StringUtil.isEmptyOrSpaces((String)source)) {
                mavenBuild.addSource(source);
            }
            if (!StringUtil.isEmptyOrSpaces((String)(testSource = MavenJDOMUtil.findChildValueByPath(xmlBuild, "testSourceDirectory")))) {
                mavenBuild.addTestSource(testSource);
            }
            mavenBuild.setOutputDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "outputDirectory"));
            mavenBuild.setTestOutputDirectory(MavenJDOMUtil.findChildValueByPath(xmlBuild, "testOutputDirectory"));
        }
    }

    private static List<MavenResource> collectResources(List<Element> xmlResources) {
        ArrayList<MavenResource> result2 = new ArrayList<MavenResource>();
        for (Element each : xmlResources) {
            String directory = MavenJDOMUtil.findChildValueByPath(each, "directory");
            boolean filtered = "true".equals(MavenJDOMUtil.findChildValueByPath(each, "filtering"));
            String targetPath = MavenJDOMUtil.findChildValueByPath(each, "targetPath");
            List<String> includes = MavenJDOMUtil.findChildrenValuesByPath(each, "includes", "include");
            List<String> excludes = MavenJDOMUtil.findChildrenValuesByPath(each, "excludes", "exclude");
            if (null == directory) continue;
            result2.add(new MavenResource(directory, filtered, targetPath, includes, excludes));
        }
        return result2;
    }

    private static void collectProperties(Element xmlProperties, MavenModelBase mavenModelBase) {
        if (xmlProperties == null) {
            return;
        }
        Properties props = mavenModelBase.getProperties();
        for (Element each : xmlProperties.getChildren()) {
            String name = each.getName();
            String value = each.getTextTrim();
            if (props.containsKey(name) || StringUtil.isEmptyOrSpaces((String)name)) continue;
            props.setProperty(name, value);
        }
    }

    private static Element readXml(final VirtualFile file, final Collection<MavenProjectProblem> problems, final MavenProjectProblem.ProblemType type2) {
        ReadStatisticsCollector.getInstance().fileRead(file);
        return MavenJDOMUtil.read(file, new MavenJDOMUtil.ErrorHandler(){

            @Override
            public void onReadError(IOException e) {
                MavenLog.LOG.warn("Cannot read the pom file: " + e);
                problems.add(MavenProjectProblem.createProblem((String)file.getPath(), (String)e.getMessage(), (MavenProjectProblem.ProblemType)type2, (boolean)false));
            }

            @Override
            public void onSyntaxError() {
                problems.add(MavenProjectProblem.createSyntaxProblem((String)file.getPath(), (MavenProjectProblem.ProblemType)type2));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectReader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateParentVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "repairResources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createResource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static final class RawModelReadResult {
        public MavenModel model;
        public Collection<MavenProjectProblem> problems;
        public Set<String> alwaysOnProfiles;

        private RawModelReadResult(MavenModel model, Collection<MavenProjectProblem> problems, Set<String> alwaysOnProfiles) {
            this.model = model;
            this.problems = problems;
            this.alwaysOnProfiles = alwaysOnProfiles;
        }
    }

    private static final class SettingsProfilesCache {
        final List<MavenProfile> profiles;
        final Set<String> alwaysOnProfiles;
        final Collection<MavenProjectProblem> problems;

        private SettingsProfilesCache(List<MavenProfile> profiles2, Set<String> alwaysOnProfiles, Collection<MavenProjectProblem> problems) {
            this.profiles = profiles2;
            this.alwaysOnProfiles = alwaysOnProfiles;
            this.problems = problems;
        }
    }
}

