/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerGoToAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.project.actions.MavenDependencyAnalazyerUtilKt;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/project/actions/MavenDependencyAnalyzerGoToAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerGoToAction;", "()V", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.maven"})
public final class MavenDependencyAnalyzerGoToAction
extends DependencyAnalyzerGoToAction {
    public MavenDependencyAnalyzerGoToAction() {
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        super(projectSystemId);
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)e.getData(DependencyAnalyzerView.Companion.getDEPENDENCY());
        if (dependencyAnalyzerDependency == null) {
            return null;
        }
        DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
        DependencyAnalyzerDependency dependencyAnalyzerDependency2 = dependency.getParent();
        if (dependencyAnalyzerDependency2 == null) {
            return null;
        }
        DependencyAnalyzerDependency parent = dependencyAnalyzerDependency2;
        MavenId mavenId2 = MavenDependencyAnalazyerUtilKt.getMavenId(dependency.getData());
        if (mavenId2 == null) {
            return null;
        }
        MavenId mavenId3 = mavenId2;
        String string = mavenId3.getGroupId();
        if (string == null) {
            return null;
        }
        String groupId = string;
        String string2 = mavenId3.getArtifactId();
        if (string2 == null) {
            return null;
        }
        String artifactId = string2;
        VirtualFile virtualFile = MavenDependencyAnalazyerUtilKt.getArtifactFile(project3, parent.getData());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile artifactFile = virtualFile;
        return MavenNavigationUtil.createNavigatableForDependency(project3, artifactFile, groupId, artifactId);
    }
}

