/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.externalSystem.autoimport.settings.ReadAsyncSupplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenCoroutineScopeProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J(\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020 H\u0016J<\u0010!\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2*\u0010\"\u001a&\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019\u0012\u0004\u0012\u00020\u001f0#H\u0002J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "project", "Lcom/intellij/openapi/project/Project;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Lorg/jetbrains/idea/maven/project/MavenProjectsManager;Ljava/util/concurrent/ExecutorService;)V", "isImportCompleted", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "settingsFiles", "", "", "getSettingsFiles", "()Ljava/util/Set;", "collectSettingsFiles", "hasPomFile", "", "rootDirectory", "partitionSettingsFiles", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "reloadProject", "", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "submitSettingsFilesPartition", "action", "Lkotlin/Function1;", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectAware.kt\norg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n12474#2,2:135\n1549#3:137\n1620#3,3:138\n*S KotlinDebug\n*F\n+ 1 MavenProjectAware.kt\norg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware\n*L\n97#1:135,2\n105#1:137\n105#1:138,3\n*E\n"})
public final class MavenProjectAware
implements ExternalSystemProjectAware {
    @NotNull
    private final Project project;
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final MavenProjectsManager manager;
    @NotNull
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final AtomicBooleanProperty isImportCompleted;

    public MavenProjectAware(@NotNull Project project2, @NotNull ExternalSystemProjectId projectId, @NotNull MavenProjectsManager manager, @NotNull ExecutorService backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        this.project = project2;
        this.projectId = projectId;
        this.manager = manager;
        this.backgroundExecutor = backgroundExecutor;
        this.isImportCompleted = new AtomicBooleanProperty(true);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.manager);
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MavenImportListener(){

            @Override
            public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
                Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
                Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
                isImportCompleted.set(true);
            }

            @Override
            public void importStarted() {
                isImportCompleted.set(false);
            }
        });
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return this.collectSettingsFiles();
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.isImportCompleted.afterReset(parentDisposable, (Function0)new Function0<Unit>(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$listener.onProjectReloadStart();
            }
        });
        this.isImportCompleted.afterSet(parentDisposable, (Function0)new Function0<Unit>(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$listener.onProjectReloadFinish(ExternalSystemRefreshStatus.SUCCESS);
            }
        });
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ApplicationManager.getApplication().invokeAndWait(MavenProjectAware::reloadProject$lambda$0);
        CoroutineScope cs = MavenCoroutineScopeProvider.Companion.getCoroutineScope(this.project);
        if (context2.getHasUndefinedModifications()) {
            BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, context2, null){
                int label;
                final /* synthetic */ MavenProjectAware this$0;
                final /* synthetic */ ExternalSystemProjectReloadContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MavenProjectAware.access$getManager$p(this.this$0).findAllAvailablePomFilesIfNotMavenized();
                            this.label = 1;
                            Object object3 = MavenProjectAware.access$getManager$p(this.this$0).updateAllMavenProjects(new MavenImportSpec(true, true, this.$context.isExplicitReload()), (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            ExternalSystemSettingsFilesReloadContext settingsFilesContext = context2.getSettingsFilesContext();
            this.submitSettingsFilesPartition(settingsFilesContext, (Function1<? super Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>, Unit>)((Function1)new Function1<Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>, Unit>(settingsFilesContext, cs, this, context2){
                final /* synthetic */ ExternalSystemSettingsFilesReloadContext $settingsFilesContext;
                final /* synthetic */ CoroutineScope $cs;
                final /* synthetic */ MavenProjectAware this$0;
                final /* synthetic */ ExternalSystemProjectReloadContext $context;
                {
                    this.$settingsFilesContext = $settingsFilesContext;
                    this.$cs = $cs;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    List filesToUpdate = (List)pair.component1();
                    List filesToDelete = (List)pair.component2();
                    Set updated = SetsKt.plus((Set)this.$settingsFilesContext.getCreated(), (Iterable)this.$settingsFilesContext.getUpdated());
                    Set deleted = this.$settingsFilesContext.getDeleted();
                    if (updated.size() == filesToUpdate.size() && deleted.size() == filesToDelete.size()) {
                        BuildersKt.launch$default((CoroutineScope)this.$cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$context, (List<? extends VirtualFile>)filesToUpdate, (List<? extends VirtualFile>)filesToDelete, null){
                            int label;
                            final /* synthetic */ MavenProjectAware this$0;
                            final /* synthetic */ ExternalSystemProjectReloadContext $context;
                            final /* synthetic */ List<VirtualFile> $filesToUpdate;
                            final /* synthetic */ List<VirtualFile> $filesToDelete;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                                this.$filesToUpdate = $filesToUpdate;
                                this.$filesToDelete = $filesToDelete;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = MavenProjectAware.access$getManager$p(this.this$0).updateMavenProjects(new MavenImportSpec(true, true, this.$context.isExplicitReload()), this.$filesToUpdate, this.$filesToDelete, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    } else {
                        BuildersKt.launch$default((CoroutineScope)this.$cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$context, null){
                            int label;
                            final /* synthetic */ MavenProjectAware this$0;
                            final /* synthetic */ ExternalSystemProjectReloadContext $context;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        MavenProjectAware.access$getManager$p(this.this$0).findAllAvailablePomFilesIfNotMavenized();
                                        this.label = 1;
                                        Object object3 = MavenProjectAware.access$getManager$p(this.this$0).updateAllMavenProjects(new MavenImportSpec(false, true, this.$context.isExplicitReload()), (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
            }));
        }
    }

    private final void submitSettingsFilesPartition(ExternalSystemSettingsFilesReloadContext context2, Function1<? super Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>, Unit> action) {
        new ReadAsyncSupplier.Builder((Function0)new Function0<Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>>(this, context2){
            final /* synthetic */ MavenProjectAware this$0;
            final /* synthetic */ ExternalSystemSettingsFilesReloadContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Pair<List<VirtualFile>, List<VirtualFile>> invoke() {
                return MavenProjectAware.access$partitionSettingsFiles(this.this$0, this.$context);
            }
        }).build((Executor)this.backgroundExecutor).supply((Disposable)this.manager, action);
    }

    private final Pair<List<VirtualFile>, List<VirtualFile>> partitionSettingsFiles(ExternalSystemSettingsFilesReloadContext context2) {
        List updated = new ArrayList();
        List deleted = new ArrayList();
        for (VirtualFile projectsFile : this.manager.getProjectsTree().getProjectsFiles()) {
            String path2;
            Intrinsics.checkNotNullExpressionValue((Object)projectsFile.getPath(), (String)"getPath(...)");
            if (context2.getCreated().contains(path2)) {
                Intrinsics.checkNotNull((Object)projectsFile);
                updated.add(projectsFile);
            }
            if (context2.getUpdated().contains(path2)) {
                Intrinsics.checkNotNull((Object)projectsFile);
                updated.add(projectsFile);
            }
            if (!context2.getDeleted().contains(path2)) continue;
            Intrinsics.checkNotNull((Object)projectsFile);
            deleted.add(projectsFile);
        }
        return TuplesKt.to((Object)updated, (Object)deleted);
    }

    private final boolean hasPomFile(String rootDirectory) {
        boolean bl;
        block1: {
            MavenProjectsTree mavenProjectsTree = this.manager.getProjectsTree();
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsTree, (String)"getProjectsTree(...)");
            MavenProjectsTree projectTree = mavenProjectsTree;
            Intrinsics.checkNotNullExpressionValue((Object)MavenConstants.POM_NAMES, (String)"POM_NAMES");
            Object[] $this$any$iv = MavenConstants.POM_NAMES;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!projectTree.isPotentialProject(rootDirectory + "/" + it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectSettingsFiles() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LinkedHashSet<CallSite> result2 = new LinkedHashSet<CallSite>();
        result2.addAll((Collection)this.manager.getProjectsTree().getManagedFilesPaths());
        List<VirtualFile> list = this.manager.getProjectsTree().getProjectsFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProjectsFiles(...)");
        Iterable iterable = list;
        LinkedHashSet<CallSite> linkedHashSet = result2;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        linkedHashSet.addAll((List)destination$iv$iv);
        for (MavenProject mavenProject2 : this.manager.getProjectsTree().getProjects()) {
            String rootDirectory;
            ProgressManager.checkCanceled();
            result2.addAll((Collection)mavenProject2.getModulePaths());
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject2.getDirectory(), (String)"getDirectory(...)");
            result2.add((CallSite)((Object)(rootDirectory + "//.mvn/jvm.config")));
            result2.add((CallSite)((Object)(rootDirectory + "//.mvn/maven.config")));
            result2.add((CallSite)((Object)(rootDirectory + "//.mvn/wrapper/maven-wrapper.properties")));
            if (!this.hasPomFile(rootDirectory)) continue;
            result2.add((CallSite)((Object)(rootDirectory + "/profiles.xml")));
        }
        return result2;
    }

    private static final void reloadProject$lambda$0() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    public static final /* synthetic */ MavenProjectsManager access$getManager$p(MavenProjectAware $this) {
        return $this.manager;
    }

    public static final /* synthetic */ Pair access$partitionSettingsFiles(MavenProjectAware $this, ExternalSystemSettingsFilesReloadContext context2) {
        return $this.partitionSettingsFiles(context2);
    }
}

