/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnectorBase;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenIndexingConnectorImpl
extends MavenServerConnectorBase {
    public static final Logger LOG = Logger.getInstance(MavenIndexingConnectorImpl.class);

    public MavenIndexingConnectorImpl(@NotNull Sdk jdk2, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        if (jdk2 == null) {
            MavenIndexingConnectorImpl.$$$reportNull$$$0(0);
        }
        if (vmOptions == null) {
            MavenIndexingConnectorImpl.$$$reportNull$$$0(1);
        }
        if (mavenDistribution == null) {
            MavenIndexingConnectorImpl.$$$reportNull$$$0(2);
        }
        if (multimoduleDirectory == null) {
            MavenIndexingConnectorImpl.$$$reportNull$$$0(3);
        }
        super(null, jdk2, vmOptions, mavenDistribution, multimoduleDirectory, debugPort);
        this.throwExceptionIfProjectDisposed = false;
    }

    @Override
    public boolean isCompatibleWith(Sdk jdk2, String vmOptions, MavenDistribution distribution) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected StartIndexingServerTask newStartServerTask() {
        return new StartIndexingServerTask();
    }

    @Override
    protected void cleanUpFutures() {
    }

    @Override
    public String getSupportType() {
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        return support == null ? "INDEX-?" : "INDEX-" + support.type();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "jdk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "vmOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenDistribution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "multimoduleDirectory";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/server/MavenIndexingConnectorImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class StartIndexingServerTask
    implements Runnable {
        private StartIndexingServerTask() {
        }

        @Override
        public void run() {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            String dirForLogs = (String)MavenIndexingConnectorImpl.this.myMultimoduleDirectories.iterator().next();
            MavenLog.LOG.debug("Connecting maven connector in " + dirForLogs);
            try {
                if (MavenIndexingConnectorImpl.this.myDebugPort != null) {
                    System.out.println("Listening for transport dt_socket at address: " + MavenIndexingConnectorImpl.this.myDebugPort);
                }
                MavenRemoteProcessSupportFactory factory = MavenRemoteProcessSupportFactory.forIndexer();
                MavenIndexingConnectorImpl.this.mySupport = factory.createIndexerSupport(MavenIndexingConnectorImpl.this.myJdk, MavenIndexingConnectorImpl.this.myVmOptions, MavenIndexingConnectorImpl.this.myDistribution, MavenIndexingConnectorImpl.this.myDebugPort);
                MavenIndexingConnectorImpl.this.mySupport.onTerminate(e -> {
                    MavenLog.LOG.debug("[connector] terminate " + MavenIndexingConnectorImpl.this);
                    MavenServerManager.getInstance().shutdownConnector(MavenIndexingConnectorImpl.this, false);
                });
                try (AccessToken ignored = ThreadContext.resetThreadContext();){
                    MavenServer server = (MavenServer)MavenIndexingConnectorImpl.this.mySupport.acquire(this, "", (ProgressIndicator)indicator);
                    MavenIndexingConnectorImpl.this.myServerPromise.setResult((Object)server);
                }
                MavenLog.LOG.debug("[connector] in " + dirForLogs + " has been connected " + MavenIndexingConnectorImpl.this);
            }
            catch (Throwable e2) {
                MavenLog.LOG.warn("[connector] cannot connect in " + dirForLogs, e2);
                MavenIndexingConnectorImpl.this.myServerPromise.setError(e2);
            }
        }
    }
}

