/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.wsl.WSLDistribution;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "pathToMaven", "", "name", "(Lcom/intellij/execution/wsl/WSLDistribution;Ljava/lang/String;Ljava/lang/String;)V", "mavenHome", "Ljava/nio/file/Path;", "getMavenHome", "()Ljava/nio/file/Path;", "getName", "()Ljava/lang/String;", "version", "getVersion", "version$delegate", "Lkotlin/Lazy;", "compatibleWith", "", "mavenDistribution", "isValid", "toString", "intellij.maven"})
public final class WslMavenDistribution
implements MavenDistribution {
    @NotNull
    private final WSLDistribution wslDistribution;
    @NotNull
    private final String pathToMaven;
    @NotNull
    private final String name;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Path mavenHome;

    public WslMavenDistribution(@NotNull WSLDistribution wslDistribution, @NotNull String pathToMaven, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)wslDistribution, (String)"wslDistribution");
        Intrinsics.checkNotNullParameter((Object)pathToMaven, (String)"pathToMaven");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.wslDistribution = wslDistribution;
        this.pathToMaven = pathToMaven;
        this.name = name;
        this.version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ WslMavenDistribution this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return MavenUtil.getMavenVersion(WslMavenDistribution.access$getWslDistribution$p(this.this$0).getWindowsPath(WslMavenDistribution.access$getPathToMaven$p(this.this$0)));
            }
        }));
        String string = this.wslDistribution.getWindowsPath(this.pathToMaven);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        this.mavenHome = path2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getVersion() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Path getMavenHome() {
        return this.mavenHome;
    }

    @Override
    public boolean compatibleWith(@NotNull MavenDistribution mavenDistribution) {
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        if (Intrinsics.areEqual((Object)mavenDistribution, (Object)this)) {
            return true;
        }
        WslMavenDistribution wslMavenDistribution = mavenDistribution instanceof WslMavenDistribution ? (WslMavenDistribution)mavenDistribution : null;
        if (wslMavenDistribution == null) {
            return false;
        }
        WslMavenDistribution another = wslMavenDistribution;
        return Intrinsics.areEqual((Object)another.wslDistribution, (Object)this.wslDistribution) && Intrinsics.areEqual((Object)another.pathToMaven, (Object)this.pathToMaven);
    }

    @Override
    public boolean isValid() {
        return this.getVersion() != null;
    }

    @NotNull
    public String toString() {
        return this.getName() + "(" + this.getMavenHome() + ") v " + this.getVersion();
    }

    public static final /* synthetic */ WSLDistribution access$getWslDistribution$p(WslMavenDistribution $this) {
        return $this.wslDistribution;
    }

    public static final /* synthetic */ String access$getPathToMaven$p(WslMavenDistribution $this) {
        return $this.pathToMaven;
    }
}

