/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.jlanguage;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.broker.GrazieDynamicDataBroker;
import com.intellij.grazie.jlanguage.filters.UppercaseMatchFilter;
import com.intellij.grazie.jlanguage.hunspell.LuceneHunspellDictionary;
import com.intellij.grazie.utils.JLangUtilsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.Tag;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0007J\u0015\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0016J\u0014\u0010&\u001a\u00020\u0018*\u00020'2\u0006\u0010(\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/grazie/jlanguage/LangTool;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "()V", "MINIMUM_EXAMPLE_SIMILARITY", "", "langs", "", "Lcom/intellij/grazie/jlanguage/Lang;", "Lorg/languagetool/JLanguageTool;", "levenshtein", "Lorg/apache/commons/text/similarity/LevenshteinDistance;", "rulesEnabledByDefault", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "createTool", "lang", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "createTool$intellij_grazie_core", "getTool", "globalIdPrefix", "globalIdPrefix$intellij_grazie_core", "isRuleEnabledByDefault", "", "ruleId", "isRuleEnabledByDefault$intellij_grazie_core", "prepareForNoChunkTags", "", "rule", "Lorg/languagetool/rules/Rule;", "removeVerySimilarExamples", "", "Lorg/languagetool/rules/IncorrectExample;", "examples", "update", "prevState", "newState", "isSimilarTo", "", "sequence", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangTool.kt\ncom/intellij/grazie/jlanguage/LangTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1#2:190\n1#2:201\n1#2:214\n1603#3,9:191\n1855#3:200\n1856#3:202\n1612#3:203\n1603#3,9:204\n1855#3:213\n1856#3:215\n1612#3:216\n1855#3,2:217\n1855#3,2:219\n1855#3,2:221\n1855#3,2:223\n1855#3,2:225\n2624#3,3:227\n1855#3,2:230\n1855#3,2:232\n1855#3,2:234\n*S KotlinDebug\n*F\n+ 1 LangTool.kt\ncom/intellij/grazie/jlanguage/LangTool\n*L\n72#1:201\n73#1:214\n72#1:191,9\n72#1:200\n72#1:202\n72#1:203\n73#1:204,9\n73#1:213\n73#1:215\n73#1:216\n75#1:217,2\n76#1:219,2\n111#1:221,2\n146#1:223,2\n149#1:225,2\n155#1:227,3\n140#1:230,2\n141#1:232,2\n142#1:234,2\n*E\n"})
public final class LangTool
implements GrazieStateLifecycle {
    @NotNull
    public static final LangTool INSTANCE = new LangTool();
    @NotNull
    private static final Map<Lang, JLanguageTool> langs;
    @NotNull
    private static final ConcurrentHashMap<Lang, Set<String>> rulesEnabledByDefault;
    private static final double MINIMUM_EXAMPLE_SIMILARITY = 0.2;
    @NotNull
    private static final LevenshteinDistance levenshtein;

    private LangTool() {
    }

    @NotNull
    public final String globalIdPrefix$intellij_grazie_core(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return "LanguageTool." + lang.getRemote().getIso().name() + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final JLanguageTool getTool(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        while (true) {
            JLanguageTool tool = null;
            tool = langs.get((Object)lang);
            if (tool != null) {
                return tool;
            }
            GrazieConfig.State state = GrazieConfig.Companion.get();
            tool = this.createTool$intellij_grazie_core(lang, state);
            Map<Lang, JLanguageTool> map = langs;
            synchronized (map) {
                boolean bl = false;
                if (state == GrazieConfig.Companion.get()) {
                    JLanguageTool alreadyComputed;
                    JLanguageTool jLanguageTool = alreadyComputed = langs.get((Object)lang);
                    if (jLanguageTool != null) {
                        return jLanguageTool;
                    }
                    langs.put(lang, tool);
                    return tool;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JLanguageTool createTool$intellij_grazie_core(@NotNull Lang lang, @NotNull GrazieConfig.State state) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        JLanguageTool jLanguageTool;
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Language jLanguage = lang.getJLanguage();
        if (!(jLanguage != null)) {
            boolean $i$a$-require-LangTool$createTool$22 = false;
            String $i$a$-require-LangTool$createTool$22 = "Trying to get LangTool for not available language";
            throw new IllegalArgumentException($i$a$-require-LangTool$createTool$22.toString());
        }
        JLanguageTool $this$createTool_u24lambda_u2410 = jLanguageTool = new JLanguageTool(jLanguage, null, new ResultCache(10000L));
        boolean bl = false;
        $this$createTool_u24lambda_u2410.setCheckCancelledCallback(LangTool::createTool$lambda$10$lambda$3);
        $this$createTool_u24lambda_u2410.addMatchFilter(new UppercaseMatchFilter());
        String prefix = INSTANCE.globalIdPrefix$intellij_grazie_core(lang);
        Iterable $this$mapNotNull$iv = state.getUserDisabledRules();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                String string3 = it.substring(prefix.length());
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            String it$iv$iv = string2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set disabledRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = state.getUserEnabledRules();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            String string4;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            String it = (String)element$iv$iv;
            boolean bl6 = false;
            if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                String string5 = it.substring(prefix.length());
                string4 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string4 = null;
            }
            if (string4 == null) continue;
            String it$iv$iv = string4;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set enabledRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$forEach$iv = disabledRules;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl8 = false;
            $this$createTool_u24lambda_u2410.disableRule(id);
        }
        $this$forEach$iv = enabledRules;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl9 = false;
            $this$createTool_u24lambda_u2410.enableRule(id);
        }
        LangTool.createTool$lambda$10$loadConfigFile("en/enabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(lang, (Set<String>)disabledRules, $this$createTool_u24lambda_u2410){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ Set<String> $disabledRules;
            final /* synthetic */ JLanguageTool $this_apply;
            {
                this.$lang = $lang;
                this.$disabledRules = $disabledRules;
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String ruleId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang.getIso().name()) && !this.$disabledRules.contains(ruleId)) {
                    this.$this_apply.enableRule(ruleId);
                }
            }
        }));
        LangTool.createTool$lambda$10$loadConfigFile("en/disabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(lang, (Set<String>)enabledRules, $this$createTool_u24lambda_u2410){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ Set<String> $enabledRules;
            final /* synthetic */ JLanguageTool $this_apply;
            {
                this.$lang = $lang;
                this.$enabledRules = $enabledRules;
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String ruleId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang.getIso().name()) && !this.$enabledRules.contains(ruleId)) {
                    this.$this_apply.disableRule(ruleId);
                }
            }
        }));
        LangTool.createTool$lambda$10$loadConfigFile("en/enabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(lang, $this$createTool_u24lambda_u2410){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ JLanguageTool $this_apply;
            {
                this.$lang = $lang;
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String categoryId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang.getIso().name())) {
                    this.$this_apply.enableRuleCategory(new CategoryId(categoryId));
                }
            }
        }));
        LangTool.createTool$lambda$10$loadConfigFile("en/disabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(lang, $this$createTool_u24lambda_u2410){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ JLanguageTool $this_apply;
            {
                this.$lang = $lang;
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String categoryId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang.getIso().name())) {
                    this.$this_apply.disableCategory(new CategoryId(categoryId));
                }
            }
        }));
        List<SpellingCheckRule> list = $this$createTool_u24lambda_u2410.getAllSpellingCheckRules();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSpellingCheckRules(...)");
        $this$forEach$iv = list;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            SpellingCheckRule rule = (SpellingCheckRule)element$iv;
            boolean bl10 = false;
            $this$createTool_u24lambda_u2410.disableRule(rule.getId());
        }
        for (Rule rule : $this$createTool_u24lambda_u2410.getAllActiveRules()) {
            if (!rule.hasTag(Tag.picky) || enabledRules.contains(rule.getId())) continue;
            $this$createTool_u24lambda_u2410.disableRule(rule.getId());
        }
        for (Rule rule : $this$createTool_u24lambda_u2410.getAllRules()) {
            ProgressManager.checkCanceled();
            rule.setCorrectExamples(CollectionsKt.emptyList());
            rule.setErrorTriggeringExamples(CollectionsKt.emptyList());
            List<IncorrectExample> list2 = rule.getIncorrectExamples();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getIncorrectExamples(...)");
            rule.setIncorrectExamples(INSTANCE.removeVerySimilarExamples(list2));
            if (!Lang.Companion.shouldDisableChunker$intellij_grazie_core(jLanguage)) continue;
            Intrinsics.checkNotNull((Object)rule);
            INSTANCE.prepareForNoChunkTags(rule);
        }
        $this$createTool_u24lambda_u2410.getLanguage().getDisambiguator();
        return jLanguageTool;
    }

    private final void prepareForNoChunkTags(Rule rule) {
        if (rule instanceof AbstractPatternRule) {
            List<PatternToken> list = ((AbstractPatternRule)rule).getPatternTokens();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PatternToken it = (PatternToken)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    LangTool.prepareForNoChunkTags$relaxChunkConditions(it, true);
                }
            }
        }
        List<DisambiguationPatternRule> list = rule.getAntiPatterns();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAntiPatterns(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<PatternToken> list2;
            DisambiguationPatternRule it = (DisambiguationPatternRule)element$iv;
            boolean bl = false;
            List<PatternToken> list3 = list2 = it.getPatternTokens();
            if (list3 == null) continue;
            Intrinsics.checkNotNull(list3);
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PatternToken token = (PatternToken)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)token);
                LangTool.prepareForNoChunkTags$relaxChunkConditions(token, false);
            }
        }
    }

    private final List<IncorrectExample> removeVerySimilarExamples(List<IncorrectExample> examples) {
        ArrayList<IncorrectExample> accepted = new ArrayList<IncorrectExample>();
        for (IncorrectExample example : examples) {
            Object v3;
            block6: {
                boolean bl;
                block5: {
                    Iterable $this$none$iv = accepted;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            IncorrectExample it = (IncorrectExample)element$iv;
                            boolean bl2 = false;
                            if (!INSTANCE.isSimilarTo(JLangUtilsKt.getText(it), JLangUtilsKt.getText(example))) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                List<String> list = example.getCorrections();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCorrections(...)");
                Iterable iterable = list;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    String it = (String)t;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl4) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            String firstCorrection = v3;
            accepted.add(new IncorrectExample(example.getExample(), ContainerUtil.createMaybeSingletonList((Object)firstCorrection)));
            if (accepted.size() <= 5) continue;
            break;
        }
        return accepted;
    }

    private final boolean isSimilarTo(CharSequence $this$isSimilarTo, CharSequence sequence2) {
        return (double)levenshtein.apply($this$isSimilarTo, sequence2).intValue() / (double)$this$isSimilarTo.length() < 0.2;
    }

    public final boolean isRuleEnabledByDefault$intellij_grazie_core(@NotNull Lang lang, @NotNull String ruleId) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        Set set = rulesEnabledByDefault.computeIfAbsent(lang, arg_0 -> LangTool.isRuleEnabledByDefault$lambda$19((Function1)new Function1<Lang, Set<? extends String>>(lang){
            final /* synthetic */ Lang $lang;
            {
                this.$lang = $lang;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<String> invoke(@NotNull Lang it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                List<Rule> list = LangTool.INSTANCE.createTool$intellij_grazie_core(this.$lang, new GrazieConfig.State(null, null, null, false, null, null, null, null, null, null, 1023, null)).getAllActiveRules();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAllActiveRules(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Rule rule = (Rule)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getId());
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set activeIds2 = set;
        return activeIds2.contains(ruleId);
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (Intrinsics.areEqual(prevState.getAvailableLanguages(), newState.getAvailableLanguages()) && Intrinsics.areEqual(prevState.getUserDisabledRules(), newState.getUserDisabledRules()) && Intrinsics.areEqual(prevState.getUserEnabledRules(), newState.getUserEnabledRules())) {
            return;
        }
        langs.clear();
        rulesEnabledByDefault.clear();
    }

    private static final Class _init_$lambda$0(String qualifiedName) {
        Intrinsics.checkNotNull((Object)qualifiedName);
        Class<?> clazz = GrazieDynamic.INSTANCE.loadClass(qualifiedName);
        if (clazz == null) {
            throw new ClassNotFoundException(qualifiedName);
        }
        return clazz;
    }

    private static final boolean createTool$lambda$10$lambda$3() {
        ProgressManager.checkCanceled();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createTool$lambda$10$loadConfigFile(String path, Function2<? super String, ? super String, Unit> block) {
        Closeable closeable = GrazieDynamicDataBroker.INSTANCE.getFromResourceDirAsStream(path);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), (Function1)((Function1)new Function1<String, Unit>(block){
                final /* synthetic */ Function2<String, String, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    char[] cArray = new char[]{':'};
                    List list = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    String iso = (String)list.get(0);
                    String id = (String)list.get(1);
                    this.$block.invoke((Object)iso, (Object)id);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void prepareForNoChunkTags$relaxChunkConditions(PatternToken token, boolean positive) {
        PatternToken it;
        if (token.getNegation() == positive && token.getChunkTag() != null) {
            token.setChunkTag(null);
        }
        List<PatternToken> list = token.getAndGroup();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAndGroup(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, positive);
        }
        List<PatternToken> list2 = token.getOrGroup();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getOrGroup(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, positive);
        }
        List list3 = token.getExceptionList();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, !positive);
        }
    }

    private static final Set isRuleEnabledByDefault$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    static {
        Map map = Collections.synchronizedMap(ContainerUtil.createSoftValueMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        langs = map;
        rulesEnabledByDefault = new ConcurrentHashMap();
        JLanguageTool.useCustomPasswordAuthenticator(false);
        JLanguageTool.setDataBroker(GrazieDynamicDataBroker.INSTANCE);
        JLanguageTool.setClassBrokerBroker(LangTool::_init_$lambda$0);
        Hunspell.setHunspellDictionaryFactory(LuceneHunspellDictionary::new);
        levenshtein = new LevenshteinDistance();
    }
}

