/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.NumberQuantity;
import tech.units.indriya.quantity.Quantities;

final class DoubleQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 8660843078156312278L;
    final double value;

    public DoubleQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) throws ArithmeticException {
        BigDecimal decimal = BigDecimal.valueOf(this.value);
        return Calculus.toBigDecimal(super.getUnit().getConverterTo(unit).convert(decimal));
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result2 = this.doubleValue(unit);
        if (result2 < -9.223372036854776E18 || result2 > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result2 + ")");
        }
        return (long)result2;
    }

    private ComparableQuantity<Q> addRaw(Number a, Number b, Unit<Q> unit) {
        return NumberQuantity.of(a.doubleValue() + b.doubleValue(), unit);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        Quantity<Q> thatConverted = that.to(this.getUnit());
        Quantity thisConverted = this.to((Unit)that.getUnit());
        double resultValueInThisUnit = this.getValue() + thatConverted.getValue().doubleValue();
        double resultValueInThatUnit = thisConverted.getValue().doubleValue() + that.getValue().doubleValue();
        ComparableQuantity resultInThisUnit = this.addRaw(this.getValue(), thatConverted.getValue(), this.getUnit());
        ComparableQuantity<Q> resultInThatUnit = this.addRaw(thisConverted.getValue(), that.getValue(), that.getUnit());
        if (Double.isInfinite(resultValueInThisUnit) && Double.isInfinite(resultValueInThatUnit)) {
            throw new ArithmeticException();
        }
        if (Double.isInfinite(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        AbstractQuantity<Q> thatNegated = NumberQuantity.of(-that.getValue().doubleValue(), that.getUnit());
        return this.add((Quantity)thatNegated);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new DoubleQuantity(this.value * that.getValue().doubleValue(), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value * that.doubleValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new DoubleQuantity(this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value / that.doubleValue(), this.getUnit());
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return (AbstractQuantity)Quantities.getQuantity(1.0 / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

